/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import java.util.Hashtable;

public class Codon {
    private static Hashtable<String, Character> table = new Hashtable();

    public static char translate(String codon) {
        Character aa = table.get(codon);
        if (aa == null) {
            return '\u0000';
        }
        return aa.charValue();
    }

    public static char translateRevComplement(String codon) {
        StringBuffer revComp = new StringBuffer();
        for (int i = codon.length() - 1; i >= 0; --i) {
            revComp.append(Codon.complement(codon.charAt(i)));
        }
        Character aa = table.get(revComp.toString());
        if (aa == null) {
            return '\u0000';
        }
        return aa.charValue();
    }

    public static char complement(char aa) {
        if (aa == 'A') {
            return 'T';
        }
        if (aa == 'T') {
            return 'A';
        }
        if (aa == 'G') {
            return 'C';
        }
        if (aa == 'C') {
            return 'G';
        }
        return '\u0000';
    }

    static {
        table.put("ATT", Character.valueOf('I'));
        table.put("ATC", Character.valueOf('I'));
        table.put("ATA", Character.valueOf('I'));
        table.put("CTT", Character.valueOf('L'));
        table.put("CTC", Character.valueOf('L'));
        table.put("CTA", Character.valueOf('L'));
        table.put("CTG", Character.valueOf('L'));
        table.put("TTA", Character.valueOf('L'));
        table.put("TTG", Character.valueOf('L'));
        table.put("GTT", Character.valueOf('V'));
        table.put("GTC", Character.valueOf('V'));
        table.put("GTA", Character.valueOf('V'));
        table.put("GTG", Character.valueOf('V'));
        table.put("TTT", Character.valueOf('F'));
        table.put("TTC", Character.valueOf('F'));
        table.put("ATG", Character.valueOf('M'));
        table.put("TGT", Character.valueOf('C'));
        table.put("TGC", Character.valueOf('C'));
        table.put("GCT", Character.valueOf('A'));
        table.put("GCC", Character.valueOf('A'));
        table.put("GCA", Character.valueOf('A'));
        table.put("GCG", Character.valueOf('A'));
        table.put("GGT", Character.valueOf('G'));
        table.put("GGC", Character.valueOf('G'));
        table.put("GGA", Character.valueOf('G'));
        table.put("GGG", Character.valueOf('G'));
        table.put("CCT", Character.valueOf('P'));
        table.put("CCC", Character.valueOf('P'));
        table.put("CCA", Character.valueOf('P'));
        table.put("CCG", Character.valueOf('P'));
        table.put("ACT", Character.valueOf('T'));
        table.put("ACC", Character.valueOf('T'));
        table.put("ACA", Character.valueOf('T'));
        table.put("ACG", Character.valueOf('T'));
        table.put("TCT", Character.valueOf('S'));
        table.put("TCC", Character.valueOf('S'));
        table.put("TCA", Character.valueOf('S'));
        table.put("TCG", Character.valueOf('S'));
        table.put("AGT", Character.valueOf('S'));
        table.put("AGC", Character.valueOf('S'));
        table.put("TAT", Character.valueOf('Y'));
        table.put("TAC", Character.valueOf('Y'));
        table.put("TGG", Character.valueOf('W'));
        table.put("CAA", Character.valueOf('Q'));
        table.put("CAG", Character.valueOf('Q'));
        table.put("AAT", Character.valueOf('N'));
        table.put("AAC", Character.valueOf('N'));
        table.put("CAT", Character.valueOf('H'));
        table.put("CAC", Character.valueOf('H'));
        table.put("GAA", Character.valueOf('E'));
        table.put("GAG", Character.valueOf('E'));
        table.put("GAT", Character.valueOf('D'));
        table.put("GAC", Character.valueOf('D'));
        table.put("AAA", Character.valueOf('K'));
        table.put("AAG", Character.valueOf('K'));
        table.put("CGT", Character.valueOf('R'));
        table.put("CGC", Character.valueOf('R'));
        table.put("CGA", Character.valueOf('R'));
        table.put("CGG", Character.valueOf('R'));
        table.put("AGA", Character.valueOf('R'));
        table.put("AGG", Character.valueOf('R'));
        table.put("TAA", Character.valueOf('X'));
        table.put("TAG", Character.valueOf('X'));
        table.put("TGA", Character.valueOf('X'));
    }
}

