/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import edu.ucsd.msjava.msdictionary.Codon;
import edu.ucsd.msjava.parser.FullyBufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class GenomeTranslator {
    private static final int MIN_PROTEIN_SIZE = 6;
    private final String fileName;

    public GenomeTranslator(String genomeFileName) {
        this.fileName = genomeFileName;
    }

    public void translateAndWriteTo(String outputFileName) {
        String s;
        FullyBufferedLineReader reader = new FullyBufferedLineReader(this.fileName);
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String annotation = null;
        StringBuffer segment = null;
        int segmentPos = 0;
        int curPosition = 0;
        while ((s = reader.readLine()) != null) {
            if (s.startsWith(">")) {
                System.out.println("Processing " + s);
                if (segment != null) {
                    this.writeSixFrameTranslation(annotation, segmentPos, segment.toString(), out);
                }
                String[] token = s.split("\\s+");
                assert (token[0].length() > 1);
                annotation = token[0].substring(1);
                segment = null;
                curPosition = 0;
                continue;
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = Character.toUpperCase(s.charAt(i));
                if (c == 'A' || c == 'T' || c == 'C' || c == 'G') {
                    if (segment == null) {
                        segment = new StringBuffer();
                        segmentPos = curPosition;
                    }
                    segment.append(c);
                } else if (segment != null) {
                    this.writeSixFrameTranslation(annotation, segmentPos, segment.toString(), out);
                    segment = null;
                }
                ++curPosition;
            }
        }
        if (segment != null) {
            this.writeSixFrameTranslation(annotation, segmentPos, segment.toString(), out);
        }
    }

    private void writeSixFrameTranslation(String chromosome, int segmentPos, String segment, PrintStream out) {
        StringBuffer buf;
        int shift;
        if (segment.length() < 18) {
            return;
        }
        String annotation = null;
        for (shift = 0; shift < 3; ++shift) {
            annotation = ">" + chromosome + " " + (segmentPos + shift) + " " + 0 + " " + shift;
            buf = new StringBuffer();
            for (int i = shift; i < segment.length() - 2; i += 3) {
                char aa = Codon.translate(segment.substring(i, i + 3));
                buf.append(aa);
            }
            if (buf.length() <= 6) continue;
            out.println(annotation);
            out.println(buf);
        }
        for (shift = 0; shift < 3; ++shift) {
            buf = new StringBuffer();
            int j = 0;
            for (int i = segment.length() - 1 - shift; i > 1; i -= 3) {
                char aa = Codon.translateRevComplement(segment.substring(i - 2, i + 1));
                buf.append(aa);
                j = i - 2;
            }
            annotation = ">" + chromosome + " " + (segmentPos + j) + " " + 1 + " " + shift;
            if (buf.length() <= 6) continue;
            out.println(annotation);
            out.println(buf);
        }
    }

    private void writeSixFrameTranslationConsideringTermCodon(String chromosome, int segmentPos, String segment, PrintStream out) {
        char aa;
        int i;
        StringBuffer buf;
        int shift;
        if (segment.length() < 18) {
            return;
        }
        String annotation = null;
        for (shift = 0; shift < 3; ++shift) {
            annotation = null;
            buf = null;
            for (i = shift; i < segment.length() - 2; i += 3) {
                aa = Codon.translate(segment.substring(i, i + 3));
                if (aa != '*') {
                    if (buf == null) {
                        buf = new StringBuffer();
                        annotation = ">" + chromosome + " " + (segmentPos + i) + " " + 0 + " " + shift;
                    }
                    buf.append(aa);
                    continue;
                }
                if (buf != null && buf.length() > 6) {
                    out.println(annotation);
                    out.println(buf);
                }
                buf = null;
            }
            if (buf == null || buf.length() <= 6) continue;
            out.println(annotation);
            out.println(buf);
        }
        for (shift = 0; shift < 3; ++shift) {
            annotation = null;
            buf = null;
            for (i = segment.length() - 1 - shift; i > 1; i -= 3) {
                aa = Codon.translateRevComplement(segment.substring(i - 2, i + 1));
                if (aa != '*') {
                    if (buf == null) {
                        buf = new StringBuffer();
                        annotation = ">" + chromosome + " " + (segmentPos + i) + " " + 1 + " " + shift;
                    }
                    buf.append(aa);
                    continue;
                }
                if (buf != null && buf.length() > 6) {
                    out.println(annotation);
                    out.println(buf);
                }
                buf = null;
            }
            if (buf == null || buf.length() <= 6) continue;
            out.println(annotation);
            out.println(buf);
        }
    }

    public static String translate(String genome, int shift) {
        StringBuffer prot = new StringBuffer();
        for (int i = shift; i < genome.length() - 2; i += 3) {
            char aa = Codon.translate(genome.substring(i, i + 3));
            prot.append(aa);
        }
        return prot.toString();
    }

    public static String translateReverseComplement(String genome, int shift) {
        StringBuffer prot = new StringBuffer();
        for (int i = genome.length() - 1 - shift; i > 1; i -= 3) {
            char aa = Codon.translateRevComplement(genome.substring(i - 2, i + 1));
            prot.append(aa);
        }
        return prot.toString();
    }

    public static void main(String[] argv) {
        if (argv.length != 2 || !argv[0].contains(".fa") || !argv[1].contains(".fa")) {
            System.out.println("usage: java -Xmx(HeapSize) GenomeTranslator genome(*.fasta) translation(*.fasta)");
            System.exit(-1);
        }
        new GenomeTranslator(argv[0]).translateAndWriteTo(argv[1]);
        System.out.println("Done.");
    }
}

