/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.Histogram;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class AAFrequencyCounter {
    Histogram<String> frequencyTable = new Histogram();
    int nMer;
    int sizeNMer = 0;

    public void setNMer(int nMer) {
        this.nMer = nMer;
    }

    public void readFromFreqFile(String fileName) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(fileName));
            String s = in.readLine();
            String[] token = s.split("\t");
            assert (token[0].equalsIgnoreCase("n"));
            this.nMer = Integer.parseInt(token[1]);
            s = in.readLine();
            token = s.split("\t");
            assert (token[0].equalsIgnoreCase("size"));
            this.sizeNMer = Integer.parseInt(token[1]);
            while ((s = in.readLine()) != null) {
                token = s.split("\t");
                assert (token.length == 2);
                this.frequencyTable.put(token[0], Integer.parseInt(token[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readFromFasta(String fileName) {
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(new FileReader(fileName));
            while ((s = in.readLine()) != null) {
                if (s.startsWith(">")) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < s.length(); ++i) {
                    if (i >= this.nMer) {
                        this.frequencyTable.add(buf.toString());
                        ++this.sizeNMer;
                        buf.deleteCharAt(0);
                    }
                    buf.append(s.charAt(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float getRandomFrequency(String str) {
        float uniFreq = 0.05f;
        int numLI = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != 'L' && str.charAt(i) != 'I') continue;
            ++numLI;
        }
        return (float)(Math.pow(2.0, numLI) * Math.pow(uniFreq, str.length()));
    }

    public float getFrequency(String str) {
        ArrayList<String> strSet = new ArrayList<String>();
        strSet.add(str);
        for (int i = 0; i < str.length(); ++i) {
            String s;
            int j;
            int size;
            char c = str.charAt(i);
            if (c == 'L') {
                size = strSet.size();
                for (j = 0; j < size; ++j) {
                    s = (String)strSet.get(j);
                    strSet.add(s.substring(0, i) + "I" + s.substring(i + 1));
                }
                continue;
            }
            if (c != 'I') continue;
            size = strSet.size();
            for (j = 0; j < size; ++j) {
                s = (String)strSet.get(j);
                strSet.add(s.substring(0, i) + "L" + s.substring(i + 1));
            }
        }
        int occ = 0;
        for (String s : strSet) {
            occ += this.getOccurrence(s);
        }
        return (float)occ / (float)this.sizeNMer;
    }

    public int getOccurrence(String str) {
        Integer occ = this.frequencyTable.get(str);
        if (occ == null) {
            return 0;
        }
        return occ;
    }

    public static void main(String[] argv) {
        System.out.println(AAFrequencyCounter.getRandomFrequency("AAA"));
    }

    public static void generate(int nMer) {
        block7: {
            String allAA;
            AAFrequencyCounter counter;
            block8: {
                block6: {
                    counter = new AAFrequencyCounter();
                    counter.setNMer(nMer);
                    counter.readFromFasta("/home/sangtaekim/Research/Data/EColiDB/Ecol_protein_formatted.fasta");
                    System.out.println("n\t" + nMer);
                    System.out.println("size\t" + counter.sizeNMer);
                    allAA = "GASPVTCLINDQKEMHFRYW";
                    if (nMer != 1) break block6;
                    for (int i = 0; i < allAA.length(); ++i) {
                        char c = allAA.charAt(i);
                        System.out.println(c + "\t" + counter.getOccurrence(String.valueOf(c)));
                    }
                    break block7;
                }
                if (nMer != 2) break block8;
                for (int i = 0; i < allAA.length(); ++i) {
                    for (int j = 0; j < allAA.length(); ++j) {
                        String s = "" + allAA.charAt(i) + allAA.charAt(j);
                        System.out.println(s + "\t" + counter.getOccurrence(s));
                    }
                }
                break block7;
            }
            if (nMer != 3) break block7;
            for (int i = 0; i < allAA.length(); ++i) {
                for (int j = 0; j < allAA.length(); ++j) {
                    for (int k = 0; k < allAA.length(); ++k) {
                        String s = "" + allAA.charAt(i) + allAA.charAt(j) + allAA.charAt(k);
                        System.out.println(s + "\t" + counter.getOccurrence(s));
                    }
                }
            }
        }
    }
}

