/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.ScoreBound;
import java.util.ArrayList;

public class BacktrackPointer
extends ScoreBound {
    private int[] backtrackPointer;
    int nodeScore;

    public BacktrackPointer(int minScore, int maxScore, int curScore) {
        super(minScore, maxScore);
        this.nodeScore = curScore;
        this.backtrackPointer = new int[maxScore - minScore];
    }

    public int getNodeScore() {
        return this.nodeScore;
    }

    public void setBacktrack(int score, int aaIndex) {
        int n = score - this.minScore;
        this.backtrackPointer[n] = this.backtrackPointer[n] | 1 << aaIndex;
    }

    public int getBacktrackPointers(int score) {
        return this.backtrackPointer[score - this.minScore];
    }

    public boolean isSet(int score, int aaIndex) {
        int mask = 1 << aaIndex;
        return (this.backtrackPointer[score - this.minScore] & mask) != 0;
    }

    public void addBacktrackPointers(BacktrackPointer prevPointer, int aaIndex, int edgeScore) {
        int combinedScore = this.nodeScore + edgeScore;
        for (int t = Math.max(prevPointer.minScore, this.minScore - combinedScore); t < prevPointer.maxScore; ++t) {
            if (prevPointer.getBacktrackPointers(t) == 0) continue;
            this.setBacktrack(t + combinedScore, aaIndex);
        }
    }

    public ArrayList<Integer> getBacktrackAAIndexList(int score) {
        assert (score >= this.minScore && score < this.maxScore);
        int pointer = this.backtrackPointer[score - this.minScore];
        int mask = 1;
        ArrayList<Integer> prevIndexList = new ArrayList<Integer>();
        int i = 0;
        while (pointer != 0) {
            if ((pointer & mask) != 0) {
                prevIndexList.add(i);
            }
            pointer >>>= 1;
            ++i;
        }
        return prevIndexList;
    }
}

