/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.BacktrackPointer;
import edu.ucsd.msjava.msgf.BacktrackTable;
import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class DeNovoSequencer<T extends Matter> {
    ScoredSpectrum<T> scoredSpec;
    DeNovoGraph<T> graph;
    AminoAcidSet aaSet;
    ArrayList<String> deNovoStrings;
    ArrayList<Peptide> deNovoPeptides;
    ArrayList<T> optimalNodes;
    int deNovoScore;
    BacktrackTable<T> backtrackTable;

    public DeNovoSequencer(ScoredSpectrum<T> scoredSpec, DeNovoGraph<T> graph, AminoAcidSet aaSet) {
        this.scoredSpec = scoredSpec;
        this.graph = graph;
        this.aaSet = aaSet;
    }

    public DeNovoSequencer(ScoredSpectrum<T> scoredSpec, DeNovoGraph<T> graph) {
        this(scoredSpec, graph, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys());
    }

    public int getDeNovoScore() {
        return this.deNovoScore;
    }

    public void deNovoSequencing(boolean backtrack, boolean trypticOnly) {
        if (backtrack) {
            this.backtrackTable = new BacktrackTable<T>(this.graph);
            BacktrackPointer sourcePointer = new BacktrackPointer(0, 1, 0);
            sourcePointer.setBacktrack(0, 0);
            this.backtrackTable.put(this.graph.getSource(), sourcePointer);
        }
        T source = this.graph.getSource();
        ArrayList<T> intermediateNodeList = this.graph.getIntermediateNodeList();
        Hashtable<Object, Integer> table = new Hashtable<Object, Integer>();
        table.put(source, 0);
        for (int i = 1; i < intermediateNodeList.size(); ++i) {
            Matter curNode;
            Matter srm = curNode = (Matter)intermediateNodeList.get(i);
            Matter prm = this.graph.getComplementNode(srm);
            int curScore = this.scoredSpec.getNodeScore(prm, srm);
            int prevMaxScore = Integer.MIN_VALUE;
            BacktrackPointer backPointer = null;
            for (DeNovoGraph.Edge<Matter> edge : this.graph.getEdges(curNode)) {
                Matter prevNode = edge.getPrevNode();
                Integer prevScore = (Integer)table.get(prevNode);
                if (prevScore == null) continue;
                if (prevScore > prevMaxScore) {
                    prevMaxScore = prevScore;
                    if (!backtrack) continue;
                    int curDeNovoScore = prevMaxScore + curScore;
                    backPointer = new BacktrackPointer(curDeNovoScore, curDeNovoScore + 1, curScore);
                    BacktrackPointer prevPointer = (BacktrackPointer)this.backtrackTable.get(prevNode);
                    backPointer.addBacktrackPointers(prevPointer, edge.getEdgeIndex(), edge.getEdgeScore());
                    continue;
                }
                if (prevScore != prevMaxScore || !backtrack) continue;
                assert (backPointer != null);
                BacktrackPointer prevPointer = (BacktrackPointer)this.backtrackTable.get(prevNode);
                backPointer.addBacktrackPointers(prevPointer, edge.getEdgeScore(), edge.getEdgeScore());
            }
            if (prevMaxScore < Integer.MIN_VALUE) continue;
            if (backtrack) {
                this.backtrackTable.put(curNode, backPointer);
            }
            int curDeNovoScore = prevMaxScore + curScore;
            table.put(curNode, curDeNovoScore);
        }
        ArrayList<T> sinkNodeList = this.graph.getSinkList();
        HashSet<Matter> optimalNodeSet = null;
        this.deNovoScore = Integer.MIN_VALUE;
        for (Matter curNode : sinkNodeList) {
            BacktrackPointer backPointer = null;
            for (DeNovoGraph.Edge<Matter> edge : this.graph.getEdges(curNode)) {
                BacktrackPointer prevPointer;
                Matter prevNode = edge.getPrevNode();
                Integer prevScore = (Integer)table.get(prevNode);
                if (prevScore == null) continue;
                if (prevScore > this.deNovoScore) {
                    this.deNovoScore = prevScore;
                    optimalNodeSet = new HashSet<Matter>();
                    optimalNodeSet.add(curNode);
                    if (!backtrack) continue;
                    backPointer = new BacktrackPointer(this.deNovoScore, this.deNovoScore + 1, 0);
                    prevPointer = (BacktrackPointer)this.backtrackTable.get(prevNode);
                    backPointer.addBacktrackPointers(prevPointer, edge.getEdgeIndex(), edge.getEdgeScore());
                    continue;
                }
                if (prevScore != this.deNovoScore) continue;
                assert (optimalNodeSet != null);
                optimalNodeSet.add(curNode);
                if (!backtrack) continue;
                if (backPointer == null) {
                    backPointer = new BacktrackPointer(this.deNovoScore, this.deNovoScore + 1, 0);
                }
                prevPointer = (BacktrackPointer)this.backtrackTable.get(prevNode);
                backPointer.addBacktrackPointers(prevPointer, edge.getEdgeIndex(), edge.getEdgeScore());
            }
            if (!backtrack || backPointer == null) continue;
            this.backtrackTable.put(curNode, backPointer);
        }
        if (optimalNodeSet != null) {
            this.optimalNodes = new ArrayList(optimalNodeSet);
        }
        table = null;
    }

    public ArrayList<String> getDeNovoStrings() {
        if (this.backtrackTable == null) {
            return null;
        }
        if (this.deNovoStrings == null) {
            this.deNovoStrings = new ArrayList();
            if (this.optimalNodes != null) {
                for (Matter targetNode : this.optimalNodes) {
                    this.backtrackTable.getReconstructions(targetNode, this.deNovoScore, "", this.deNovoStrings);
                }
            }
        }
        return this.deNovoStrings;
    }

    public ArrayList<Peptide> getDeNovoPeptides() {
        if (this.deNovoPeptides != null) {
            return this.deNovoPeptides;
        }
        if (this.deNovoStrings == null) {
            this.getDeNovoStrings();
        }
        if (this.deNovoStrings != null) {
            this.deNovoPeptides = new ArrayList();
            for (String str : this.deNovoStrings) {
                this.deNovoPeptides.add(new Peptide(str, this.aaSet));
            }
            return this.deNovoPeptides;
        }
        return null;
    }

    public ArrayList<T> getOptimalNodes() {
        return this.optimalNodes;
    }
}

