/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.BacktrackPointer;
import edu.ucsd.msjava.msgf.BacktrackTable;
import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.GF;
import edu.ucsd.msjava.msgf.ScoreDist;
import edu.ucsd.msjava.msgf.ScoreDistFactory;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GeneratingFunction<T extends Matter>
implements GF<T> {
    private final DeNovoGraph<T> graph;
    private boolean backtrack = true;
    private boolean calcNumber = true;
    private boolean calcProb = true;
    private Enzyme enzyme = Enzyme.TRYPSIN;
    private int gfTableCapacity;
    private ScoreDist distribution = null;
    private BacktrackTable<T> backtrackTable = null;
    private HashMap<T, ScoreDist> fwdTable;
    private HashMap<T, Integer> minScoreTable = null;
    private boolean isGFComputed = false;

    public GeneratingFunction(DeNovoGraph<T> graph) {
        this.graph = graph;
        this.gfTableCapacity = 1 + graph.intermediateNodes.size() + graph.sinkNodes.size();
    }

    public GeneratingFunction<T> doNotBacktrack() {
        this.backtrack = false;
        return this;
    }

    public GeneratingFunction<T> doNotCalcNumber() {
        this.calcNumber = false;
        return this;
    }

    public GeneratingFunction<T> doNotCalcProb() {
        this.calcProb = false;
        return this;
    }

    public GeneratingFunction<T> enzyme(Enzyme enzyme) {
        this.enzyme = enzyme;
        return this;
    }

    public GeneratingFunction<T> gfTableCapacity(int gfTableCapacity) {
        this.gfTableCapacity = gfTableCapacity;
        return this;
    }

    public boolean backtrack() {
        return this.backtrack;
    }

    public boolean calcNumber() {
        return this.calcNumber;
    }

    public boolean calcProb() {
        return this.calcProb;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public boolean isGFComputed() {
        return this.isGFComputed;
    }

    public DeNovoGraph<T> getGraph() {
        return this.graph;
    }

    protected HashMap<T, ScoreDist> getFwdTable() {
        return this.fwdTable;
    }

    protected BacktrackTable<T> getBacktrackTable() {
        return this.backtrackTable;
    }

    @Override
    public int getScore(Annotation annotation) {
        return this.graph.getScore(annotation);
    }

    public int getEnergy(Annotation annotation) {
        return this.getMaxScore() - this.getScore(annotation);
    }

    public double getSpectralProbability(Annotation annotation) {
        int score = this.getScore(annotation);
        return this.getSpectralProbability(score);
    }

    @Override
    public double getSpectralProbability(int score) {
        if (!this.distribution.isProbSet()) {
            return 100.0;
        }
        return this.distribution.getSpectralProbability(score);
    }

    public double getNumEqualBetterPeptides(Annotation annotation) {
        int score = this.getScore(annotation);
        return this.getNumEqualOrBetterPeptides(score);
    }

    public double getNumEqualOrBetterPeptides(int score) {
        if (!this.distribution.isNumSet()) {
            return -1.0;
        }
        return this.distribution.getNumEqualOrBetterPeptides(score);
    }

    public double getDictionarySize(float specProb) {
        return this.getNumEqualOrBetterPeptides(this.getThresholdScore(specProb));
    }

    public static int getThresholdScore(float specProb, ScoreDist distribution) {
        if (!distribution.isProbSet()) {
            return -1;
        }
        float totalProb = 0.0f;
        for (int t = distribution.getMaxScore() - 1; t >= distribution.getMinScore(); --t) {
            if (!((totalProb = (float)((double)totalProb + distribution.getProbability(t))) > specProb)) continue;
            return t;
        }
        return -1;
    }

    public int getThresholdScore(float specProb) {
        return GeneratingFunction.getThresholdScore(specProb, this.distribution);
    }

    @Override
    public ScoreDist getScoreDist() {
        return this.distribution;
    }

    private void generateReconstructions(int score, ArrayList<String> reconstructions, SuffixArray sa) {
        if (this.backtrackTable == null) {
            return;
        }
        if (this.enzyme == null) {
            for (Matter sink : this.graph.getSinkList()) {
                this.backtrackTable.getReconstructions(sink, score, "", reconstructions, sa);
            }
        } else {
            for (Matter sink : this.graph.getSinkList()) {
                this.backtrackTable.getReconstructions(sink, score - this.graph.getAASet().getNeighboringAACleavageCredit(), "R.", reconstructions, sa);
            }
            for (Matter sink : this.graph.getSinkList()) {
                this.backtrackTable.getReconstructions(sink, score - this.graph.getAASet().getNeighboringAACleavagePenalty(), "L.", reconstructions, sa);
            }
        }
    }

    public String getOneReconstruction(int score) {
        if (this.backtrackTable == null) {
            return null;
        }
        return this.backtrackTable.getOneReconstruction(this.graph.getPMNode(), score, "");
    }

    public ArrayList<String> getReconstructions(int score) {
        ArrayList<String> reconstructions = new ArrayList<String>();
        this.generateReconstructions(score, reconstructions, null);
        return reconstructions;
    }

    public ArrayList<String> getReconstructionsEqualOrAboveScore(int score) {
        ArrayList<String> reconstructions = new ArrayList<String>();
        for (int t = this.getMaxScore() - 1; t >= score; --t) {
            this.generateReconstructions(t, reconstructions, null);
        }
        return reconstructions;
    }

    public ArrayList<String> getDictionary(float specProbThreshold) {
        assert (this.calcProb);
        int threshold = this.getThresholdScore(specProbThreshold);
        return this.getReconstructionsEqualOrAboveScore(threshold + 1);
    }

    public ArrayList<String> getReconstructions(float specProbThreshold, float numRecsThreshold, boolean isNumInclusive, SuffixArray sa) {
        assert (this.calcProb && this.calcNumber);
        ArrayList<String> recs = new ArrayList<String>();
        int threshold = this.getThresholdScore(specProbThreshold);
        float numRecs = 0.0f;
        for (int t = this.getMaxScore() - 1; t > threshold; --t) {
            numRecs = (float)((double)numRecs + this.distribution.getNumberRecs(t));
            if (!isNumInclusive) {
                if (!(numRecs <= numRecsThreshold)) break;
                this.generateReconstructions(t, recs, sa);
                continue;
            }
            this.generateReconstructions(t, recs, sa);
            if (numRecs >= numRecsThreshold) break;
        }
        return recs;
    }

    public int getMinScore() {
        return this.distribution.getMinScore();
    }

    @Override
    public int getMaxScore() {
        return this.distribution.getMaxScore();
    }

    public void setUpScoreThreshold(int score) {
        this.minScoreTable = new HashMap();
        if (this.enzyme != null) {
            score -= this.graph.getAASet().getNeighboringAACleavageCredit();
        }
        for (Matter sink : this.graph.getSinkList()) {
            this.minScoreTable.put(sink, score);
            for (DeNovoGraph.Edge<Matter> edge : this.graph.getEdges(sink)) {
                Matter prevNode = edge.getPrevNode();
                int newPrevMinScore = score - edge.getEdgeScore();
                Integer prevMinScore = this.minScoreTable.get(prevNode);
                if (prevMinScore != null && prevMinScore <= newPrevMinScore) continue;
                this.minScoreTable.put(prevNode, newPrevMinScore);
            }
        }
        ArrayList<T> intermediateNodeList = this.graph.getIntermediateNodeList();
        for (int i = intermediateNodeList.size() - 1; i >= 0; --i) {
            Matter curNode = (Matter)intermediateNodeList.get(i);
            Integer curScore = this.minScoreTable.get(curNode);
            if (curScore == null) continue;
            int curNodeScore = this.graph.getNodeScore(curNode);
            for (DeNovoGraph.Edge<Matter> edge : this.graph.getEdges(curNode)) {
                Matter prevNode = edge.getPrevNode();
                int newPrevMinScore = curScore - (curNodeScore + edge.getEdgeScore());
                Integer prevMinScore = this.minScoreTable.get(prevNode);
                if (prevMinScore != null && prevMinScore <= newPrevMinScore) continue;
                this.minScoreTable.put(prevNode, newPrevMinScore);
            }
        }
    }

    @Override
    public boolean computeGeneratingFunction() {
        ScoreDist finalDist;
        ScoreDistFactory factory = new ScoreDistFactory(this.calcNumber, this.calcProb);
        ScoreDist sourceDist = factory.getInstance(0, 1);
        if (this.calcNumber) {
            sourceDist.setNumber(0, 1.0);
        }
        if (this.calcProb) {
            sourceDist.setProb(0, 1.0);
        }
        this.fwdTable = new GFTable(this.gfTableCapacity);
        this.fwdTable.put(this.graph.getSource(), sourceDist);
        if (this.backtrack) {
            this.backtrackTable = new BacktrackTable<T>(this.graph);
            BacktrackPointer sourcePointer = new BacktrackPointer(0, 1, 0);
            sourcePointer.setBacktrack(0, 0);
            this.backtrackTable.put(this.graph.getSource(), sourcePointer);
        }
        ArrayList<T> intermediateNodeList = this.graph.getIntermediateNodeList();
        for (int i = 1; i < intermediateNodeList.size(); ++i) {
            Matter curNode = (Matter)intermediateNodeList.get(i);
            this.setCurNode(curNode, factory);
        }
        int minScore = Integer.MAX_VALUE;
        int maxScore = Integer.MIN_VALUE;
        for (Object curNode : this.graph.getSinkList()) {
            this.setCurNode(curNode, factory);
            ScoreDist curDist = this.fwdTable.get(curNode);
            if (curDist == null) continue;
            if (curDist.getMinScore() < minScore) {
                minScore = curDist.getMinScore();
            }
            if (curDist.getMaxScore() <= maxScore) continue;
            maxScore = curDist.getMaxScore();
        }
        if (maxScore <= minScore) {
            return false;
        }
        if (minScore < -10000 || maxScore > 10000) {
            System.err.println("Error! MinScore: " + minScore + ", MaxScore: " + maxScore + " ");
            System.exit(-1);
        }
        ScoreDist mergedDist = factory.getInstance(minScore, maxScore);
        for (Matter sinkNode : this.graph.getSinkList()) {
            if (this.calcNumber) {
                mergedDist.addNumDist(this.fwdTable.get(sinkNode), 0);
            }
            if (!this.calcProb) continue;
            mergedDist.addProbDist(this.fwdTable.get(sinkNode), 0, 1.0f);
        }
        if (this.enzyme != null && this.enzyme.getResidues() != null) {
            int neighboringAACleavageCredit = this.graph.getAASet().getNeighboringAACleavageCredit();
            int neighboringAACleavagePenalty = this.graph.getAASet().getNeighboringAACleavagePenalty();
            finalDist = factory.getInstance(mergedDist.getMinScore() + neighboringAACleavagePenalty, mergedDist.getMaxScore() + neighboringAACleavageCredit);
            if (this.calcNumber) {
                finalDist.addNumDist(mergedDist, neighboringAACleavageCredit, this.enzyme.getResidues().length);
                finalDist.addNumDist(mergedDist, neighboringAACleavagePenalty, this.graph.getAASet().size() - this.enzyme.getResidues().length);
            }
            if (this.calcProb) {
                finalDist.addProbDist(mergedDist, neighboringAACleavageCredit, this.graph.getAASet().getProbCleavageSites());
                finalDist.addProbDist(mergedDist, neighboringAACleavagePenalty, 1.0f - this.graph.getAASet().getProbCleavageSites());
            }
        } else {
            finalDist = mergedDist;
        }
        this.distribution = finalDist;
        this.isGFComputed = true;
        return true;
    }

    public HashMap<T, Float> getDestProfile(int scoreThreshold) {
        assert (this.calcNumber);
        HashMap<Matter, Float> destProf = new HashMap<Matter, Float>();
        for (Matter sinkNode : this.graph.getSinkList()) {
            float num = 0.0f;
            ScoreDist dist = this.fwdTable.get(sinkNode);
            for (int t = dist.getMaxScore() - 1; t >= dist.getMinScore() && t >= scoreThreshold; --t) {
                num = (float)((double)num + dist.getNumberRecs(t));
            }
            if (!(num > 0.0f)) continue;
            destProf.put(sinkNode, Float.valueOf(num));
        }
        return destProf;
    }

    private void setCurNode(T curNode, ScoreDistFactory scoreDistFactory) {
        int curMinScore;
        int curNodeScore = this.graph.getNodeScore(curNode);
        int curMaxScore = Integer.MIN_VALUE;
        if (this.minScoreTable == null) {
            curMinScore = Integer.MAX_VALUE;
        } else {
            Integer min = this.minScoreTable.get(curNode);
            if (min == null) {
                return;
            }
            curMinScore = min;
        }
        ArrayList<DeNovoGraph.Edge<T>> edges = new ArrayList<DeNovoGraph.Edge<T>>();
        for (DeNovoGraph.Edge<T> edge : this.graph.getEdges(curNode)) {
            T prevNode = edge.getPrevNode();
            ScoreDist scoreDist = this.fwdTable.get(prevNode);
            if (scoreDist == null) continue;
            int edgeScore = edge.getEdgeScore();
            int combinedScore = curNodeScore + edgeScore;
            if (scoreDist.getMaxScore() + combinedScore > curMaxScore) {
                curMaxScore = scoreDist.getMaxScore() + combinedScore;
            }
            if (this.minScoreTable == null && scoreDist.getMinScore() + combinedScore < curMinScore) {
                curMinScore = scoreDist.getMinScore() + combinedScore;
            }
            edges.add(edge);
        }
        if (curMinScore >= curMaxScore) {
            return;
        }
        if (curMinScore < -10000) {
            System.err.println("Warning, MinScore is abnormally low; MinScore: " + curMinScore + ", MaxScore: " + curMaxScore + ", CurNode: " + ((Matter)curNode).getNominalMass() + ", CurNodeScore: " + curNodeScore);
            return;
        }
        if (curMaxScore > 10000) {
            System.err.println("Warning, MaxScore is abnormally high; MinScore: " + curMinScore + ", MaxScore: " + curMaxScore + ", CurNode: " + ((Matter)curNode).getNominalMass() + ", CurNodeScore: " + curNodeScore);
            return;
        }
        ScoreDist curDist = scoreDistFactory.getInstance(curMinScore, curMaxScore);
        BacktrackPointer backPointer = null;
        if (this.backtrack) {
            backPointer = new BacktrackPointer(curMinScore, curMaxScore, curNodeScore);
        }
        for (DeNovoGraph.Edge edge : edges) {
            Object prevNode = edge.getPrevNode();
            ScoreDist prevDist = this.fwdTable.get(prevNode);
            if (prevDist == null) continue;
            int edgeScore = edge.getEdgeScore();
            int combinedScore = curNodeScore + edgeScore;
            if (this.calcNumber) {
                curDist.addNumDist(prevDist, combinedScore, 1);
            }
            if (this.calcProb) {
                curDist.addProbDist(prevDist, combinedScore, edge.getEdgeProbability());
            }
            if (!this.backtrack) continue;
            BacktrackPointer prevPointer = (BacktrackPointer)this.backtrackTable.get(prevNode);
            backPointer.addBacktrackPointers(prevPointer, edge.getEdgeIndex(), edgeScore);
        }
        if (this.calcProb && curDist.getProbability(curDist.maxScore - 1) == 0.0) {
            assert (false) : "Underflow! " + ((Matter)curNode).getNominalMass() + " " + curDist.getProbability(curDist.maxScore - 1);
            curDist.setProb(curDist.maxScore - 1, 1.4E-45f);
        }
        this.fwdTable.put(curNode, curDist);
        if (this.backtrack) {
            this.backtrackTable.put(curNode, backPointer);
        }
    }

    private class GFTable
    extends LinkedHashMap<T, ScoreDist> {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        public GFTable(int capacity) {
            super(capacity + 1, 1.1f, false);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, ScoreDist> eldest) {
            return this.size() > this.capacity;
        }
    }
}

