/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.DeNovoNodeFactory;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public abstract class MassFactory<T extends Matter>
implements DeNovoNodeFactory<T> {
    protected AminoAcidSet aaSet;
    protected ArrayList<T> allNodes;
    protected HashMap<T, ArrayList<DeNovoGraph.Edge<T>>> edgeMap;
    protected Enzyme enzyme;
    protected int maxLength;

    public MassFactory(AminoAcidSet aaSet, Enzyme enzyme, int maxLength) {
        this.aaSet = aaSet;
        this.enzyme = enzyme;
        this.maxLength = maxLength;
    }

    @Override
    public boolean isReverse() {
        return this.enzyme == null || this.enzyme.isCTerm();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public ArrayList<T> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public int size() {
        return this.allNodes.size();
    }

    @Override
    public AminoAcidSet getAASet() {
        return this.aaSet;
    }

    @Override
    public DeNovoGraph.Edge<T> getEdge(T curNode, T prevNode) {
        for (DeNovoGraph.Edge<T> edge : this.getEdges(curNode)) {
            if (!((Matter)edge.getPrevNode()).equals(prevNode)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public T getPreviousNode(T curNode, AminoAcid aa) {
        int aaIndex = this.aaSet.getIndex(aa);
        for (DeNovoGraph.Edge<T> edge : this.getEdges(curNode)) {
            if (edge.getEdgeIndex() != aaIndex) continue;
            return edge.getPrevNode();
        }
        return null;
    }

    @Override
    public abstract T getZero();

    @Override
    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    @Override
    public ArrayList<T> getLinkedNodeList(Collection<T> destNodes) {
        HashSet<T> effectiveNodeSet = new HashSet<T>(destNodes);
        ArrayList<Object> curFreshNodes = new ArrayList<T>(destNodes);
        while (!curFreshNodes.isEmpty()) {
            ArrayList<Matter> newFreshNodes = new ArrayList<Matter>();
            for (Matter node : curFreshNodes) {
                ArrayList<DeNovoGraph.Edge<Matter>> edges = this.getEdges(node);
                if (edges == null) continue;
                for (DeNovoGraph.Edge<Matter> edge : edges) {
                    Matter prevNode = edge.getPrevNode();
                    if (!this.contains(prevNode) || effectiveNodeSet.contains(prevNode)) continue;
                    effectiveNodeSet.add(prevNode);
                    newFreshNodes.add(prevNode);
                }
            }
            curFreshNodes = newFreshNodes;
        }
        ArrayList<T> intermidiateNodeList = new ArrayList<T>(effectiveNodeSet);
        Collections.sort(intermidiateNodeList);
        return intermidiateNodeList;
    }

    protected void makeAllPossibleMasses(boolean makeEdgeMap) {
        HashSet<Object> nodes = new HashSet<Object>();
        T zero = this.getZero();
        nodes.add(zero);
        if (makeEdgeMap) {
            this.edgeMap = new HashMap();
            this.edgeMap.put(zero, new ArrayList());
        }
        ArrayList<T> curFreshNodes = new ArrayList<T>();
        Modification.Location location = this.isReverse() ? Modification.Location.C_Term : Modification.Location.N_Term;
        for (AminoAcid aa : this.aaSet.getAAList(location)) {
            T newNode = this.getNextNode(zero, aa);
            boolean isNewNode = nodes.add(newNode);
            if (isNewNode) {
                curFreshNodes.add(newNode);
            }
            if (!makeEdgeMap) continue;
            DeNovoGraph.Edge<T> edge = new DeNovoGraph.Edge<T>(zero, aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
            if (this.enzyme != null) {
                if (this.enzyme.isCleavable(aa)) {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavageCredit());
                } else {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavagePenalty());
                }
            }
            if (isNewNode) {
                ArrayList<DeNovoGraph.Edge<T>> edges = new ArrayList<DeNovoGraph.Edge<T>>();
                edges.add(edge);
                this.edgeMap.put(newNode, edges);
                continue;
            }
            this.edgeMap.get(newNode).add(edge);
        }
        for (int i = 1; i < this.maxLength; ++i) {
            ArrayList<Matter> newFreshNodes = new ArrayList<Matter>();
            for (Matter node : curFreshNodes) {
                for (AminoAcid aa : this.aaSet) {
                    Matter newNode = this.getNextNode(node, aa);
                    assert (newNode != null) : node.getNominalMass() + " " + aa.getResidueStr();
                    boolean isNewNode = nodes.add(newNode);
                    if (isNewNode) {
                        newFreshNodes.add(newNode);
                    }
                    if (!makeEdgeMap) continue;
                    DeNovoGraph.Edge<Matter> edge = new DeNovoGraph.Edge<Matter>(node, aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
                    if (isNewNode) {
                        ArrayList<DeNovoGraph.Edge<Matter>> edges = new ArrayList<DeNovoGraph.Edge<Matter>>();
                        edges.add(edge);
                        this.edgeMap.put(newNode, edges);
                        continue;
                    }
                    this.edgeMap.get(newNode).add(edge);
                }
            }
            curFreshNodes = newFreshNodes;
        }
        this.allNodes = new ArrayList(nodes);
        Collections.sort(this.allNodes);
    }

    @Override
    public Sequence<T> toCumulativeSequence(boolean isPrefix, Peptide pep) {
        Sequence cumSeq = new Sequence();
        T curNode = this.getZero();
        for (int i = pep.size() - 1; i >= 0; --i) {
            AminoAcid aa = isPrefix ? pep.get(pep.size() - 1 - i) : pep.get(i);
            curNode = this.getNextNode(curNode, aa);
            cumSeq.add(curNode);
        }
        return cumSeq;
    }
}

