/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import java.io.Serializable;

public class Tolerance
implements Serializable {
    public static final Tolerance ZERO_TOLERANCE = new Tolerance(0.0f);
    private static final long serialVersionUID = 1L;
    private float value;
    private final Unit unit;

    public Tolerance(float value) {
        this(value, false);
    }

    public Tolerance(float value, boolean isTolerancePPM) {
        this.value = value;
        this.unit = !isTolerancePPM ? Unit.Da : Unit.PPM;
    }

    public Tolerance(float value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public float getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean isTolerancePPM() {
        return this.unit == Unit.PPM;
    }

    public float getToleranceAsDa(float mass) {
        if (this.unit == Unit.Th) {
            System.err.println("Use getToleranceAsDa(float mass, int charge) instead!");
            System.exit(-1);
        }
        return this.getToleranceAsDa(mass, 0);
    }

    public float getToleranceAsDa(float mass, int charge) {
        if (this.unit == Unit.Da) {
            return this.value;
        }
        if (this.unit == Unit.Th) {
            return this.value * (float)charge;
        }
        return 1.0E-6f * this.value * mass;
    }

    public float getToleranceAsPPM(float mass) {
        if (this.unit == Unit.Da) {
            return this.value;
        }
        return this.value * 1000000.0f / mass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tolerance) {
            Tolerance other = (Tolerance)obj;
            if (this.value == other.value && this.unit == other.unit) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.unit == Unit.Da) {
            return this.value + " Da";
        }
        if (this.unit == Unit.PPM) {
            return this.value + " ppm";
        }
        if (this.unit == Unit.Th) {
            return this.value + " Th";
        }
        return null;
    }

    public static Tolerance parseToleranceStr(String tolStr) {
        Float val = null;
        Unit unit = null;
        String tolStrLCase = tolStr.toLowerCase();
        if (tolStrLCase.endsWith("ppm")) {
            try {
                val = Float.valueOf(Float.parseFloat(tolStr.substring(0, tolStr.length() - 3).trim()));
                unit = Unit.PPM;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (tolStrLCase.endsWith("da")) {
            try {
                val = Float.valueOf(Float.parseFloat(tolStr.substring(0, tolStr.length() - 2).trim()));
                unit = Unit.Da;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (tolStrLCase.endsWith("th")) {
            try {
                val = Float.valueOf(Float.parseFloat(tolStr.substring(0, tolStr.length() - 2).trim()));
                unit = Unit.Th;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                val = Float.valueOf(Float.parseFloat(tolStr));
                unit = Unit.Da;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (val == null) {
            return null;
        }
        return new Tolerance(val.floatValue(), unit);
    }

    public static enum Unit {
        Da,
        Th,
        PPM;

    }
}

