/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewAdditiveScorer;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Spectrum;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public abstract class ToolLauncher {
    protected final Iterator<Spectrum> specIterator;
    protected final NewAdditiveScorer scorer;
    protected float specProb = 1.0E-9f;
    protected boolean trypticOnly = true;
    protected Tolerance pmTolerance = new Tolerance(30.0f, true);
    protected Tolerance fragTolerance = new Tolerance(30.0f, true);
    protected float minParentMass = 400.0f;
    protected float maxParentMass = 2000.0f;
    protected int msgfScoreThreshold = 0;
    protected AminoAcidSet aaSet;
    protected PrintStream out;

    protected ToolLauncher(Iterator<Spectrum> specIterator, NewAdditiveScorer scorer) {
        this.specIterator = specIterator;
        this.scorer = scorer;
        this.out = System.out;
        this.aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
    }

    public ToolLauncher specProb(float specProb) {
        this.specProb = specProb;
        return this;
    }

    public ToolLauncher allowNonTryptic() {
        this.trypticOnly = false;
        return this;
    }

    public ToolLauncher pmTolerance(Tolerance pmTolerance) {
        this.pmTolerance = pmTolerance;
        return this;
    }

    public ToolLauncher fragTolerance(Tolerance fragTolerance) {
        this.fragTolerance = fragTolerance;
        return this;
    }

    public ToolLauncher minParentMass(float minParentMass) {
        this.minParentMass = minParentMass;
        return this;
    }

    public ToolLauncher maxParentMass(float maxParentMass) {
        this.maxParentMass = maxParentMass;
        return this;
    }

    public ToolLauncher msgfScoreThreshold(int thresholdScore) {
        this.msgfScoreThreshold = thresholdScore;
        return this;
    }

    public ToolLauncher aminoAcidSet(AminoAcidSet aaSet) {
        this.aaSet = aaSet;
        return this;
    }

    public ToolLauncher outputFileName(String outputFileName) {
        try {
            this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this;
    }
}

