/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf2d;

import edu.ucsd.msjava.msgf2d.ScoreBound2D;

public class ScoreDist2D
extends ScoreBound2D {
    private float[][] numDistribution;
    private float[][] probDistribution;

    public ScoreDist2D(int minScore1, int maxScore1, int minScore2, int maxScore2) {
        super(minScore1, maxScore1, minScore2, maxScore2);
        this.numDistribution = new float[this.scoreBound1.getRange()][this.scoreBound2.getRange()];
        this.probDistribution = new float[this.scoreBound1.getRange()][this.scoreBound2.getRange()];
    }

    public ScoreDist2D(ScoreBound2D scoreBound) {
        super(scoreBound.scoreBound1, scoreBound.scoreBound2);
        this.numDistribution = new float[this.scoreBound1.getRange()][this.scoreBound2.getRange()];
        this.probDistribution = new float[this.scoreBound1.getRange()][this.scoreBound2.getRange()];
    }

    public void setNumber(int score1, int score2, float number) {
        this.numDistribution[score1 - this.scoreBound1.getMinScore()][score2 - this.scoreBound2.getMinScore()] = number;
    }

    public void setProb(int score1, int score2, float prob) {
        this.probDistribution[score1 - this.scoreBound1.getMinScore()][score2 - this.scoreBound2.getMinScore()] = prob;
    }

    public void addNumber(int score1, int score2, float number) {
        float[] fArray = this.numDistribution[score1 - this.scoreBound1.getMinScore()];
        int n = score2 - this.scoreBound2.getMinScore();
        fArray[n] = fArray[n] + number;
    }

    public void addProb(int score1, int score2, float prob) {
        float[] fArray = this.probDistribution[score1 - this.scoreBound1.getMinScore()];
        int n = score2 - this.scoreBound2.getMinScore();
        fArray[n] = fArray[n] + prob;
    }

    public float getProbability(int score1, int score2) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        return this.probDistribution[index1][index2];
    }

    public float getNumRecs(int score1, int score2) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        return this.numDistribution[index1][index2];
    }

    public float getSpectralProbability1(int score1) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        float specProb = 0.0f;
        for (int t1 = index1; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = 0; t2 < this.scoreBound2.getRange(); ++t2) {
                specProb += this.probDistribution[t1][t2];
            }
        }
        return specProb;
    }

    public float getSpectralProbability2(int score2) {
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        float specProb = 0.0f;
        for (int t1 = 0; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = index2; t2 < this.scoreBound2.getRange(); ++t2) {
                specProb += this.probDistribution[t1][t2];
            }
        }
        return specProb;
    }

    public float getSpectralProbabilitySumScores(int score1, int score2) {
        float specProb = 0.0f;
        for (int s1 = this.scoreBound1.getMinScore(); s1 < this.scoreBound1.getMaxScore(); ++s1) {
            for (int s2 = score1 + score2 - s1; s2 < this.scoreBound2.getMaxScore(); ++s2) {
                if (s1 < this.scoreBound1.getMinScore() || s2 < this.scoreBound2.getMinScore() || s1 < this.scoreBound1.getMinScore() || s1 >= this.scoreBound1.getMaxScore() || s2 < this.scoreBound2.getMinScore() || s2 >= this.scoreBound2.getMaxScore()) continue;
                specProb += this.probDistribution[s1 - this.scoreBound1.getMinScore()][s2 - this.scoreBound2.getMinScore()];
            }
        }
        return specProb;
    }

    public float getSpectralProbability(int score1, int score2) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        float specProb = 0.0f;
        for (int t1 = index1; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = index2; t2 < this.scoreBound2.getRange(); ++t2) {
                specProb += this.probDistribution[t1][t2];
            }
        }
        return specProb;
    }

    public float getNumEqualOrBetterPeptides(int score1, int score2) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        float numRecs = 0.0f;
        for (int t1 = index1; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = index2; t2 < this.scoreBound2.getRange(); ++t2) {
                numRecs += this.numDistribution[t1][t2];
            }
        }
        return numRecs;
    }

    public float getNumEqualOrBetterPeptidesSumScores(int score1, int score2) {
        float numRecs = 0.0f;
        for (int s1 = this.scoreBound1.getMinScore(); s1 < this.scoreBound1.getMaxScore(); ++s1) {
            for (int s2 = score1 + score2 - s1; s2 < this.scoreBound2.getMaxScore(); ++s2) {
                if (s1 < this.scoreBound1.getMinScore() || s1 >= this.scoreBound1.getMaxScore() || s2 < this.scoreBound2.getMinScore() || s2 >= this.scoreBound2.getMaxScore()) continue;
                numRecs += this.numDistribution[s1 - this.scoreBound1.getMinScore()][s2 - this.scoreBound2.getMinScore()];
            }
        }
        return numRecs;
    }

    public float getNumEqualOrBetterPeptides1(int score1) {
        int index1 = score1 >= this.scoreBound1.getMinScore() ? score1 - this.scoreBound1.getMinScore() : 0;
        float numRecs = 0.0f;
        for (int t1 = index1; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = 0; t2 < this.scoreBound2.getRange(); ++t2) {
                numRecs += this.numDistribution[t1][t2];
            }
        }
        return numRecs;
    }

    public float getNumEqualOrBetterPeptides2(int score2) {
        int index2 = score2 >= this.scoreBound2.getMinScore() ? score2 - this.scoreBound2.getMinScore() : 0;
        float numRecs = 0.0f;
        for (int t1 = 0; t1 < this.scoreBound1.getRange(); ++t1) {
            for (int t2 = index2; t2 < this.scoreBound2.getRange(); ++t2) {
                numRecs += this.numDistribution[t1][t2];
            }
        }
        return numRecs;
    }

    public void addNumDist(ScoreDist2D otherDist, int scoreDiff1, int scoreDiff2, int coeff) {
        if (otherDist == null) {
            return;
        }
        int minScore1 = this.scoreBound1.getMinScore();
        int minScore2 = this.scoreBound2.getMinScore();
        for (int t1 = Math.max(otherDist.scoreBound1.getMinScore(), this.scoreBound1.getMinScore() - scoreDiff1); t1 < otherDist.scoreBound1.getMaxScore(); ++t1) {
            for (int t2 = Math.max(otherDist.scoreBound2.getMinScore(), this.scoreBound2.getMinScore() - scoreDiff2); t2 < otherDist.scoreBound2.getMaxScore(); ++t2) {
                float[] fArray = this.numDistribution[t1 + scoreDiff1 - minScore1];
                int n = t2 + scoreDiff2 - minScore2;
                fArray[n] = fArray[n] + (float)coeff * otherDist.numDistribution[t1 - otherDist.scoreBound1.getMinScore()][t2 - otherDist.scoreBound2.getMinScore()];
            }
        }
    }

    public void addProbDist(ScoreDist2D otherDist, int scoreDiff1, int scoreDiff2, float aaProb) {
        if (otherDist == null) {
            return;
        }
        int minScore1 = this.scoreBound1.getMinScore();
        int minScore2 = this.scoreBound2.getMinScore();
        for (int t1 = Math.max(otherDist.scoreBound1.getMinScore(), this.scoreBound1.getMinScore() - scoreDiff1); t1 < otherDist.scoreBound1.getMaxScore(); ++t1) {
            for (int t2 = Math.max(otherDist.scoreBound2.getMinScore(), this.scoreBound2.getMinScore() - scoreDiff2); t2 < otherDist.scoreBound2.getMaxScore(); ++t2) {
                float[] fArray = this.probDistribution[t1 + scoreDiff1 - minScore1];
                int n = t2 + scoreDiff2 - minScore2;
                fArray[n] = fArray[n] + aaProb * otherDist.probDistribution[t1 - otherDist.scoreBound1.getMinScore()][t2 - otherDist.scoreBound2.getMinScore()];
            }
        }
    }
}

