/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListStat {
    private List<Float> data;
    private List<Float> sortedData;

    public ListStat(List<Float> data) {
        this.data = data;
    }

    public ListStat(float[] data) {
        this.data = new ArrayList<Float>();
        for (float val : data) {
            this.data.add(Float.valueOf(val));
        }
    }

    public float mean() {
        double sum = 0.0;
        for (Float val : this.data) {
            sum += (double)val.floatValue();
        }
        return (float)sum / (float)this.data.size();
    }

    public float median() {
        return this.percentile(0.5f);
    }

    public float percentile(float percentile) {
        if (this.sortedData == null) {
            this.sortedData = new ArrayList<Float>(this.data);
        }
        Collections.sort(this.sortedData);
        float index = (float)(this.data.size() - 1) * percentile;
        int lowIndex = (int)Math.floor(index);
        int highIndex = (int)Math.ceil(index);
        if (lowIndex == highIndex) {
            return this.sortedData.get(lowIndex).floatValue();
        }
        return (index - (float)lowIndex) * this.sortedData.get(lowIndex).floatValue() + ((float)highIndex - index) * this.sortedData.get(highIndex).floatValue();
    }

    public float stdev() {
        float sumSq = 0.0f;
        for (Float val : this.data) {
            sumSq += val.floatValue() * val.floatValue();
        }
        float mean = this.mean();
        return sumSq / (float)this.data.size() - mean * mean;
    }

    public float getSignalThreshold(float signalToNoiseRatio) {
        float median = this.median();
        ArrayList<Float> dataWithoutOutliers = new ArrayList<Float>();
        for (Float val : this.data) {
            if (!(val.floatValue() < median * signalToNoiseRatio)) continue;
            dataWithoutOutliers.add(val);
        }
        ListStat newList = new ListStat(dataWithoutOutliers);
        float newMedian = newList.median();
        return newMedian * signalToNoiseRatio;
    }

    public float[] getOutlieres(float signalToNoiseRatio) {
        float newMedian = this.getSignalThreshold(signalToNoiseRatio);
        ArrayList<Float> outlierList = new ArrayList<Float>();
        for (Float val : this.data) {
            if (!(val.floatValue() >= newMedian * signalToNoiseRatio)) continue;
            outlierList.add(val);
        }
        float[] outliers = new float[outlierList.size()];
        int index = -1;
        for (Float val : outlierList) {
            outliers[++index] = val.floatValue();
        }
        return outliers;
    }
}

