/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.mzid.Constants;
import edu.ucsd.msjava.params.ParamObject;
import edu.ucsd.msjava.params.UserParam;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;

public class ActivationMethod
implements ParamObject {
    private final String name;
    private String fullName;
    private boolean electronBased = false;
    private String accession;
    private CvParam cvParam;
    public static final ActivationMethod ASWRITTEN = new ActivationMethod("As written in the spectrum or CID if no info", "as written in the spectrum or CID if no info");
    public static final ActivationMethod CID = new ActivationMethod("CID", "collision-induced dissociation", "MS:1000133");
    public static final ActivationMethod ETD = new ActivationMethod("ETD", "electron transfer dissociation", "MS:1000598").electronBased();
    public static final ActivationMethod HCD = new ActivationMethod("HCD", "high-energy collision-induced dissociation", "MS:1000422");
    public static final ActivationMethod PQD;
    public static final ActivationMethod FUSION;
    public static final ActivationMethod UVPD;
    private static HashMap<String, ActivationMethod> table;
    private static HashMap<String, ActivationMethod> cvTable;
    private static ArrayList<ActivationMethod> registeredActMethods;

    private ActivationMethod(String name, String fullName) {
        this(name, fullName, null);
    }

    private ActivationMethod(String name, String fullName, String accession) {
        this.name = name;
        this.fullName = fullName;
        this.accession = accession;
        if (accession != null) {
            this.cvParam = Constants.makeCvParam(accession, fullName);
        }
    }

    private ActivationMethod electronBased() {
        this.electronBased = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getParamDescription() {
        return this.name;
    }

    public String getPSICVAccession() {
        return this.accession;
    }

    public boolean isElectronBased() {
        return this.electronBased;
    }

    public CvParam getCvParam() {
        return this.cvParam;
    }

    public static ActivationMethod get(String name) {
        return table.get(name);
    }

    public static ActivationMethod getByCV(String cvAccession) {
        return cvTable.get(cvAccession);
    }

    public static ActivationMethod register(String name, String fullName) {
        ActivationMethod m = table.get(name);
        if (m != null) {
            return m;
        }
        ActivationMethod newMethod = new ActivationMethod(name, fullName);
        table.put(name, newMethod);
        return newMethod;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationMethod) {
            return this.name.equalsIgnoreCase(((ActivationMethod)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static ActivationMethod[] getAllRegisteredActivationMethods() {
        return registeredActMethods.toArray(new ActivationMethod[0]);
    }

    private static void add(ActivationMethod actMethod) {
        if (table.put(actMethod.name, actMethod) == null) {
            registeredActMethods.add(actMethod);
        }
    }

    private static void addAlias(String name, ActivationMethod actMethod) {
        table.put(name, actMethod);
    }

    private static void addToList(ActivationMethod actMethod) {
        registeredActMethods.add(actMethod);
    }

    static {
        FUSION = new ActivationMethod("Merge spectra from the same precursor", "Merge spectra from the same precursor");
        PQD = new ActivationMethod("PQD", "pulsed q dissociation", "MS:1000599");
        UVPD = new ActivationMethod("UVPD", "Ultraviolet photo dissociation.", "MS:1000435");
        table = new HashMap();
        registeredActMethods = new ArrayList();
        ActivationMethod.addToList(ASWRITTEN);
        ActivationMethod.add(CID);
        ActivationMethod.add(ETD);
        ActivationMethod.add(HCD);
        ActivationMethod.addToList(FUSION);
        ActivationMethod.addAlias("ETD+SA", ETD);
        ActivationMethod.add(UVPD);
        File actMethodFile = Paths.get("params", "activationMethods.txt").toFile();
        if (actMethodFile.exists()) {
            ArrayList<String> paramLines = UserParam.parseFromFile(actMethodFile.getPath(), 2);
            for (String paramLine : paramLines) {
                String[] token = paramLine.split(",");
                String shortName = token[0];
                String fullName = token[1];
                ActivationMethod newMethod = new ActivationMethod(shortName, fullName);
                ActivationMethod.add(newMethod);
            }
        }
        cvTable = new HashMap();
        cvTable.put("MS:1000133", CID);
        cvTable.put("MS:1000598", ETD);
        cvTable.put("MS:1000422", HCD);
        cvTable.put("MS:1000599", PQD);
    }
}

