/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msdbsearch.SearchParams;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Modification;
import edu.ucsd.msjava.msutil.ModifiedAminoAcid;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AminoAcidSet
implements Iterable<AminoAcid> {
    private static final AminoAcid[] EMPTY_AA_ARRAY = new AminoAcid[0];
    private HashMap<Modification.Location, ArrayList<AminoAcid>> aaListMap;
    private static HashMap<Modification.Location, Modification.Location[]> locMap;
    private static Hashtable<String, Double> defaultModUsage;
    private HashMap<Character, AminoAcid> residueMap;
    private HashMap<AminoAcid, Integer> aa2index;
    private HashMap<Modification.Location, HashMap<Character, AminoAcid[]>> standardResidueAAArrayMap;
    private HashMap<Modification.Location, HashMap<Integer, AminoAcid[]>> nominalMass2aa;
    private AminoAcid[] allAminoAcidArr;
    private int maxNumberOfVariableModificationsPerPeptide = 3;
    private boolean containsModification;
    private boolean containsNTermModification;
    private boolean containsCTermModification;
    private boolean containsPhosphorylation;
    private boolean containsITRAQ;
    private boolean containsTMT;
    private HashSet<Character> modResidueSet = new HashSet();
    private char nextResidue;
    private int neighboringAACleavageCredit = 0;
    private int neighboringAACleavagePenalty = 0;
    private int peptideCleavageCredit = 0;
    private int peptideCleavagePenalty = 0;
    private float probCleavageSites = 0.0f;
    AminoAcid lightestAA;
    AminoAcid heaviestAA;
    private ArrayList<String> modificationsInUse = new ArrayList();
    private List<Modification.Instance> modifications;
    private static AminoAcidSet standardAASet;
    private static AminoAcidSet standardAASetWithCarbamidomethylatedCys;
    private static AminoAcidSet standardAASetWithCarboxyomethylatedCys;
    private static AminoAcidSet standardAASetWithCarbamidomethylatedCysWithTerm;
    private List<ModifiedAminoAcid> modAAList = new ArrayList<ModifiedAminoAcid>();

    private AminoAcidSet() {
        this.aaListMap = new HashMap();
        this.standardResidueAAArrayMap = new HashMap();
        for (Modification.Location location : Modification.Location.values()) {
            this.aaListMap.put(location, new ArrayList());
        }
        this.nextResidue = (char)128;
    }

    public ArrayList<AminoAcid> getAAList(Modification.Location location) {
        return this.aaListMap.get((Object)location);
    }

    public ArrayList<AminoAcid> getNTermAAList() {
        return this.aaListMap.get((Object)Modification.Location.N_Term);
    }

    public ArrayList<AminoAcid> getCTermAAList() {
        return this.aaListMap.get((Object)Modification.Location.C_Term);
    }

    public ArrayList<AminoAcid> getProtNTermAAList() {
        return this.aaListMap.get((Object)Modification.Location.Protein_N_Term);
    }

    public ArrayList<AminoAcid> getProtCTermAAList() {
        return this.aaListMap.get((Object)Modification.Location.Protein_N_Term);
    }

    public ArrayList<String> getModificationsInUse() {
        return this.modificationsInUse;
    }

    @Override
    public Iterator<AminoAcid> iterator() {
        return this.aaListMap.get((Object)Modification.Location.Anywhere).iterator();
    }

    public int size(Modification.Location location) {
        return this.aaListMap.get((Object)location).size();
    }

    public int size() {
        return this.aaListMap.get((Object)Modification.Location.Anywhere).size();
    }

    public AminoAcid[] getAminoAcids(Modification.Location location, char standardAAResidue) {
        AminoAcid[] matches = this.standardResidueAAArrayMap.get((Object)location).get(Character.valueOf(standardAAResidue));
        if (matches != null) {
            return matches;
        }
        return EMPTY_AA_ARRAY;
    }

    public AminoAcid[] getAminoAcids(Modification.Location location, int nominalMass) {
        AminoAcid[] matches = this.nominalMass2aa.get((Object)location).get(nominalMass);
        if (matches != null) {
            return matches;
        }
        return EMPTY_AA_ARRAY;
    }

    public AminoAcid[] getAminoAcids(int nominalMass) {
        return this.getAminoAcids(Modification.Location.Anywhere, nominalMass);
    }

    public boolean contains(char residue) {
        return this.residueMap.containsKey(Character.valueOf(residue));
    }

    public ArrayList<Character> getResidueListWithoutMods() {
        ArrayList<Character> residues = new ArrayList<Character>();
        for (Map.Entry<Character, AminoAcid> aa : this.residueMap.entrySet()) {
            char residue = aa.getValue().getUnmodResidue();
            if (residues.contains(Character.valueOf(residue))) continue;
            residues.add(Character.valueOf(residue));
        }
        return residues;
    }

    public ArrayList<Character> getResidueList() {
        return new ArrayList<Character>(this.residueMap.keySet());
    }

    public AminoAcid getAminoAcid(Modification.Location location, char residue) {
        AminoAcid[] aaArr;
        for (AminoAcid aa : aaArr = this.getAminoAcids(location, residue)) {
            if (aa.isModified()) continue;
            return aa;
        }
        return null;
    }

    public AminoAcid getAminoAcid(char residue) {
        return this.residueMap.get(Character.valueOf(residue));
    }

    public void setMaxNumberOfVariableModificationsPerPeptide(int maxNumberOfVariableModificationsPerPeptide) {
        this.maxNumberOfVariableModificationsPerPeptide = maxNumberOfVariableModificationsPerPeptide;
    }

    public int getMaxNumberOfVariableModificationsPerPeptide() {
        return this.maxNumberOfVariableModificationsPerPeptide;
    }

    public AminoAcid[] getAllAminoAcidArr() {
        return this.allAminoAcidArr;
    }

    public AminoAcid getAminoAcid(int index) {
        return this.allAminoAcidArr[index];
    }

    public int getIndex(AminoAcid aa) {
        Integer index = this.aa2index.get(aa);
        if (index == null) {
            index = -1;
        }
        return index;
    }

    public Peptide getPeptide(String sequence) {
        boolean isModified = false;
        ArrayList<AminoAcid> aaArray = new ArrayList<AminoAcid>();
        for (int i = 0; i < sequence.length(); ++i) {
            char residue = sequence.charAt(i);
            AminoAcid aa = this.getAminoAcid(residue);
            if (aa == null) {
                System.out.println(sequence + ": " + residue + " is null!");
            }
            assert (aa != null) : sequence + ": " + residue + " is null!";
            if (aa.isModified()) {
                isModified = true;
            }
            aaArray.add(aa);
        }
        Peptide pep = new Peptide(aaArray);
        pep.setModified(isModified);
        return pep;
    }

    public int getMaxNominalMass() {
        return this.heaviestAA.getNominalMass();
    }

    public int getMinNominalMass() {
        return this.lightestAA.getNominalMass();
    }

    public AminoAcid getLightestAA() {
        return this.lightestAA;
    }

    public AminoAcid getHeaviestAA() {
        return this.heaviestAA;
    }

    public boolean containsModification() {
        return this.containsModification;
    }

    public boolean containsNTermModification() {
        return this.containsNTermModification;
    }

    public boolean containsCTermModification() {
        return this.containsCTermModification;
    }

    public boolean containsPhosphorylation() {
        return this.containsPhosphorylation;
    }

    public boolean containsITRAQ() {
        return this.containsITRAQ;
    }

    public boolean containsTMT() {
        return this.containsTMT;
    }

    public char getMaxResidue() {
        return this.nextResidue;
    }

    public void registerEnzyme(Enzyme enzyme) {
        if (enzyme == null || enzyme.getResidues() == null || enzyme.getPeptideCleavageEfficiency() == 0.0f || enzyme.getNeighboringAACleavageEfficiency() == 0.0f) {
            return;
        }
        this.probCleavageSites = 0.0f;
        for (char residue : enzyme.getResidues()) {
            AminoAcid aa = this.getAminoAcid(residue);
            if (aa == null) {
                System.err.println("Invalid Enzyme cleavage site: " + residue);
                System.exit(-1);
            }
            this.probCleavageSites += aa.getProbability();
        }
        if (this.probCleavageSites == 0.0f || this.probCleavageSites == 1.0f) {
            System.err.println("Probability of enzyme residues must be in (0,1)!");
            System.exit(-1);
        }
        float peptideCleavageEfficiency = enzyme.getPeptideCleavageEfficiency();
        float neighboringAACleavageEfficiency = enzyme.getNeighboringAACleavageEfficiency();
        this.peptideCleavageCredit = (int)Math.round(Math.log(peptideCleavageEfficiency / this.probCleavageSites));
        this.peptideCleavagePenalty = (int)Math.round(Math.log((1.0f - peptideCleavageEfficiency) / (1.0f - this.probCleavageSites)));
        this.neighboringAACleavageCredit = (int)Math.round(Math.log(neighboringAACleavageEfficiency / this.probCleavageSites));
        this.neighboringAACleavagePenalty = (int)Math.round(Math.log((1.0f - neighboringAACleavageEfficiency) / (1.0f - this.probCleavageSites)));
    }

    public int getNeighboringAACleavageCredit() {
        return this.neighboringAACleavageCredit;
    }

    public int getNeighboringAACleavagePenalty() {
        return this.neighboringAACleavagePenalty;
    }

    public int getPeptideCleavageCredit() {
        return this.peptideCleavageCredit;
    }

    public int getPeptideCleavagePenalty() {
        return this.peptideCleavagePenalty;
    }

    public float getProbCleavageSites() {
        return this.probCleavageSites;
    }

    public void printAASet() {
        System.out.println("NumMods: " + this.getMaxNumberOfVariableModificationsPerPeptide());
        for (Modification.Location location : Modification.Location.values()) {
            ArrayList<AminoAcid> aaList = this.getAAList(location);
            System.out.println((Object)((Object)location) + "\t" + aaList.size());
            for (AminoAcid aa : aaList) {
                System.out.println(aa.getResidueStr() + (aa.isModified() ? "*" : "") + "\t" + aa.getResidue() + "\t" + aa.getNominalMass() + "\t" + aa.getMass() + "\t" + aa.getProbability());
            }
        }
    }

    private void addAminoAcid(AminoAcid aa) {
        this.addAminoAcid(aa, Modification.Location.Anywhere);
    }

    private void addAminoAcid(AminoAcid aa, Modification.Location location) {
        for (Modification.Location loc : locMap.get((Object)location)) {
            this.updateAAListMapAtLocation(loc, aa);
        }
    }

    private static boolean addModInstance(String modFileName, int lineNum, String dataLine, ArrayList<Modification.Instance> mods, Modification.Instance modIns) {
        for (Modification.Instance comparisonItem : mods) {
            if (modIns.getResidue() != comparisonItem.getResidue() || modIns.getLocation() != comparisonItem.getLocation() || !modIns.getModification().getName().equals(comparisonItem.getModification().getName())) continue;
            System.err.println("Error: The same modification is defined for the same residue twice; \nthe duplicate definition is on line " + lineNum + " in file " + modFileName + ": " + dataLine);
            return false;
        }
        mods.add(modIns);
        return true;
    }

    private void addFixedModToAAList(Modification.Instance modInstance, Modification.Location location, AminoAcid aa, ArrayList<AminoAcid> newAAList) {
        if (location == Modification.Location.Anywhere) {
            Modification mod = modInstance.getModification();
            AminoAcid modAA = aa.getAAWithFixedModification(mod);
            newAAList.add(modAA);
        } else {
            ModifiedAminoAcid modAA = this.getModifiedAminoAcid(aa, modInstance);
            newAAList.add(modAA);
        }
    }

    private void applyModifications(ArrayList<Modification.Instance> mods) {
        this.modifications = mods;
        this.modificationsInUse.clear();
        if (mods.size() == 0) {
            return;
        }
        HashMap<Modification.Location, ArrayList<Modification.Instance>> fixedMods = new HashMap<Modification.Location, ArrayList<Modification.Instance>>();
        HashMap<Modification.Location, ArrayList<Modification.Instance>> variableMods = new HashMap<Modification.Location, ArrayList<Modification.Instance>>();
        for (Modification.Location location : Modification.Location.values()) {
            fixedMods.put(location, new ArrayList());
            variableMods.put(location, new ArrayList());
        }
        for (Modification.Instance mod : mods) {
            if (mod.isFixedModification()) {
                ((ArrayList)fixedMods.get((Object)mod.getLocation())).add(mod);
                continue;
            }
            ((ArrayList)variableMods.get((Object)mod.getLocation())).add(mod);
        }
        Modification.Location[] locArr = new Modification.Location[]{Modification.Location.Anywhere, Modification.Location.N_Term, Modification.Location.C_Term, Modification.Location.Protein_N_Term, Modification.Location.Protein_C_Term};
        for (Modification.Location loc : locArr) {
            this.applyFixedMods(fixedMods, loc);
        }
        for (Modification.Location loc : locArr) {
            this.addVariableMods(variableMods, loc);
        }
        for (Modification.Instance mod : mods) {
            String modLocation;
            Modification.Location location = mod.getLocation();
            if (!(this.containsNTermModification || location != Modification.Location.N_Term && location != Modification.Location.Protein_N_Term)) {
                this.containsNTermModification = true;
            }
            if (!(this.containsCTermModification || location != Modification.Location.C_Term && location != Modification.Location.Protein_C_Term)) {
                this.containsCTermModification = true;
            }
            if (location != Modification.Location.Anywhere || !mod.isFixedModification()) {
                this.containsModification = true;
            }
            if (mod.getModification().getName().toLowerCase().startsWith("phospho")) {
                this.containsPhosphorylation = true;
            }
            if (mod.getModification().getName().toLowerCase().startsWith("itraq")) {
                this.containsITRAQ = true;
            }
            if (mod.getModification().getName().toLowerCase().startsWith("tmt")) {
                this.containsTMT = true;
            }
            String modType = mod.isFixedModification() ? "Fixed (static):     " : "Variable (dynamic): ";
            switch (mod.getLocation()) {
                case Anywhere: {
                    modLocation = "";
                    break;
                }
                case N_Term: {
                    modLocation = " at the peptide N-terminus";
                    break;
                }
                case C_Term: {
                    modLocation = " at the peptide C-terminus";
                    break;
                }
                case Protein_N_Term: {
                    modLocation = " at the protein N-terminus";
                    break;
                }
                case Protein_C_Term: {
                    modLocation = " at the protein C-terminus";
                    break;
                }
                default: {
                    modLocation = " at ???";
                }
            }
            Double modMass = mod.getModification().getAccurateMass();
            String formattedModMass = modMass > 0.0 ? "+" + AminoAcidSet.getRoundedMass(modMass) : AminoAcidSet.getRoundedMass(modMass);
            String modInfo = modType + mod.getModification().getName() + " on " + mod.getResidue() + modLocation + " (" + formattedModMass + ")";
            this.modificationsInUse.add(modInfo);
        }
    }

    private void applyFixedMods(HashMap<Modification.Location, ArrayList<Modification.Instance>> fixedMods, Modification.Location location) {
        ArrayList<AminoAcid> newAAList;
        ArrayList<AminoAcid> oldAAList;
        char residue;
        for (Modification.Instance modInstance : fixedMods.get((Object)location)) {
            residue = modInstance.getResidue();
            if (residue == '*') continue;
            oldAAList = this.getAAList(location);
            newAAList = new ArrayList<AminoAcid>();
            for (AminoAcid aa : oldAAList) {
                if (aa.getUnmodResidue() != residue) {
                    newAAList.add(aa);
                    continue;
                }
                this.addFixedModToAAList(modInstance, location, aa, newAAList);
            }
            this.updateAAListMapWithFixedModAA(location, newAAList);
        }
        for (Modification.Instance modInstance : fixedMods.get((Object)location)) {
            residue = modInstance.getResidue();
            if (residue != '*') continue;
            oldAAList = this.getAAList(location);
            newAAList = new ArrayList();
            for (AminoAcid aa : oldAAList) {
                this.addFixedModToAAList(modInstance, location, aa, newAAList);
            }
            this.updateAAListMapWithFixedModAA(location, newAAList);
        }
    }

    private void addVariableMods(HashMap<Modification.Location, ArrayList<Modification.Instance>> variableMods, Modification.Location location) {
        ModifiedAminoAcid modAA;
        char residue;
        ArrayList<AminoAcid> oldAAList;
        ArrayList<ModifiedAminoAcid> newAAList;
        for (Modification.Location loc : locMap.get((Object)location)) {
            newAAList = new ArrayList<ModifiedAminoAcid>();
            oldAAList = this.getAAList(loc);
            for (AminoAcid aminoAcid : oldAAList) {
                for (Modification.Instance mod : variableMods.get((Object)location)) {
                    residue = mod.getResidue();
                    if (residue == '*' || aminoAcid.getUnmodResidue() != residue || aminoAcid.isModified() && aminoAcid.hasResidueSpecificVariableMod()) continue;
                    modAA = this.getModifiedAminoAcid(aminoAcid, mod);
                    newAAList.add(modAA);
                }
            }
            for (AminoAcid aminoAcid : newAAList) {
                this.updateAAListMapAtLocation(loc, aminoAcid);
            }
        }
        for (Modification.Location loc : locMap.get((Object)location)) {
            newAAList = new ArrayList();
            oldAAList = this.getAAList(loc);
            for (AminoAcid aminoAcid : oldAAList) {
                for (Modification.Instance mod : variableMods.get((Object)location)) {
                    residue = mod.getResidue();
                    if (residue != '*' || aminoAcid.isModified() && aminoAcid.hasTerminalVariableMod()) continue;
                    modAA = this.getModifiedAminoAcid(aminoAcid, mod);
                    newAAList.add(modAA);
                }
            }
            for (AminoAcid aminoAcid : newAAList) {
                this.updateAAListMapAtLocation(loc, aminoAcid);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private AminoAcidSet finalizeSet() {
        void var8_13;
        this.standardResidueAAArrayMap = new HashMap();
        this.nominalMass2aa = new HashMap();
        for (Modification.Location location : Modification.Location.values()) {
            this.standardResidueAAArrayMap.put(location, new HashMap());
            this.nominalMass2aa.put(location, new HashMap());
        }
        HashSet<AminoAcid> allAASet = new HashSet<AminoAcid>();
        for (Modification.Location location : this.aaListMap.keySet()) {
            for (AminoAcid aa : this.aaListMap.get((Object)location)) {
                allAASet.add(aa);
            }
        }
        this.allAminoAcidArr = allAASet.toArray(EMPTY_AA_ARRAY);
        Arrays.sort(this.allAminoAcidArr);
        double minMass = Double.MAX_VALUE;
        int lightIndex = -1;
        double maxMass = Double.MIN_VALUE;
        int heavyIndex = -1;
        this.aa2index = new HashMap();
        boolean bl = false;
        while (var8_13 < this.allAminoAcidArr.length) {
            this.aa2index.put(this.allAminoAcidArr[var8_13], (int)var8_13);
            double mass = this.allAminoAcidArr[var8_13].getAccurateMass();
            if (mass < minMass) {
                lightIndex = var8_13;
                minMass = mass;
            }
            if (mass > maxMass) {
                heavyIndex = var8_13;
                maxMass = mass;
            }
            ++var8_13;
        }
        this.heaviestAA = this.allAminoAcidArr[heavyIndex];
        this.lightestAA = this.allAminoAcidArr[lightIndex];
        this.residueMap = new HashMap();
        for (AminoAcid aminoAcid : this.allAminoAcidArr) {
            assert (this.residueMap.get(Character.valueOf(aminoAcid.getResidue())) == null) : aminoAcid.getResidue() + " already exists!";
            this.residueMap.put(Character.valueOf(aminoAcid.getResidue()), aminoAcid);
        }
        for (Modification.Location location : Modification.Location.values()) {
            HashMap mass2aaList = new HashMap();
            HashMap stdResidue2aaList = new HashMap();
            for (AminoAcid aminoAcid : this.getAAList(location)) {
                int thisMass = aminoAcid.getNominalMass();
                if (!mass2aaList.containsKey(thisMass)) {
                    mass2aaList.put(thisMass, new ArrayList());
                }
                ((ArrayList)mass2aaList.get(thisMass)).add(aminoAcid);
                char stdResidue = aminoAcid.getUnmodResidue();
                LinkedList<AminoAcid> aaList = (LinkedList<AminoAcid>)stdResidue2aaList.get(Character.valueOf(stdResidue));
                if (aaList == null) {
                    aaList = new LinkedList<AminoAcid>();
                }
                if (!aminoAcid.isModified()) {
                    aaList.addFirst(aminoAcid);
                } else {
                    aaList.addLast(aminoAcid);
                }
                stdResidue2aaList.put(Character.valueOf(stdResidue), aaList);
            }
            HashMap<Integer, AminoAcid[]> mass2aaArray = new HashMap<Integer, AminoAcid[]>();
            Iterator iterator = mass2aaList.keySet().iterator();
            while (iterator.hasNext()) {
                int mass = (Integer)iterator.next();
                mass2aaArray.put(mass, ((ArrayList)mass2aaList.get(mass)).toArray(new AminoAcid[0]));
            }
            HashMap<Character, AminoAcid[]> hashMap = new HashMap<Character, AminoAcid[]>();
            Iterator iterator2 = stdResidue2aaList.keySet().iterator();
            while (iterator2.hasNext()) {
                char residue = ((Character)iterator2.next()).charValue();
                hashMap.put(Character.valueOf(residue), ((LinkedList)stdResidue2aaList.get(Character.valueOf(residue))).toArray(new AminoAcid[0]));
            }
            this.nominalMass2aa.put(location, mass2aaArray);
            this.standardResidueAAArrayMap.put(location, hashMap);
        }
        return this;
    }

    public static AminoAcidSet getAminoAcidSetFromModFile(String modFilePath, ParamManager paramManager) {
        String dataLine;
        BufferedLineReader reader = null;
        File modFile = new File(modFilePath);
        try {
            reader = new BufferedLineReader(modFile.getPath());
        }
        catch (IOException e) {
            System.err.println("Error opening modification file " + modFile.getPath());
            e.printStackTrace();
            System.exit(-1);
        }
        ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
        ArrayList<AminoAcid> customAA = new ArrayList<AminoAcid>();
        String sourceFileName = modFile.getName();
        int lineNum = 0;
        int maxNumMods = paramManager.getMaxNumModsPerPeptide();
        ModificationMetadata modMetadata = new ModificationMetadata(maxNumMods);
        while ((dataLine = reader.readLine()) != null) {
            boolean success;
            if (success = AminoAcidSet.parseConfigEntry(sourceFileName, ++lineNum, dataLine, mods, customAA, modMetadata)) continue;
            System.exit(-1);
        }
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSetAndUpdateParams(mods, customAA, modMetadata, paramManager);
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aaSet;
    }

    public static AminoAcidSet getAminoAcidSetFromList(String modConfigFilePath, Hashtable<Integer, String> customAAByLine, Hashtable<Integer, String> modsByLine, ParamManager paramManager) {
        ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
        ArrayList<AminoAcid> customAA = new ArrayList<AminoAcid>();
        int maxNumMods = paramManager.getMaxNumModsPerPeptide();
        ModificationMetadata modMetadata = new ModificationMetadata(maxNumMods);
        customAAByLine.forEach((? super K lineNum, ? super V dataLine) -> {
            boolean success = AminoAcidSet.parseConfigEntry(modConfigFilePath, lineNum, dataLine, mods, customAA, modMetadata);
            if (!success) {
                System.exit(-1);
            }
        });
        modsByLine.forEach((? super K lineNum, ? super V dataLine) -> {
            boolean success = AminoAcidSet.parseConfigEntry(modConfigFilePath, lineNum, dataLine, mods, customAA, modMetadata);
            if (!success) {
                System.exit(-1);
            }
        });
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSetAndUpdateParams(mods, customAA, modMetadata, paramManager);
        return aaSet;
    }

    private static AminoAcidSet getAminoAcidSetAndUpdateParams(ArrayList<Modification.Instance> mods, ArrayList<AminoAcid> customAA, ModificationMetadata modMetadata, ParamManager paramManager) {
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSet(mods, customAA);
        int maxNumMods = modMetadata.getMaxNumModsPerPeptide();
        if (maxNumMods != paramManager.getMaxNumModsPerPeptide()) {
            paramManager.setMaxNumMods(maxNumMods);
        }
        aaSet.setMaxNumberOfVariableModificationsPerPeptide(maxNumMods);
        return aaSet;
    }

    private static boolean parseConfigEntry(String sourceFilePath, int lineNum, String dataLine, ArrayList<Modification.Instance> mods, ArrayList<AminoAcid> customAA, ModificationMetadata modMetadata) {
        String modSetting = SearchParams.getConfigLineWithoutComment(dataLine);
        if (modSetting.length() == 0) {
            return true;
        }
        if (modSetting.toLowerCase().startsWith("nummods=")) {
            try {
                String value = modSetting.split("=")[1];
                int numMods = Integer.parseInt(value.trim());
                modMetadata.setMaxNumModsPerPeptide(numMods);
            }
            catch (NumberFormatException e) {
                System.err.println("Error: Invalid NumMods option at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
                e.printStackTrace();
                return false;
            }
        }
        String[] modInfo = modSetting.split(",");
        if (modInfo.length < 5) {
            System.out.println("Ignoring line " + lineNum + " in file " + sourceFilePath + " since does not have 5 parts separated by commas: " + modSetting);
            return true;
        }
        double modMass = 0.0;
        String compStr = modInfo[0].trim();
        Double mass = Composition.getMass(compStr);
        if (mass != null) {
            modMass = mass;
        } else {
            try {
                modMass = Double.parseDouble(compStr);
            }
            catch (NumberFormatException e) {
                System.err.println("Error: Invalid Mass/Composition at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
                e.printStackTrace();
                return false;
            }
        }
        String customAAResidues = modMetadata.getCustomAAResidues();
        String residueStr = modInfo[1].trim();
        boolean isResidueStrLegitimate = true;
        boolean matchesCustomAA = false;
        if (!residueStr.equals("*")) {
            if (residueStr.length() > 0) {
                for (int i = 0; i < residueStr.length(); ++i) {
                    boolean matchesCustom;
                    boolean bl = matchesCustom = customAAResidues.indexOf(residueStr.charAt(i)) > -1;
                    if (matchesCustom) {
                        matchesCustomAA = true;
                    }
                    if (matchesCustom || AminoAcid.isStdAminoAcid(residueStr.charAt(i))) continue;
                    isResidueStrLegitimate = false;
                    break;
                }
            } else {
                isResidueStrLegitimate = false;
            }
        }
        boolean isFixedModification = false;
        boolean isCustomAminoAcid = false;
        String settingType = modInfo[2].trim();
        if (settingType.equalsIgnoreCase("fix")) {
            isFixedModification = true;
        } else if (settingType.equalsIgnoreCase("opt")) {
            isFixedModification = false;
        } else if (settingType.equalsIgnoreCase("custom")) {
            isCustomAminoAcid = true;
        } else {
            System.err.println("Error: Modification must be fix, opt, optset#, or custom at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
            return false;
        }
        if (!isResidueStrLegitimate && !isCustomAminoAcid || isCustomAminoAcid && matchesCustomAA) {
            System.err.println("Error: Invalid Residue(s) at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
            return false;
        }
        if (isCustomAminoAcid && (residueStr.length() > 1 || !residueStr.toLowerCase().matches("[bjouxz]"))) {
            System.err.println("Error: Invalid Residue(s) at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
            System.err.println("Custom Amino acids are only allowed using B, J, O, U, X, or Z as the custom symbol.");
            return false;
        }
        if (isCustomAminoAcid && !Composition.removeWhitespace(compStr).matches("([CHNOS][0-9]{0,3})+")) {
            System.err.println("Error: Invalid composition/mass at line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
            System.err.println("Custom Amino acids must supply a composition string, and must not use elements other than C H N O S.");
            return false;
        }
        Modification.Location location = null;
        String locStr = AminoAcidSet.getFirstWord(modInfo[3]);
        if (locStr.equalsIgnoreCase("any")) {
            location = Modification.Location.Anywhere;
        } else if (locStr.equalsIgnoreCase("N-Term") || locStr.equalsIgnoreCase("NTerm")) {
            location = Modification.Location.N_Term;
        } else if (locStr.equalsIgnoreCase("C-Term") || locStr.equalsIgnoreCase("CTerm")) {
            location = Modification.Location.C_Term;
        } else if (locStr.equalsIgnoreCase("Prot-N-Term") || locStr.equalsIgnoreCase("ProtNTerm")) {
            location = Modification.Location.Protein_N_Term;
        } else if (locStr.equalsIgnoreCase("Prot-C-Term") || locStr.equalsIgnoreCase("ProtCTerm")) {
            location = Modification.Location.Protein_C_Term;
        } else if (!isCustomAminoAcid) {
            System.err.println("Error: Invalid Location '" + locStr + "'; expecting any, N-Term, C-Term, or similar; see line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
            return false;
        }
        if (!isCustomAminoAcid) {
            String modName = AminoAcidSet.getCleanModName(modInfo[4]);
            if (AminoAcidSet.isModConflict(sourceFilePath, lineNum, modSetting, modName, modMass)) {
                return false;
            }
            Modification mod = Modification.register(modName, modMass);
            for (int i = 0; i < residueStr.length(); ++i) {
                char residue = residueStr.charAt(i);
                Modification.Instance modIns = new Modification.Instance(mod, residue, location);
                if (isFixedModification) {
                    modIns.fixedModification();
                }
                if (AminoAcidSet.addModInstance(sourceFilePath, lineNum, modSetting, mods, modIns)) continue;
                return false;
            }
        } else {
            String customAminoAcidDescription = AminoAcidSet.getCleanModName(modInfo[4], false);
            char customAminoAcidSymbol = residueStr.charAt(0);
            AminoAcid aa = new AminoAcid(customAminoAcidSymbol, customAminoAcidDescription, new Composition(compStr));
            if (customAAResidues.contains(Character.toString(customAminoAcidSymbol))) {
                System.err.println("Error: Duplicate custom amino acid symbol; \nthe duplicate definition is on line " + lineNum + " in file " + sourceFilePath + ": " + modSetting);
                return false;
            }
            modMetadata.addCustomAminoAcidSymbol(customAminoAcidSymbol);
            customAA.add(aa);
        }
        return true;
    }

    public static AminoAcidSet getAminoAcidSetFromXMLFile(String modFilePath) {
        String dataLine;
        File modFile = new File(modFilePath);
        BufferedLineReader reader = null;
        try {
            reader = new BufferedLineReader(modFile.getPath());
        }
        catch (IOException e) {
            System.err.println("Error opening modification file " + modFile.getPath());
            e.printStackTrace();
            System.exit(-1);
        }
        int numMods = 3;
        String numModsKey = "<parameter name=\"ptm.mods\">";
        String cysKey = "<parameter name=\"cysteine_protease.cysteine\">";
        String oxidationKey = "<parameter name=\"ptm.OXIDATION\">on</parameter>";
        String lysMetKey = "<parameter name=\"ptm.LYSINE_METHYLATION\">on</parameter>";
        String pyrogluKey = "<parameter name=\"ptm.PYROGLUTAMATE_FORMATION\">on</parameter>";
        String phosphoKey = "<parameter name=\"ptm.PHOSPHORYLATION\">on</parameter>";
        String ntermCarbamylKey = "<parameter name=\"ptm.NTERM_CARBAMYLATION\">on</parameter>";
        String ntermAcetylKey = "<parameter name=\"ptm.NTERM_ACETYLATION\">on</parameter>";
        String ptmKey = "<parameter name=\"ptm.custom_PTM\">";
        String closeKey = "</parameter>";
        ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
        int lineNum = 0;
        while ((dataLine = reader.readLine()) != null) {
            Modification.Instance modIns;
            String residueStr;
            String value;
            ++lineNum;
            if (dataLine.startsWith(numModsKey)) {
                try {
                    value = dataLine.substring(numModsKey.length(), dataLine.lastIndexOf(closeKey));
                    numMods = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error: Invalid ptm.mods option at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                    e.printStackTrace();
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(cysKey)) {
                Modification.Instance modIns2;
                value = dataLine.substring(cysKey.length(), dataLine.lastIndexOf(closeKey));
                if (value.equalsIgnoreCase("c57")) {
                    char residue = 'C';
                    Modification mod = Modification.Carbamidomethyl;
                    modIns2 = new Modification.Instance(mod, residue, Modification.Location.Anywhere).fixedModification();
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns2)) continue;
                    System.exit(-1);
                    continue;
                }
                if (value.equalsIgnoreCase("c58")) {
                    char residue = 'C';
                    Modification mod = Modification.Carboxymethyl;
                    modIns2 = new Modification.Instance(mod, residue, Modification.Location.Anywhere).fixedModification();
                    mods.add(modIns2);
                    continue;
                }
                if (value.equalsIgnoreCase("c99")) {
                    char residue = 'C';
                    Modification mod = Modification.NIPCAM;
                    modIns2 = new Modification.Instance(mod, residue, Modification.Location.Anywhere).fixedModification();
                    mods.add(modIns2);
                    continue;
                }
                if (value.equalsIgnoreCase("None")) continue;
                System.err.println("Error: Invalid Cysteine protecting group at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                System.exit(-1);
                continue;
            }
            if (dataLine.startsWith(ptmKey)) {
                value = dataLine.substring(ptmKey.length(), dataLine.lastIndexOf(closeKey));
                String[] token = value.split(",");
                if (token.length != 3) {
                    System.err.println("Error: Invalid custom ptm option at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                    System.exit(-1);
                }
                double modMass = 0.0;
                try {
                    modMass = Double.parseDouble(token[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error: Invalid Mass at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                    e.printStackTrace();
                    System.exit(-1);
                }
                String residueStr2 = token[1];
                boolean isResidueStrLegitimate = true;
                if (!residueStr2.equals("*")) {
                    if (residueStr2.length() > 0) {
                        for (int i = 0; i < residueStr2.length(); ++i) {
                            if (AminoAcid.isStdAminoAcid(residueStr2.charAt(i))) continue;
                            isResidueStrLegitimate = false;
                            break;
                        }
                    } else {
                        isResidueStrLegitimate = false;
                    }
                }
                if (!isResidueStrLegitimate) {
                    System.err.println("Error: Invalid Residue(s) at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                    System.exit(-1);
                }
                Modification.Location location = null;
                boolean isFixedModification = false;
                String locStr = token[2];
                if (locStr.equalsIgnoreCase("fix")) {
                    isFixedModification = true;
                    location = Modification.Location.Anywhere;
                } else if (locStr.equalsIgnoreCase("opt")) {
                    isFixedModification = false;
                    location = Modification.Location.Anywhere;
                } else if (locStr.equalsIgnoreCase("opt_nterm")) {
                    isFixedModification = false;
                    location = Modification.Location.N_Term;
                } else if (locStr.equalsIgnoreCase("fix_nterm")) {
                    isFixedModification = true;
                    location = Modification.Location.N_Term;
                } else if (locStr.equalsIgnoreCase("opt_cterm")) {
                    isFixedModification = false;
                    location = Modification.Location.C_Term;
                } else if (locStr.equalsIgnoreCase("fix_cterm")) {
                    isFixedModification = true;
                    location = Modification.Location.C_Term;
                } else {
                    System.err.println("Error: Invalid custom_PTM location at line " + lineNum + " in file " + modFile.getName() + ": " + dataLine);
                    System.exit(-1);
                }
                String modResiduesAndMass = residueStr2 + " " + modMass;
                if (AminoAcidSet.isModConflict(modFile.getName(), lineNum, dataLine, modResiduesAndMass, modMass)) {
                    System.exit(-1);
                }
                Modification mod = Modification.register(modResiduesAndMass, modMass);
                for (int i = 0; i < residueStr2.length(); ++i) {
                    char residue = residueStr2.charAt(i);
                    Modification.Instance modIns3 = new Modification.Instance(mod, residue, location);
                    if (isFixedModification) {
                        modIns3.fixedModification();
                    }
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns3)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(oxidationKey)) {
                residueStr = "M";
                Modification mod = Modification.Oxidation;
                for (int i = 0; i < residueStr.length(); ++i) {
                    char residue = residueStr.charAt(i);
                    modIns = new Modification.Instance(mod, residue, Modification.Location.Anywhere);
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(lysMetKey)) {
                residueStr = "K";
                Modification mod = Modification.Methyl;
                for (int i = 0; i < residueStr.length(); ++i) {
                    char residue = residueStr.charAt(i);
                    modIns = new Modification.Instance(mod, residue, Modification.Location.Anywhere);
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(pyrogluKey)) {
                residueStr = "Q";
                Modification mod = Modification.PyroGluQ;
                for (int i = 0; i < residueStr.length(); ++i) {
                    char residue = residueStr.charAt(i);
                    modIns = new Modification.Instance(mod, residue, Modification.Location.N_Term);
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(phosphoKey)) {
                residueStr = "STY";
                Modification mod = Modification.Phospho;
                for (int i = 0; i < residueStr.length(); ++i) {
                    char residue = residueStr.charAt(i);
                    modIns = new Modification.Instance(mod, residue, Modification.Location.Anywhere);
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (dataLine.startsWith(ntermCarbamylKey)) {
                residueStr = "*";
                Modification mod = Modification.Carbamyl;
                for (int i = 0; i < residueStr.length(); ++i) {
                    char residue = residueStr.charAt(i);
                    modIns = new Modification.Instance(mod, residue, Modification.Location.N_Term);
                    if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                    System.exit(-1);
                }
                continue;
            }
            if (!dataLine.startsWith(ntermAcetylKey)) continue;
            residueStr = "*";
            Modification mod = Modification.Acetyl;
            for (int i = 0; i < residueStr.length(); ++i) {
                char residue = residueStr.charAt(i);
                modIns = new Modification.Instance(mod, residue, Modification.Location.N_Term);
                if (AminoAcidSet.addModInstance(modFile.getName(), lineNum, dataLine, mods, modIns)) continue;
                System.exit(-1);
            }
        }
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSet(mods);
        aaSet.setMaxNumberOfVariableModificationsPerPeptide(numMods);
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aaSet;
    }

    public List<Modification.Instance> getModifications() {
        return this.modifications;
    }

    public static AminoAcidSet getAminoAcidSet(String aaFilePath) {
        String dataLine;
        AminoAcidSet aaSet = new AminoAcidSet();
        BufferedLineReader reader = null;
        File aaFile = new File(aaFilePath);
        try {
            reader = new BufferedLineReader(aaFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int lineNum = 0;
        boolean fileType = false;
        while ((dataLine = reader.readLine()) != null) {
            AminoAcid aa;
            String[] token;
            ++lineNum;
            if (dataLine.startsWith("#") || dataLine.length() == 0) continue;
            if (!fileType && Character.isDigit(dataLine.charAt(0))) {
                fileType = true;
                continue;
            }
            if (!fileType) {
                char residue;
                token = dataLine.split(",");
                if (token.length != 3) {
                    System.out.println("Ignoring line " + lineNum + " in file " + aaFile.getName() + " since not 3 comma separated fields");
                    continue;
                }
                String residueStr = token[0].trim();
                if (residueStr.length() != 1) {
                    System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (residue must be a single character): " + dataLine);
                    System.exit(-1);
                }
                if (!Character.isUpperCase(residue = residueStr.charAt(0))) {
                    System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (residue must be an uppercase letter): " + dataLine);
                    System.exit(-1);
                }
                String name = token[1].trim();
                if (token[2].matches("(C\\d+)*(H\\d+)*(N\\d+)*(O\\d+)*(S\\d+)*")) {
                    String compositionStr = token[2].trim();
                    Composition composition = new Composition(compositionStr);
                    aa = AminoAcid.getAminoAcid(residue, name, composition);
                } else {
                    double mass = -1.0;
                    try {
                        mass = Double.parseDouble(token[2]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (should be a composition like C5H7NO3 or a mass): " + dataLine);
                        System.exit(-1);
                    }
                    aa = AminoAcid.getCustomAminoAcid(residue, name, mass);
                }
            } else {
                token = dataLine.split("=");
                if (token.length != 2) {
                    System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (splitting on = should give 2 items): " + dataLine);
                    System.exit(-1);
                }
                if (token[0].length() != 1) {
                    System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (amino acid symbol must be a single character): " + dataLine);
                    System.exit(-1);
                }
                if (!Character.isLetter(token[0].charAt(0))) {
                    System.err.println("Error: Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (amino acid symbol must be a letter): " + dataLine);
                    System.exit(-1);
                }
                char residue = token[0].charAt(0);
                String name = token[0];
                float mass = -1.0f;
                float prob = 0.05f;
                String probabilityAddon = "";
                try {
                    if (!token[1].contains(",")) {
                        mass = Float.parseFloat(token[1]);
                    } else {
                        probabilityAddon = " or probability";
                        mass = Float.parseFloat(token[1].split(",")[0]);
                        prob = Float.parseFloat(token[1].split(",")[1]);
                    }
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (NumberFormatException parsing the mass" + probabilityAddon + "): " + dataLine);
                    System.exit(-1);
                }
                if (mass <= 0.0f) {
                    System.err.println("Invalid AASet file format at line " + lineNum + " in file " + aaFile.getName() + " (could not parse the mass" + probabilityAddon + "): " + dataLine);
                    System.exit(-1);
                }
                aa = AminoAcid.getCustomAminoAcid(residue, name, mass).setProbability(prob);
            }
            aaSet.addAminoAcid(aa);
        }
        aaSet.finalizeSet();
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aaSet;
    }

    public static AminoAcidSet getStandardAminoAcidSet() {
        if (standardAASet == null) {
            standardAASet = new AminoAcidSet();
            for (AminoAcid aa : AminoAcid.getStandardAminoAcids()) {
                standardAASet.addAminoAcid(aa);
            }
            standardAASet.finalizeSet();
        }
        return standardAASet;
    }

    public static AminoAcidSet getStandardAminoAcidSetWithFixedCarbamidomethylatedCys() {
        if (standardAASetWithCarbamidomethylatedCys == null) {
            ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
            mods.add(new Modification.Instance(Modification.Carbamidomethyl, 'C').fixedModification());
            standardAASetWithCarbamidomethylatedCys = AminoAcidSet.getAminoAcidSet(mods);
        }
        return standardAASetWithCarbamidomethylatedCys;
    }

    public static AminoAcidSet getStandardAminoAcidSetWithFixedCarboxymethylatedCys() {
        if (standardAASetWithCarboxyomethylatedCys == null) {
            ArrayList<Modification.Instance> mods = new ArrayList<Modification.Instance>();
            mods.add(new Modification.Instance(Modification.Carboxymethyl, 'C').fixedModification());
            standardAASetWithCarboxyomethylatedCys = AminoAcidSet.getAminoAcidSet(mods);
        }
        return standardAASetWithCarboxyomethylatedCys;
    }

    public static AminoAcidSet getStandardAminoAcidSetWithFixedCarbamidomethylatedCysWithTerm() {
        if (standardAASetWithCarbamidomethylatedCysWithTerm == null) {
            Modification.Instance[] mods = new Modification.Instance[]{new Modification.Instance(Modification.Carbamidomethyl, 'C').fixedModification()};
            HashMap<Character, Modification.Instance> modTable = new HashMap<Character, Modification.Instance>();
            for (Modification.Instance mod : mods) {
                if (!mod.isFixedModification()) continue;
                modTable.put(Character.valueOf(mod.getResidue()), mod);
            }
            AminoAcidSet aaSet = new AminoAcidSet();
            for (AminoAcid aa : AminoAcid.getStandardAminoAcids()) {
                Modification.Instance mod = (Modification.Instance)modTable.get(aa);
                if (mod == null) {
                    aaSet.addAminoAcid(aa);
                    continue;
                }
                aaSet.addAminoAcid(aa.getAAWithFixedModification(mod.getModification()));
            }
            aaSet.addAminoAcid(AminoAcid.getCustomAminoAcid('X', new Composition(2, 6, 1, 1, 0).getMass()));
            standardAASetWithCarbamidomethylatedCysWithTerm = aaSet.finalizeSet();
        }
        return standardAASetWithCarbamidomethylatedCysWithTerm;
    }

    public static AminoAcidSet getAminoAcidSet(ArrayList<Modification.Instance> mods) {
        AminoAcidSet aaSet = new AminoAcidSet();
        for (AminoAcid aa : AminoAcidSet.getStandardAminoAcidSet()) {
            aaSet.addAminoAcid(aa);
        }
        aaSet.applyModifications(mods);
        aaSet.finalizeSet();
        return aaSet;
    }

    public static AminoAcidSet getAminoAcidSet(ArrayList<Modification.Instance> mods, ArrayList<AminoAcid> customAminoAcids) {
        AminoAcidSet aaSet = new AminoAcidSet();
        for (AminoAcid aa : AminoAcidSet.getStandardAminoAcidSet()) {
            aaSet.addAminoAcid(aa);
        }
        for (AminoAcid aa : customAminoAcids) {
            aaSet.addAminoAcid(aa);
        }
        aaSet.applyModifications(mods);
        aaSet.finalizeSet();
        return aaSet;
    }

    public static AminoAcidSet getAminoAcidSet(AminoAcidSet baseAASet, ArrayList<Modification.Instance> mods) {
        AminoAcidSet aaSet = new AminoAcidSet();
        for (AminoAcid aa : baseAASet) {
            aaSet.addAminoAcid(aa);
        }
        aaSet.applyModifications(mods);
        aaSet.finalizeSet();
        return aaSet;
    }

    public static AminoAcidSet getAminoAcidSetFromModAAList(AminoAcidSet baseAASet, ArrayList<AminoAcid> modifiedAAList) {
        AminoAcidSet aaSet = new AminoAcidSet();
        for (AminoAcid aa : baseAASet) {
            aaSet.addAminoAcid(aa);
        }
        for (AminoAcid aa : modifiedAAList) {
            aaSet.addAminoAcid(aa);
        }
        aaSet.finalizeSet();
        return aaSet;
    }

    private static String getCleanModName(String modName) {
        return AminoAcidSet.getCleanModName(modName, true);
    }

    private static String getCleanModName(String modName, Boolean autoUpdateToCanonicalName) {
        String cleanName = AminoAcidSet.getFirstWord(modName);
        if (!autoUpdateToCanonicalName.booleanValue()) {
            return cleanName;
        }
        switch (cleanName.toLowerCase()) {
            case "acetylated": 
            case "acetylation": {
                return "Acetyl";
            }
            case "alkylated": 
            case "alkylation": {
                return "Carbamidomethyl";
            }
            case "carbamylated": 
            case "carbamylation": {
                return "Carbamyl";
            }
            case "deamidated": 
            case "deamidation": {
                return "Deamidated";
            }
            case "methylated": 
            case "methylation": {
                return "Methyl";
            }
            case "phosphorylated": 
            case "phosphorylation": {
                return "Phospho";
            }
        }
        for (Modification defaultMod : Modification.getDefaultModList()) {
            String defaultModName = defaultMod.getName();
            if (!defaultModName.equalsIgnoreCase(cleanName)) continue;
            return defaultModName;
        }
        return cleanName;
    }

    private static String getFirstWord(String value) {
        return value.trim().split("\\s+")[0].trim();
    }

    private char getModifiedResidue(char unmodifiedResidue) {
        char lowerCaseR;
        if (!Character.isUpperCase(unmodifiedResidue)) {
            System.err.println("Invalid unmodified residue: " + unmodifiedResidue);
            System.exit(-1);
        }
        if (!this.modResidueSet.contains(Character.valueOf(lowerCaseR = Character.toLowerCase(unmodifiedResidue)))) {
            this.modResidueSet.add(Character.valueOf(lowerCaseR));
            return lowerCaseR;
        }
        char symbol = this.nextResidue;
        this.nextResidue = (char)(this.nextResidue + '\u0001');
        if (this.nextResidue > '\uffff') {
            System.err.println("Too many modifications!");
            System.exit(-1);
        }
        return symbol;
    }

    private static String getRoundedMass(double mass) {
        DecimalFormat massFormatter = new DecimalFormat("#.0###");
        return massFormatter.format(mass);
    }

    private static boolean isModConflict(String modFileName, int lineNum, String dataLine, String modName, double modMass) {
        if (!Modification.isModConflict(modName, modMass)) {
            return false;
        }
        Modification existingMod = Modification.getModByName(modName);
        Double existingOverrideMass = defaultModUsage.get(modName);
        if (existingOverrideMass != null) {
            if (Math.abs(existingOverrideMass - modMass) <= 0.01) {
                return false;
            }
        } else {
            for (Modification defaultMod : Modification.getDefaultModList()) {
                if (!defaultMod.getName().equals(modName)) continue;
                System.out.println("Warning: Non-standard modification mass defined on line " + lineNum + " in file " + modFileName + ": " + dataLine);
                System.out.println("Modification " + modName + " typically has mass " + AminoAcidSet.getRoundedMass(existingMod.getAccurateMass()));
                System.out.println("Overriding with user-defined value of " + AminoAcidSet.getRoundedMass(modMass));
                defaultModUsage.put(modName, modMass);
                return false;
            }
        }
        System.err.println("Error: Two modifications are defined with the same name but different masses; \nthe duplicate definition is on line " + lineNum + " in file " + modFileName + ": " + dataLine);
        System.err.println("Modification " + modName + " is already defined with mass " + AminoAcidSet.getRoundedMass(existingMod.getAccurateMass()));
        System.err.println("The duplicate definition has mass " + AminoAcidSet.getRoundedMass(modMass));
        return true;
    }

    private ModifiedAminoAcid getModifiedAminoAcid(AminoAcid targetAA, Modification.Instance modInstance) {
        ModifiedAminoAcid modAA2;
        for (ModifiedAminoAcid modAA2 : this.modAAList) {
            if (modAA2.getTargetAA() != targetAA || modAA2.getModification() != modInstance.getModification()) continue;
            return modAA2;
        }
        char modResidue = this.getModifiedResidue(targetAA.getUnmodResidue());
        modAA2 = new ModifiedAminoAcid(targetAA, modInstance, modResidue);
        this.modAAList.add(modAA2);
        return modAA2;
    }

    private void updateAAListMapAtLocation(Modification.Location loc, AminoAcid aa) {
        ArrayList<AminoAcid> aaList = this.aaListMap.get((Object)loc);
        aaList.add(aa);
    }

    private void updateAAListMapWithFixedModAA(Modification.Location location, ArrayList<AminoAcid> newAAList) {
        for (Modification.Location loc : locMap.get((Object)location)) {
            this.aaListMap.put(loc, new ArrayList<AminoAcid>(newAAList));
        }
    }

    public static void main(String[] argv) {
        ParamManager paramManager = new ParamManager("MS-GF+ AminoAcidSet", "Release (v2024.03.26)", "26 March 2024", "n/a");
        Path modFilePath = Paths.get(System.getProperty("user.home") + "Research", "Data", "Debug", "mods.txt");
        AminoAcidSet aaSet = AminoAcidSet.getAminoAcidSetFromModFile(modFilePath.toString(), paramManager);
        aaSet.printAASet();
    }

    static {
        defaultModUsage = new Hashtable();
        locMap = new HashMap();
        locMap.put(Modification.Location.Anywhere, new Modification.Location[]{Modification.Location.Anywhere, Modification.Location.N_Term, Modification.Location.C_Term, Modification.Location.Protein_N_Term, Modification.Location.Protein_C_Term});
        locMap.put(Modification.Location.N_Term, new Modification.Location[]{Modification.Location.N_Term, Modification.Location.Protein_N_Term});
        locMap.put(Modification.Location.C_Term, new Modification.Location[]{Modification.Location.C_Term, Modification.Location.Protein_C_Term});
        locMap.put(Modification.Location.Protein_N_Term, new Modification.Location[]{Modification.Location.Protein_N_Term});
        locMap.put(Modification.Location.Protein_C_Term, new Modification.Location[]{Modification.Location.Protein_C_Term});
        standardAASet = null;
        standardAASetWithCarbamidomethylatedCys = null;
        standardAASetWithCarboxyomethylatedCys = null;
        standardAASetWithCarbamidomethylatedCysWithTerm = null;
    }

    private static class ModificationMetadata {
        int maxNumModsPerPeptide;
        String customAAResidues;

        public ModificationMetadata(int maxNumModsPerPeptide) {
            this.maxNumModsPerPeptide = maxNumModsPerPeptide;
            this.customAAResidues = "";
        }

        public void addCustomAminoAcidSymbol(char customAminoAcidSymbol) {
            this.customAAResidues = this.customAAResidues + customAminoAcidSymbol;
        }

        public void setMaxNumModsPerPeptide(int newModCount) {
            this.maxNumModsPerPeptide = newModCount;
        }

        public int getMaxNumModsPerPeptide() {
            return this.maxNumModsPerPeptide;
        }

        public String getCustomAAResidues() {
            return this.customAAResidues;
        }
    }
}

