/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.misc.ExceptionCapturer;
import edu.ucsd.msjava.misc.ProgressData;
import edu.ucsd.msjava.misc.ProgressReporter;
import edu.ucsd.msjava.misc.ThreadPoolExecutorWithExceptions;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraAccessor;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.mzid.MzIDParser;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AnnotatedSpectra
implements ProgressReporter,
ExceptionCapturer {
    private File[] resultFiles;
    private File specDir;
    private AminoAcidSet aaSet;
    private float fdrThreshold = 0.01f;
    private ProgressData progress;
    private boolean dropErrorDatasets = false;
    private Throwable exception = null;
    private SpectraContainer annotatedSpectra;

    @Override
    public void setProgressData(ProgressData data) {
        this.progress = data;
    }

    @Override
    public ProgressData getProgressData() {
        return this.progress;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public void setDropErrorDatasets(boolean dropErrors) {
        this.dropErrorDatasets = dropErrors;
    }

    public AnnotatedSpectra(File[] resultFiles, File specDir, AminoAcidSet aaSet) {
        this.resultFiles = resultFiles;
        this.specDir = specDir;
        this.aaSet = aaSet;
        this.progress = null;
    }

    public AnnotatedSpectra(File[] resultFiles, File specDir, AminoAcidSet aaSet, float fdrThreshold, boolean dropErrors) {
        this.resultFiles = resultFiles;
        this.specDir = specDir;
        this.aaSet = aaSet;
        this.fdrThreshold = fdrThreshold;
        this.dropErrorDatasets = dropErrors;
        this.progress = null;
    }

    public AnnotatedSpectra fdrThreshold(float fdrThreshold) {
        this.fdrThreshold = fdrThreshold;
        return this;
    }

    public SpectraContainer getAnnotatedSpecContainer() {
        return this.annotatedSpectra;
    }

    public String parse(int numThreads, boolean dropErrors) {
        if (numThreads <= 1) {
            return this.parse();
        }
        List<Spectrum> results = Collections.synchronizedList(new ArrayList());
        List<String> errors = Collections.synchronizedList(new ArrayList());
        ThreadPoolExecutorWithExceptions executor = ThreadPoolExecutorWithExceptions.newFixedThreadPool(numThreads);
        executor.setTaskName("Parse");
        try {
            block12: {
                int i;
                ArrayList taskFiles = new ArrayList();
                for (i = 0; i < numThreads; ++i) {
                    taskFiles.add(new ArrayList());
                }
                for (i = 0; i < this.resultFiles.length; ++i) {
                    ((List)taskFiles.get(i % numThreads)).add(this.resultFiles[i]);
                }
                for (i = 0; i < numThreads; ++i) {
                    List thisTaskFiles = (List)taskFiles.get(i);
                    System.out.println("Task " + (i + 1) + ": " + thisTaskFiles.size() + " files.");
                    ConcurrentAnnotatedSpectraParser parser = new ConcurrentAnnotatedSpectraParser(thisTaskFiles.toArray(new File[0]), this.specDir, this.aaSet, this.fdrThreshold, dropErrors, results, errors);
                    executor.execute(parser);
                }
                taskFiles.clear();
                executor.outputProgressReport();
                executor.shutdown();
                try {
                    executor.awaitTerminationWithExceptions(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    if (executor.HasThrownData()) break block12;
                    e.printStackTrace();
                }
            }
            executor.outputProgressReport();
        }
        catch (OutOfMemoryError ex) {
            ex.printStackTrace();
            executor.shutdownNow();
            return "Task terminated; results incomplete. Please run again with a greater amount of memory, using \"-Xmx4G\", for example.";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            executor.shutdownNow();
            return "Task terminated; results incomplete. Please run again.";
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            executor.shutdownNow();
            return "Task terminated; results incomplete. Please run again.";
        }
        this.annotatedSpectra = new SpectraContainer();
        this.annotatedSpectra.addAll(results);
        String errorList = null;
        for (String error : errors) {
            if (errorList == null) {
                errorList = error;
                continue;
            }
            errorList = errorList + "\n" + error;
        }
        return errorList;
    }

    public String parse() {
        if (this.progress == null) {
            this.progress = new ProgressData();
        }
        this.annotatedSpectra = new SpectraContainer();
        System.out.println("Using " + this.resultFiles.length + " result files:");
        for (File resultFile : this.resultFiles) {
            System.out.println("\t" + resultFile.getName());
        }
        int count = 0;
        int total = this.resultFiles.length;
        String aggErrs = null;
        for (File resultFile : this.resultFiles) {
            String errMsg = this.parseFile(resultFile);
            this.progress.report(++count, total);
            if (errMsg == null) continue;
            String msg = "Error while parsing " + resultFile.getName() + ": " + errMsg;
            if (this.dropErrorDatasets) {
                System.out.println(msg);
                if (aggErrs == null) {
                    aggErrs = msg;
                    continue;
                }
                aggErrs = aggErrs + "\n" + msg;
                continue;
            }
            this.exception = new Exception(msg);
            return msg;
        }
        return null;
    }

    public void writeToMgf(PrintStream out) {
        if (this.annotatedSpectra != null) {
            for (Spectrum spec : this.annotatedSpectra) {
                spec.outputMgf(out);
            }
        }
    }

    public String parseFile(File resultFile) {
        System.out.println("Parsing " + resultFile.getName());
        File tsvResultFile = null;
        if (resultFile.getName().endsWith(".mzid")) {
            String resultFileName = resultFile.getAbsolutePath();
            String tsvResultFileName = resultFileName.substring(0, resultFileName.lastIndexOf(46)) + ".tsv";
            tsvResultFile = new File(tsvResultFileName);
            if (!tsvResultFile.exists()) {
                MzIDParser parser;
                if (!tsvResultFile.canWrite()) {
                    parser = new MzIDParser(resultFile);
                    parser.writeToTSVFile(tsvResultFile);
                } else {
                    try {
                        System.out.println("Converting " + resultFile.getName());
                        tsvResultFile = File.createTempFile("__AnnotatedSpectra", ".tsv");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    tsvResultFile.deleteOnExit();
                    parser = new MzIDParser(resultFile);
                    parser.writeToTSVFile(tsvResultFile);
                }
            } else {
                System.out.println(tsvResultFileName + " already exists.");
            }
        } else if (resultFile.getName().endsWith(".tsv")) {
            tsvResultFile = resultFile;
        }
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(tsvResultFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String s = in.readLine();
        if (!s.startsWith("#")) {
            return "Not a valid tsv result file";
        }
        int specIdCol = -1;
        int specFileCol = -1;
        int pepCol = -1;
        int fdrCol = -1;
        int chargeCol = -1;
        String[] label = s.split("\t");
        for (int i = 0; i < label.length; ++i) {
            if (label[i].equalsIgnoreCase("#SpecFile")) {
                specFileCol = i;
                continue;
            }
            if (label[i].equalsIgnoreCase("SpecID")) {
                specIdCol = i;
                continue;
            }
            if (label[i].equalsIgnoreCase("Peptide")) {
                pepCol = i;
                continue;
            }
            if (label[i].equalsIgnoreCase("FDR") || label[i].equalsIgnoreCase("EFDR") || label[i].equalsIgnoreCase("QValue") || label[i].equalsIgnoreCase("SpecQValue")) {
                fdrCol = i;
                continue;
            }
            if (!label[i].equalsIgnoreCase("Charge")) continue;
            chargeCol = i;
        }
        if (specIdCol < 0 || specFileCol < 0 || pepCol < 0) {
            return "Not a valid mzid file";
        }
        if (fdrCol < 0) {
            return "QValue is missing";
        }
        ArrayList<String> resultList = new ArrayList<String>();
        while ((s = in.readLine()) != null) {
            float fdr;
            String[] token = s.split("\t");
            if (token.length <= specIdCol || token.length <= specFileCol || token.length <= pepCol || token.length <= fdrCol || !((fdr = Float.parseFloat(token[fdrCol])) <= this.fdrThreshold)) continue;
            resultList.add(s);
        }
        Iterator itr = resultList.iterator();
        ArrayList<Spectrum> annotatedResults = new ArrayList<Spectrum>();
        HashMap<String, SpectraAccessor> specAccessorMap = new HashMap<String, SpectraAccessor>();
        while (itr.hasNext()) {
            String specId;
            Spectrum spec;
            String str = (String)itr.next();
            String[] token = str.split("\t");
            String pep = token[pepCol];
            if (pep.matches(".\\..+\\..")) {
                pep = pep.substring(pep.indexOf(46) + 1, pep.lastIndexOf(46));
            }
            String specFileName = token[specFileCol];
            specFileName = new File(specFileName).getName();
            int charge = Integer.parseInt(token[chargeCol]);
            SpectraAccessor specAccessor = (SpectraAccessor)specAccessorMap.get(specFileName);
            if (specAccessor == null) {
                File specFile = new File(this.specDir.getPath() + File.separator + specFileName);
                specAccessor = new SpectraAccessor(specFile);
                specAccessorMap.put(specFileName, specAccessor);
            }
            if ((spec = specAccessor.getSpectrumById(specId = token[specIdCol])) == null) {
                return specFileName + ":" + specId + " is not available!";
            }
            Peptide peptide = new Peptide(pep, this.aaSet);
            spec.setCharge(charge);
            if (Math.abs(spec.getPeptideMass() - peptide.getMass()) < 5.0f) {
                spec.setAnnotation(peptide);
                annotatedResults.add(spec);
                continue;
            }
            return "parent mass doesn't match " + specFileName + ":" + specId + " " + peptide.toString() + " " + spec.getPeptideMass() + " != " + peptide.getMass();
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.annotatedSpectra.addAll(annotatedResults);
        return null;
    }

    public static class ConcurrentAnnotatedSpectraParser
    extends AnnotatedSpectra
    implements Runnable {
        private List<Spectrum> results;
        private List<String> errors;

        public ConcurrentAnnotatedSpectraParser(File[] resultFiles, File specDir, AminoAcidSet aaSet, float fdrThreshold, boolean dropErrors, List<Spectrum> resultList, List<String> errorList) {
            super(resultFiles, specDir, aaSet, fdrThreshold, dropErrors);
            this.results = resultList;
            this.errors = errorList;
        }

        @Override
        public void run() {
            String result = this.parse();
            this.results.addAll(this.getAnnotatedSpecContainer());
            if (result != null) {
                this.errors.add(result);
            }
        }
    }
}

