/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peptide;

public class Annotation {
    private AminoAcid prevAA;
    private Peptide peptide;
    private AminoAcid nextAA;

    public Annotation(AminoAcid prevAA, Peptide peptide, AminoAcid nextAA) {
        this.prevAA = prevAA;
        this.peptide = peptide;
        this.nextAA = nextAA;
    }

    public Annotation(String annotationStr, AminoAcidSet aaSet) {
        String pepStr = annotationStr.substring(annotationStr.indexOf(46) + 1, annotationStr.lastIndexOf(46));
        char prevAAResidue = annotationStr.charAt(0);
        char nextAAResidue = annotationStr.charAt(annotationStr.length() - 1);
        this.prevAA = aaSet.getAminoAcid(prevAAResidue);
        this.peptide = aaSet.getPeptide(pepStr);
        this.nextAA = aaSet.getAminoAcid(nextAAResidue);
    }

    public boolean isProteinNTerm() {
        return this.prevAA == null;
    }

    public boolean isProteinCTerm() {
        return this.nextAA == null;
    }

    public AminoAcid getPrevAA() {
        return this.prevAA;
    }

    public void setPrevAA(AminoAcid prevAA) {
        this.prevAA = prevAA;
    }

    public Peptide getPeptide() {
        return this.peptide;
    }

    public void setPeptide(Peptide peptide) {
        this.peptide = peptide;
    }

    public AminoAcid getNextAA() {
        return this.nextAA;
    }

    public void setNextAA(AminoAcid nextAA) {
        this.nextAA = nextAA;
    }

    public String toString() {
        if (this.peptide == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        if (this.prevAA != null) {
            output.append(this.prevAA.getResidueStr());
        }
        output.append("." + this.peptide.toString() + ".");
        if (this.nextAA != null) {
            output.append(this.nextAA.getResidueStr());
        }
        return output.toString();
    }
}

