/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Matter;
import java.util.Comparator;
import java.util.HashMap;

public class Composition
extends Matter {
    public static final double C = 12.0;
    public static final double C13 = 13.00335483;
    public static final double C14 = 14.003241;
    public static final double H = 1.007825035;
    public static final double DEUTERIUM = 2.014101779;
    public static final double N = 14.003074;
    public static final double N15 = 15.000108898;
    public static final double O = 15.99491463;
    public static final double S = 31.9720707;
    public static final double P = 30.973762;
    public static final double Br = 78.9183361;
    public static final double Cl = 34.96885272;
    public static final double Fe = 55.9349393;
    public static final double Se = 79.9165196;
    public static final double H2 = 2.01565007;
    public static final double NH = 15.010899035;
    public static final double NH2 = 16.01872407;
    public static final double H2O = 18.0105647;
    public static final double NH3 = 17.026549105;
    public static final double CO = 27.99491463;
    public static final double ISOTOPE = 1.0033548299999993;
    public static final double ISOTOPE2 = 2.003240999999999;
    public static final double PROTON = 1.00727649;
    public static final double NEUTRON = 1.008665;
    public static final double SODIUM_CHARGE_CARRIER_MASS = 22.98922189;
    public static final double POTASSIUM_CHARGE_CARRIER_MASS = 38.96315989;
    public static final Composition NIL = new Composition(0, 0, 0, 0, 0);
    private static double chargeCarrierMass;
    public static double offsetY;
    public static double offsetB;
    int number;

    public static final double OffsetY() {
        return offsetY;
    }

    public static final double OffsetB() {
        return offsetB;
    }

    public static final double ChargeCarrierMass() {
        return chargeCarrierMass;
    }

    public static final void setChargeCarrierMass(double mass) {
        chargeCarrierMass = mass;
        offsetY = 18.0105647 + chargeCarrierMass;
        offsetB = chargeCarrierMass;
    }

    public Composition(int C, int H, int N, int O, int S) {
        this.number = C * 0x1000000 + H * 65536 + N * 1024 + O * 16 + S;
    }

    public Composition(int number) {
        this.number = number;
    }

    public Composition(Composition c) {
        this.number = c.number;
    }

    public Composition(String compositionStr) {
        String cleanCompositionStr = Composition.removeWhitespace(compositionStr);
        HashMap<Character, Integer> compTable = new HashMap<Character, Integer>();
        compTable.put(Character.valueOf('C'), 0);
        compTable.put(Character.valueOf('H'), 0);
        compTable.put(Character.valueOf('N'), 0);
        compTable.put(Character.valueOf('O'), 0);
        compTable.put(Character.valueOf('S'), 0);
        int number = 0;
        boolean numberSpecified = false;
        char element = '*';
        for (int i = 0; i < cleanCompositionStr.length(); ++i) {
            char c = cleanCompositionStr.charAt(i);
            if (Character.isLetter(c)) {
                if (!numberSpecified && element != '*') {
                    number = 1;
                }
                if (number > 0) {
                    compTable.put(Character.valueOf(element), number);
                }
                element = c;
                number = 0;
                numberSpecified = false;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            number = 10 * number + Integer.parseInt(String.valueOf(c));
            numberSpecified = true;
        }
        if (!numberSpecified) {
            number = 1;
        }
        if (number > 0) {
            compTable.put(Character.valueOf(element), number);
        }
        this.number = new Composition((int)((Integer)compTable.get((Object)Character.valueOf((char)'C'))).intValue(), (int)((Integer)compTable.get((Object)Character.valueOf((char)'H'))).intValue(), (int)((Integer)compTable.get((Object)Character.valueOf((char)'N'))).intValue(), (int)((Integer)compTable.get((Object)Character.valueOf((char)'O'))).intValue(), (int)((Integer)compTable.get((Object)Character.valueOf((char)'S'))).intValue()).number;
    }

    public int getC() {
        return (this.number & 0xFF000000) >>> 24;
    }

    public int getH() {
        return (this.number & 0xFF0000) >> 16;
    }

    public int getN() {
        return (this.number & 0xFC00) >> 10;
    }

    public int getO() {
        return (this.number & 0x3F0) >> 4;
    }

    public int getS() {
        return this.number & 0xF;
    }

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.number;
    }

    public static float getMonoMass(int number) {
        return (float)((double)((number & 0xFF000000) >>> 24) * 12.0 + (double)((number & 0xFF0000) >> 16) * 1.007825035 + (double)((number & 0xFC00) >> 10) * 14.003074 + (double)((number & 0x3F0) >> 4) * 15.99491463 + (double)(number & 0xF) * 31.9720707);
    }

    @Override
    public float getMass() {
        return (float)this.getAccurateMass();
    }

    @Override
    public double getAccurateMass() {
        return (double)this.getC() * 12.0 + (double)this.getH() * 1.007825035 + (double)this.getN() * 14.003074 + (double)this.getO() * 15.99491463 + (double)this.getS() * 31.9720707;
    }

    @Override
    public int getNominalMass() {
        return this.getC() * 12 + this.getH() * 1 + this.getN() * 14 + this.getO() * 16 + this.getS() * 32;
    }

    @Override
    public String toString() {
        return new String(this.getC() + " " + this.getH() + " " + this.getN() + " " + this.getO() + " " + this.getS());
    }

    public void add(Composition c) {
        this.number += c.number;
    }

    public Composition getAddition(Composition c) {
        return new Composition(this.number + c.number);
    }

    public Composition getSubtraction(Composition c) {
        int newC = this.getC() - c.getC();
        int newH = this.getH() - c.getH();
        int newN = this.getN() - c.getN();
        int newO = this.getO() - c.getO();
        int newS = this.getS() - c.getS();
        if (newC < 0 || newH < 0 || newN < 0 || newO < 0 || newS < 0) {
            return null;
        }
        return new Composition(newC, newH, newN, newO, newS);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Composition) {
            Composition c = (Composition)o;
            if (this.number == c.number) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(Composition a, Composition b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.number == b.number;
    }

    public static Double getMass(String compositionStr) {
        String cleanCompositionStr = Composition.removeWhitespace(compositionStr);
        if (!cleanCompositionStr.matches("(([A-Z][a-z]?([+-]\\d+|\\d*)))+")) {
            return null;
        }
        HashMap<String, Integer> compTable = new HashMap<String, Integer>();
        compTable.put("C", 0);
        compTable.put("H", 0);
        compTable.put("N", 0);
        compTable.put("O", 0);
        compTable.put("S", 0);
        compTable.put("P", 0);
        compTable.put("Br", 0);
        compTable.put("Cl", 0);
        compTable.put("Fe", 0);
        compTable.put("Se", 0);
        int i = 0;
        while (i < cleanCompositionStr.length()) {
            char c;
            int j = i;
            j = i + 1 < cleanCompositionStr.length() && Character.isLowerCase(cleanCompositionStr.charAt(i + 1)) ? (j += 2) : ++j;
            String atom = cleanCompositionStr.substring(i, j);
            i = j;
            Integer number = (Integer)compTable.get(atom);
            if (number == null || !number.equals(0)) {
                return null;
            }
            while (j < cleanCompositionStr.length() && ((c = cleanCompositionStr.charAt(j)) == '+' || c == '-' || Character.isDigit(c))) {
                ++j;
            }
            int n = j == i ? 1 : Integer.parseInt(cleanCompositionStr.substring(i, j));
            compTable.put(atom, n);
            i = j;
        }
        double modMass = (double)((Integer)compTable.get("C")).intValue() * 12.0 + (double)((Integer)compTable.get("H")).intValue() * 1.007825035 + (double)((Integer)compTable.get("N")).intValue() * 14.003074 + (double)((Integer)compTable.get("O")).intValue() * 15.99491463 + (double)((Integer)compTable.get("S")).intValue() * 31.9720707 + (double)((Integer)compTable.get("P")).intValue() * 30.973762 + (double)((Integer)compTable.get("Br")).intValue() * 78.9183361 + (double)((Integer)compTable.get("Cl")).intValue() * 34.96885272 + (double)((Integer)compTable.get("Fe")).intValue() * 55.9349393 + (double)((Integer)compTable.get("Se")).intValue() * 79.9165196;
        return modMass;
    }

    public static int compareCompositions(int comp1, int comp2) {
        double mass2;
        double mass1 = Composition.getMonoMass(comp1);
        if (mass1 < (mass2 = (double)Composition.getMonoMass(comp2))) {
            return -1;
        }
        if (mass2 < mass1) {
            return 1;
        }
        if (comp1 < comp2) {
            return -1;
        }
        if (comp2 < comp1) {
            return 1;
        }
        return 0;
    }

    private static void checkEquality() {
        int i;
        int i2;
        AminoAcid[] stdAa = AminoAcid.getStandardAminoAcids();
        Composition[] stdComp = new Composition[stdAa.length];
        for (i2 = 0; i2 < stdAa.length; ++i2) {
            stdComp[i2] = stdAa[i2].getComposition();
        }
        System.out.println("Composition equalities: ");
        for (i2 = 0; i2 < stdAa.length; ++i2) {
            for (int j = i2; j < stdAa.length; ++j) {
                Composition sum = stdComp[i2].getAddition(stdComp[j]);
                for (int k = 0; k < stdAa.length; ++k) {
                    if (!sum.equals(stdComp[k])) continue;
                    System.out.println(stdAa[i2].toString() + " plus " + stdAa[j].toString() + " equals " + stdAa[k].toString());
                }
            }
        }
        int[] singleMasses = new int[stdAa.length];
        for (i = 0; i < stdAa.length; ++i) {
            singleMasses[i] = stdAa[i].getNominalMass();
        }
        System.out.println("Integer equalities: ");
        for (i = 0; i < stdAa.length; ++i) {
            for (int j = i; j < stdAa.length; ++j) {
                int sum = stdComp[i].getNominalMass() + stdComp[j].getNominalMass();
                for (int k = 0; k < stdAa.length; ++k) {
                    if (sum != stdComp[k].getNominalMass()) continue;
                    System.out.println(stdAa[i].toString() + " plus " + stdAa[j].toString() + " equals " + stdAa[k].toString());
                }
            }
        }
    }

    public static String removeWhitespace(String text) {
        return text.replaceAll("[ \\t]", "").trim();
    }

    public static void main(String[] argv) {
        Composition.checkEquality();
    }

    static {
        Composition.setChargeCarrierMass(1.00727649);
    }

    public static class CompositionComparator
    implements Comparator<Integer> {
        @Override
        public int compare(Integer c1, Integer c2) {
            double mass2;
            double mass1 = Composition.getMonoMass(c1);
            if (mass1 > (mass2 = (double)Composition.getMonoMass(c2))) {
                return 1;
            }
            if (mass1 < mass2) {
                return -1;
            }
            return c1 - c2;
        }

        public boolean equals(Integer c1, Integer c2) {
            return c1 == c2;
        }
    }
}

