/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Composition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class CompositionAASet {
    private Composition[] compositionArr;
    private HashMap<Composition, Integer> compositionNumTable = new HashMap();
    private HashMap<Composition, Float> compositionProbTable = new HashMap();
    private HashMap<Composition, ArrayList<AminoAcid>> compositionAATable = new HashMap();

    public CompositionAASet(ArrayList<AminoAcid> aaList) {
        for (AminoAcid aa : aaList) {
            float aaProb = aa.getProbability();
            Composition comp = aa.getComposition();
            Integer cNum = this.compositionNumTable.get(comp);
            if (cNum == null) {
                this.compositionNumTable.put(comp, 1);
                this.compositionProbTable.put(comp, Float.valueOf(aaProb));
                ArrayList<AminoAcid> newAAList = new ArrayList<AminoAcid>();
                newAAList.add(aa);
                this.compositionAATable.put(comp, newAAList);
                continue;
            }
            this.compositionNumTable.put(comp, cNum + 1);
            this.compositionProbTable.put(comp, Float.valueOf(this.compositionProbTable.get(aa.getComposition()).floatValue() + aaProb));
            ArrayList<AminoAcid> existingAAList = this.compositionAATable.get(comp);
            existingAAList.add(aa);
        }
        this.compositionArr = this.compositionNumTable.keySet().toArray(new Composition[0]);
        Arrays.sort(this.compositionArr);
    }

    public Composition[] getDistinctCompositions() {
        return this.compositionArr;
    }

    public int getNumAAWithComposition(Composition comp) {
        Integer num = this.compositionNumTable.get(comp);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public float getSumProbWithComposition(Composition comp) {
        Float prob = this.compositionProbTable.get(comp);
        if (prob == null) {
            return 0.0f;
        }
        return prob.floatValue();
    }

    public ArrayList<AminoAcid> getIndexListWithComposition(Composition comp) {
        return this.compositionAATable.get(comp);
    }
}

