/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.MassFactory;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Enzyme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CompositionFactory
extends MassFactory<Composition> {
    private static final int arraySize = 0x8000000;
    private static final int indexMask = -32;
    private static final int offsetMask = 31;
    private int[] map = new int[0x8000000];
    private ArrayList<Composition> tempData = new ArrayList();
    private int[] data;

    public CompositionFactory(AminoAcidSet aaSet, Enzyme enzyme, int maxLength) {
        super(aaSet, enzyme, maxLength);
        this.makeAllPossibleMasses();
    }

    private CompositionFactory(AminoAcidSet aaSet, int maxLength) {
        super(aaSet, null, maxLength);
    }

    @Override
    public Composition getZero() {
        return Composition.NIL;
    }

    @Override
    public Composition getNextNode(Composition curNode, AminoAcid aa) {
        int num = curNode.number + aa.getComposition().number;
        return new Composition(num);
    }

    @Override
    public Composition getComplementNode(Composition srm, Composition pmNode) {
        return pmNode.getSubtraction(srm);
    }

    @Override
    public ArrayList<DeNovoGraph.Edge<Composition>> getEdges(Composition curNode) {
        int curNum = curNode.number;
        ArrayList<DeNovoGraph.Edge<Composition>> edges = new ArrayList<DeNovoGraph.Edge<Composition>>();
        for (AminoAcid aa : this.aaSet) {
            int prevNum = curNum - aa.getComposition().number;
            DeNovoGraph.Edge<Composition> edge = new DeNovoGraph.Edge<Composition>(new Composition(prevNum), aa.getProbability(), this.aaSet.getIndex(aa), aa.getMass());
            if (prevNum == 0 && this.enzyme != null) {
                if (this.enzyme.isCleavable(aa)) {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavageCredit());
                } else {
                    edge.setCleavageScore(this.aaSet.getPeptideCleavagePenalty());
                }
            }
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public int size() {
        if (this.data == null) {
            if (this.tempData == null) {
                return -1;
            }
            return this.tempData.size();
        }
        return this.data.length;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public ArrayList<Composition> getNodes(float mass, Tolerance tolerance) {
        double m;
        int cur;
        ArrayList<Composition> compositions = new ArrayList<Composition>();
        float toleranceDa = tolerance.getToleranceAsDa(mass);
        float minMass = mass - toleranceDa;
        float maxMass = mass + toleranceDa;
        int minIndex = 0;
        int maxIndex = this.data.length;
        int i = -1;
        do {
            double m2;
            if ((m2 = (double)Composition.getMonoMass(this.data[i = (minIndex + maxIndex) / 2])) < (double)minMass) {
                minIndex = i;
                continue;
            }
            if (!(m2 > (double)maxMass)) break;
            maxIndex = i;
        } while (maxIndex - minIndex > 1);
        for (cur = i; cur >= 0; --cur) {
            m = Composition.getMonoMass(this.data[cur]);
            if (m >= (double)minMass && m <= (double)maxMass) {
                compositions.add(new Composition(this.data[cur]));
                continue;
            }
            if (m < (double)minMass) break;
        }
        for (cur = i + 1; cur < this.data.length; ++cur) {
            m = Composition.getMonoMass(this.data[cur]);
            if (m >= (double)minMass && m <= (double)maxMass) {
                compositions.add(new Composition(this.data[cur]));
                continue;
            }
            if (m > (double)maxMass) break;
        }
        Collections.sort(compositions);
        return compositions;
    }

    @Override
    public Composition getNode(float mass) {
        int minIndex = 0;
        int maxIndex = this.data.length;
        int i = -1;
        do {
            double m;
            if ((m = (double)Composition.getMonoMass(this.data[i = (minIndex + maxIndex) / 2])) < (double)mass) {
                minIndex = i;
                continue;
            }
            if (!(m > (double)mass)) break;
            maxIndex = i;
        } while (maxIndex - minIndex > 1);
        if (minIndex == maxIndex) {
            return new Composition(this.data[minIndex]);
        }
        Composition compMin = new Composition(this.data[minIndex]);
        Composition compMax = new Composition(this.data[maxIndex]);
        float min = compMin.getMass();
        float max = compMax.getMass();
        if (Math.abs(mass - min) < Math.abs(mass - max)) {
            return compMin;
        }
        return compMax;
    }

    @Override
    public ArrayList<Composition> getLinkedNodeList(Collection<Composition> destCompositionList) {
        return this.getIntermediateCompositions(new Composition(0), destCompositionList);
    }

    public ArrayList<Composition> getIntermediateCompositions(Composition source, Collection<Composition> destCompositionList) {
        CompositionFactory intermediateCompositions = new CompositionFactory(this.aaSet, this.maxLength);
        for (Composition c : destCompositionList) {
            intermediateCompositions.setAndAddIfNotExist(c.number);
        }
        int start = 0;
        while (true) {
            int end = intermediateCompositions.size();
            for (int i = start; i < end; ++i) {
                int number = intermediateCompositions.tempData.get(i).getNumber();
                for (AminoAcid aa : this.aaSet) {
                    Composition aaComp = aa.getComposition();
                    int prevNumber = number - aaComp.getNumber();
                    if (!this.isSet(prevNumber) || intermediateCompositions.isSet(prevNumber)) continue;
                    intermediateCompositions.setAndAddIfNotExist(prevNumber);
                }
            }
            if (end == intermediateCompositions.size()) break;
            start = end;
        }
        Collections.sort(intermediateCompositions.tempData);
        return intermediateCompositions.tempData;
    }

    @Override
    public boolean contains(Composition node) {
        return this.isSet(node.number);
    }

    private boolean isSet(int number) {
        int index = (number & 0xFFFFFFE0) >>> 5;
        int offset = number & 0x1F;
        return (this.map[index] & 1 << offset) != 0;
    }

    protected void set(int number) {
        int index = (number & 0xFFFFFFE0) >>> 5;
        int offset = number & 0x1F;
        int n = index;
        this.map[n] = this.map[n] | 1 << offset;
    }

    protected void clear(int number) {
        int index = (number & 0xFFFFFFE0) >>> 5;
        int offset = number & 0x1F;
        int n = index;
        this.map[n] = this.map[n] & ~(1 << offset);
    }

    protected void add(int number) {
        this.tempData.add(new Composition(number));
    }

    private void setAndAddIfNotExist(int number) {
        int index = (number & 0xFFFFFFE0) >>> 5;
        int offset = number & 0x1F;
        if ((this.map[index] & 1 << offset) == 0) {
            int n = index;
            this.map[n] = this.map[n] | 1 << offset;
            this.tempData.add(new Composition(number));
        }
    }

    private CompositionFactory finalizeCompositionSet() {
        if (this.tempData != null) {
            Collections.sort(this.tempData);
        }
        this.data = new int[this.tempData.size()];
        for (int i = 0; i < this.tempData.size(); ++i) {
            this.data[i] = this.tempData.get(i).getNumber();
        }
        this.tempData = null;
        return this;
    }

    protected void makeAllPossibleMasses() {
        this.setAndAddIfNotExist(0);
        Composition[] aaComposition = new Composition[this.aaSet.size()];
        int index = 0;
        for (AminoAcid aa : this.aaSet) {
            aaComposition[index++] = aa.getComposition();
        }
        int start = 0;
        for (int l = 0; l < this.maxLength; ++l) {
            int end = this.tempData.size();
            for (int i = start; i < end; ++i) {
                for (int j = 0; j < aaComposition.length; ++j) {
                    this.setAndAddIfNotExist(this.tempData.get(i).getNumber() + aaComposition[j].getNumber());
                }
            }
            start = end;
        }
        this.finalizeCompositionSet();
    }

    public static void main(String[] argv) {
    }
}

