/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;

public class GappedPeptide
extends Sequence<Composition> {
    private static final long serialVersionUID = 1L;
    private ArrayList<Composition> compositions;
    private String sequence;
    private int count;

    public GappedPeptide(String sequence) {
        this.sequence = sequence;
        this.compositions = new ArrayList();
        this.count = 0;
        boolean inBracket = false;
        Composition current = new Composition(0);
        for (int index = 0; index < sequence.length(); ++index) {
            char thisChar = sequence.charAt(index);
            if (thisChar == '[') {
                inBracket = true;
                current = new Composition(0);
                continue;
            }
            if (thisChar == ']') {
                inBracket = false;
                this.compositions.add(current);
                continue;
            }
            ++this.count;
            if (inBracket) {
                current = current.getAddition(AminoAcid.getStandardAminoAcid(thisChar).getComposition());
                continue;
            }
            this.compositions.add(AminoAcid.getStandardAminoAcid(thisChar).getComposition());
        }
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int size() {
        return this.compositions.size();
    }

    @Override
    public Composition get(int index) {
        return this.compositions.get(index);
    }

    public ArrayList<Composition> getCompositions() {
        return this.compositions;
    }

    @Override
    public String toString() {
        return this.sequence;
    }
}

