/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.params.ParamObject;
import java.util.LinkedHashMap;

public class InstrumentType
implements ParamObject {
    private String name;
    boolean isHighResolution;
    private String description;
    public static LinkedHashMap<String, InstrumentType> table = new LinkedHashMap();
    public static final InstrumentType LOW_RESOLUTION_LTQ = new InstrumentType("LowRes", "Low-res LCQ/LTQ", false);
    public static final InstrumentType TOF;
    public static final InstrumentType HIGH_RESOLUTION_LTQ;
    public static final InstrumentType QEXACTIVE;

    private InstrumentType(String name, String description, boolean isHighResolution) {
        this.name = name;
        this.description = description;
        this.isHighResolution = isHighResolution;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAndDescription() {
        if (this.name.equals(this.description)) {
            return this.name;
        }
        return this.name + " (" + this.description + ")";
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParamDescription() {
        return this.description;
    }

    public boolean isHighResolution() {
        return this.isHighResolution;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstrumentType) {
            return this.name.equalsIgnoreCase(((InstrumentType)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static InstrumentType get(String name) {
        return table.get(name);
    }

    public static InstrumentType[] getAllRegisteredInstrumentTypes() {
        return table.values().toArray(new InstrumentType[0]);
    }

    static {
        HIGH_RESOLUTION_LTQ = new InstrumentType("HighRes", "Orbitrap/FTICR/Lumos", true);
        TOF = new InstrumentType("TOF", "TOF", true);
        QEXACTIVE = new InstrumentType("QExactive", "Q-Exactive", true);
        table.put(LOW_RESOLUTION_LTQ.getName(), LOW_RESOLUTION_LTQ);
        table.put(HIGH_RESOLUTION_LTQ.getName(), HIGH_RESOLUTION_LTQ);
        table.put(TOF.getName(), TOF);
        table.put(QEXACTIVE.getName(), QEXACTIVE);
    }
}

