/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Modification;

public class ModifiedAminoAcid
extends AminoAcid {
    private Modification mod;
    private AminoAcid targetAA;
    private boolean isNTermVariableMod = false;
    private boolean isCTermVariableMod = false;
    private boolean hasTerminalVariableMod = false;
    private boolean hasResidueSpecificVariableMod = false;
    private boolean isFixedModification = false;
    private final int numMods;

    public ModifiedAminoAcid(AminoAcid targetAA, Modification.Instance mod, char residue) {
        super(residue, mod.getModification().getName() + " " + targetAA.getName(), targetAA.getAccurateMass() + mod.getModification().getAccurateMass());
        this.mod = mod.getModification();
        this.targetAA = targetAA;
        this.hasTerminalVariableMod = targetAA.hasTerminalVariableMod();
        this.hasResidueSpecificVariableMod = targetAA.hasResidueSpecificVariableMod();
        super.setProbability(targetAA.getProbability());
        if (mod.isFixedModification()) {
            this.isFixedModification = mod.isFixedModification();
        } else {
            if (mod.getResidue() != '*') {
                this.hasResidueSpecificVariableMod = true;
            } else {
                this.hasTerminalVariableMod = true;
            }
            if (mod.getLocation() == Modification.Location.N_Term || mod.getLocation() == Modification.Location.Protein_N_Term) {
                this.isNTermVariableMod = true;
            }
            if (mod.getLocation() == Modification.Location.C_Term || mod.getLocation() == Modification.Location.Protein_C_Term) {
                this.isCTermVariableMod = true;
            }
        }
        this.numMods = this.hasResidueSpecificVariableMod ? (this.hasTerminalVariableMod ? 2 : 1) : (this.hasTerminalVariableMod ? 1 : 0);
    }

    public AminoAcid getTargetAA() {
        return this.targetAA;
    }

    @Override
    public char getUnmodResidue() {
        return this.targetAA.getUnmodResidue();
    }

    public Modification getModification() {
        return this.mod;
    }

    @Override
    public String getResidueStr() {
        if (this.isFixedModification) {
            return String.valueOf(this.getUnmodResidue());
        }
        StringBuffer buf = new StringBuffer();
        float modMass = this.mod.getMass();
        String massStr = modMass >= 0.0f ? "+" + String.format("%.3f", Float.valueOf(modMass)) : String.format("%.3f", Float.valueOf(modMass));
        if (this.isNTermVariableMod) {
            buf.append(massStr + this.targetAA.getResidueStr());
        } else {
            buf.append(this.targetAA.getResidueStr() + massStr);
        }
        return buf.toString();
    }

    @Override
    public boolean isModified() {
        return !this.isFixedModification;
    }

    @Override
    public boolean hasTerminalVariableMod() {
        return this.hasTerminalVariableMod;
    }

    @Override
    public boolean hasResidueSpecificVariableMod() {
        return this.hasResidueSpecificVariableMod;
    }

    public boolean isNTermVariableMod() {
        return this.isNTermVariableMod;
    }

    public boolean isCTermVariableMod() {
        return this.isCTermVariableMod;
    }

    @Override
    public int getNumVariableMods() {
        return this.numMods;
    }
}

