/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import java.util.Comparator;

public class Pair<A, B> {
    private A first;
    private B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public int hashCode() {
        int hashFirst = this.first != null ? this.first.hashCode() : 0;
        int hashSecond = this.second != null ? this.second.hashCode() : 0;
        return (hashFirst + hashSecond) * hashSecond + hashFirst;
    }

    public boolean equals(Object other) {
        if (other instanceof Pair) {
            Pair otherPair = (Pair)other;
            return (this.first == otherPair.first || this.first != null && otherPair.first != null && this.first.equals(otherPair.first)) && (this.second == otherPair.second || this.second != null && otherPair.second != null && this.second.equals(otherPair.second));
        }
        return false;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public A getFirst() {
        return this.first;
    }

    public void setFirst(A first) {
        this.first = first;
    }

    public B getSecond() {
        return this.second;
    }

    public void setSecond(B second) {
        this.second = second;
    }

    public static class PairReverseComparator<A extends Comparable<? super A>, B extends Comparable<? super B>>
    implements Comparator<Pair<A, B>> {
        boolean useSecondForComprison;

        public PairReverseComparator() {
            this(false);
        }

        public PairReverseComparator(boolean useSecondForComprison) {
            this.useSecondForComprison = useSecondForComprison;
        }

        @Override
        public int compare(Pair<A, B> p1, Pair<A, B> p2) {
            if (!this.useSecondForComprison) {
                return ((Comparable)p2.getFirst()).compareTo(p1.getFirst());
            }
            return ((Comparable)p2.getSecond()).compareTo(p1.getSecond());
        }
    }

    public static class PairComparator<A extends Comparable<? super A>, B extends Comparable<? super B>>
    implements Comparator<Pair<A, B>> {
        boolean useSecondForComprison;

        public PairComparator() {
            this(false);
        }

        public PairComparator(boolean useSecondForComprison) {
            this.useSecondForComprison = useSecondForComprison;
        }

        @Override
        public int compare(Pair<A, B> p1, Pair<A, B> p2) {
            if (!this.useSecondForComprison) {
                return ((Comparable)p1.getFirst()).compareTo(p2.getFirst());
            }
            return ((Comparable)p1.getSecond()).compareTo(p2.getSecond());
        }
    }
}

