/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.MassListComparator;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.Mass;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import java.util.ArrayList;
import java.util.HashSet;

public class Sequence<T extends Matter>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public float getMass() {
        return this.getMass(0, this.size());
    }

    public double getAccurateMass() {
        return this.getMass(0, this.size());
    }

    public float getMass(int from, int to) {
        from = Math.max(from, 0);
        to = Math.min(to, this.size());
        float sum = 0.0f;
        for (int i = from; i < to; ++i) {
            sum += ((Matter)this.get(i)).getMass();
        }
        return sum;
    }

    public double getAccurateMass(int from, int to) {
        from = Math.max(from, 0);
        to = Math.min(to, this.size());
        double sum = 0.0;
        for (int i = from; i < to; ++i) {
            sum += ((Matter)this.get(i)).getAccurateMass();
        }
        return sum;
    }

    public Sequence<T> subSequence(int fromIndex, int toIndex) {
        return (Sequence)super.subList(fromIndex, toIndex);
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        for (Matter matter : this) {
            output.append(matter.toString() + " ");
        }
        return output.toString();
    }

    public static <T extends Matter> Sequence<T> getIntersection(Sequence<T> seq1, Sequence<T> seq2) {
        Sequence<T> union = new Sequence<T>();
        HashSet<Matter> set = new HashSet<Matter>();
        for (Matter m : seq1) {
            set.add(m);
        }
        for (Matter m : seq2) {
            if (!set.contains(m)) continue;
            union.add(m);
        }
        return union;
    }

    public boolean isMatchedTo(Peptide peptide, Tolerance tolerance, boolean isPrefix) {
        ArrayList<Mass> pepMassList = new ArrayList<Mass>();
        float mass = 0.0f;
        for (int i = 0; i < peptide.size(); ++i) {
            mass = isPrefix ? (mass += peptide.get(i).getMass()) : (mass += peptide.get(peptide.size() - 1 - i).getMass());
            pepMassList.add(new Mass(mass));
        }
        ArrayList<Mass> massList = new ArrayList<Mass>();
        for (int i = 0; i < this.size(); ++i) {
            massList.add(new Mass(((Matter)this.get(i)).getMass()));
        }
        MassListComparator comparator = new MassListComparator(pepMassList, massList);
        int matchSize = comparator.getMatchedList(tolerance).length;
        return matchSize == this.size();
    }

    public boolean isMatchedToNominalMasses(Peptide peptide, boolean isPrefix) {
        HashSet<Integer> massList = new HashSet<Integer>();
        int mass = 0;
        for (int i = 0; i < peptide.size(); ++i) {
            mass = isPrefix ? (mass += peptide.get(i).getNominalMass()) : (mass += peptide.get(peptide.size() - 1 - i).getNominalMass());
            massList.add(mass);
        }
        for (Matter m : this) {
            if (massList.contains(m.getNominalMass())) continue;
            return false;
        }
        return true;
    }

    public float[] toMassArray() {
        float[] massArr = new float[this.size()];
        int index = 0;
        for (Matter m : this) {
            massArr[index++] = m.getMass();
        }
        return massArr;
    }
}

