/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.msutil.SpectrumMetaInfo;
import edu.ucsd.msjava.parser.BufferedRandomAccessLineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpectraMap
implements SpectrumAccessorBySpecIndex {
    private Map<Integer, SpectrumMetaInfo> specIndexMap = null;
    private SpectrumParser parser;
    protected BufferedRandomAccessLineReader lineReader;
    private ArrayList<Integer> specIndexList = null;
    private Map<String, Integer> idToIndex = null;

    public SpectraMap(String fileName, SpectrumParser parser) {
        this.lineReader = new BufferedRandomAccessLineReader(fileName);
        this.parser = parser;
        this.specIndexMap = parser.getSpecMetaInfoMap(this.lineReader);
    }

    @Override
    public Spectrum getSpectrumById(String specId) {
        Integer specIndex;
        if (this.idToIndex == null) {
            this.makeIdToIndexMap();
        }
        if ((specIndex = this.idToIndex.get(specId)) == null) {
            return null;
        }
        return this.getSpectrumBySpecIndex(specIndex);
    }

    @Override
    public synchronized Spectrum getSpectrumBySpecIndex(int specIndex) {
        Long filePos = this.getFileOffset(specIndex);
        if (filePos == null) {
            return null;
        }
        this.lineReader.seek(filePos);
        Spectrum spec = this.parser.readSpectrum(this.lineReader);
        spec.setSpecIndex(specIndex);
        spec.determineIsCentroided();
        spec.setID("index=" + String.valueOf(specIndex - 1));
        return spec;
    }

    @Override
    public Float getPrecursorMz(int specIndex) {
        SpectrumMetaInfo metaInfo = this.specIndexMap.get(specIndex);
        if (metaInfo == null) {
            return null;
        }
        return Float.valueOf(metaInfo.getPrecursorMz());
    }

    @Override
    public String getID(int specIndex) {
        SpectrumMetaInfo metaInfo = this.specIndexMap.get(specIndex);
        if (metaInfo == null) {
            return null;
        }
        return metaInfo.getID();
    }

    @Override
    public String getTitle(int specIndex) {
        SpectrumMetaInfo metaInfo = this.specIndexMap.get(specIndex);
        if (metaInfo == null) {
            return null;
        }
        return metaInfo.getAdditionalInfo("title");
    }

    public Long getFileOffset(int specIndex) {
        SpectrumMetaInfo metaInfo = this.specIndexMap.get(specIndex);
        if (metaInfo == null) {
            return null;
        }
        return metaInfo.getPosition();
    }

    @Override
    public synchronized ArrayList<Integer> getSpecIndexList() {
        if (this.specIndexList == null) {
            this.specIndexList = new ArrayList<Integer>(this.specIndexMap.keySet());
            Collections.sort(this.specIndexList);
        }
        return this.specIndexList;
    }

    private void makeIdToIndexMap() {
        this.idToIndex = new HashMap<String, Integer>();
        for (Map.Entry<Integer, SpectrumMetaInfo> entry : this.specIndexMap.entrySet()) {
            this.idToIndex.put(entry.getValue().getID(), entry.getKey());
        }
    }
}

