/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Spectrum;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class SpectrumTester {
    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        String mgfFile = "/home/sangtaekim/Research/Data/PNNL/IPYS_TD_Scere010_Orbitrap_001a.mgf";
        SpectrumTester.parseMgf(mgfFile);
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }

    public static ArrayList<Spectrum> parseMgf(String path) {
        BufferedReader fileReader = null;
        ArrayList<Spectrum> results = new ArrayList<Spectrum>();
        try {
            fileReader = new BufferedReader(new FileReader(path));
            boolean parseFlag = false;
            String line = null;
            Spectrum tempSpec = null;
            int specCount = 0;
            while ((line = fileReader.readLine()) != null) {
                String[] tokens;
                if (parseFlag && Character.isDigit(line.charAt(0))) {
                    tokens = line.split("\\s");
                    float intensity = Float.parseFloat(tokens[1]);
                    if (!(intensity > 1.0E-6f)) continue;
                    tempSpec.add(new Peak(Float.parseFloat(tokens[0]), intensity, 1));
                    continue;
                }
                tokens = line.split("=");
                String keyword = tokens[0];
                if (keyword.equals("BEGIN IONS") && !parseFlag) {
                    tempSpec = new Spectrum();
                    parseFlag = true;
                    continue;
                }
                if (!parseFlag) continue;
                if (keyword.equals("END IONS")) {
                    results.add(tempSpec);
                    parseFlag = false;
                    ++specCount;
                    continue;
                }
                if (keyword.equals("PEPMASS")) {
                    float parent = Float.parseFloat(tokens[1]);
                    if (tempSpec.getPrecursorPeak() != null) {
                        tempSpec.getPrecursorPeak().setMz(parent);
                        continue;
                    }
                    tempSpec.setPrecursor(new Peak(parent, 1.0f, 1));
                    continue;
                }
                if (keyword.equals("CHARGE")) {
                    String chargeStr = tokens[1];
                    int lastIndex = chargeStr.length() - 1;
                    char lastChar = chargeStr.charAt(lastIndex);
                    if (lastChar == '-') {
                        chargeStr = lastChar + chargeStr.substring(0, lastIndex);
                    } else if (lastChar == '+') {
                        chargeStr = chargeStr.substring(0, lastIndex);
                    }
                    if (chargeStr.charAt(0) == '+') {
                        chargeStr = chargeStr.substring(1);
                    }
                    int charge = Integer.parseInt(chargeStr);
                    if (tempSpec.getPrecursorPeak() != null) {
                        tempSpec.getPrecursorPeak().setCharge(charge);
                        continue;
                    }
                    tempSpec.setPrecursor(new Peak(0.0f, 1.0f, charge));
                    continue;
                }
                if (!keyword.equals("TITLE")) continue;
                tempSpec.setTitle(tokens[1]);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
        return results;
    }
}

