/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Reshape;
import edu.ucsd.msjava.msutil.Spectrum;
import java.util.Collections;

public class TopNFilter
implements Reshape {
    private int topN;

    public TopNFilter(int topN) {
        this.topN = topN;
    }

    public int getTop() {
        return this.topN;
    }

    @Override
    public Spectrum apply(Spectrum s) {
        Spectrum intSortedSpec = (Spectrum)s.clone();
        Collections.sort(intSortedSpec, Collections.reverseOrder(new Peak.IntensityComparator()));
        Spectrum retSpec = (Spectrum)s.clone();
        retSpec.clear();
        for (int peakIndex = 0; peakIndex < this.topN && peakIndex < intSortedSpec.size(); ++peakIndex) {
            retSpec.add((Peak)intSortedSpec.get(peakIndex));
        }
        return retSpec;
    }
}

