/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.util.HashSet;

public class MzIDTest {
    private final File mzidFile;

    public MzIDTest(File mzidFile) {
        this.mzidFile = mzidFile;
    }

    public boolean isValid() throws Exception {
        String s;
        BufferedLineReader in = new BufferedLineReader(this.mzidFile.getPath());
        boolean isValid = true;
        HashSet<String> idSet = new HashSet<String>();
        String sir = null;
        boolean hasSII = false;
        while ((s = in.readLine()) != null) {
            if ((s = s.trim()).startsWith("<PeptideEvidence isDecoy")) {
                String id = s.substring(s.lastIndexOf("id=") + 4, s.lastIndexOf(34));
                if (idSet.contains(id)) {
                    System.out.println("Duplicate id: " + id);
                    isValid = false;
                } else {
                    idSet.add(id);
                }
            }
            if (s.startsWith("<cvParam") && !s.contains("cvRef=")) {
                System.out.println("No cvRef: " + s);
                isValid = false;
            }
            if (s.startsWith("<SpectrumIdentificationResult")) {
                sir = s;
                hasSII = false;
            }
            if (sir != null && s.startsWith("<SpectrumIdentificationItem")) {
                hasSII = true;
            }
            if (!s.startsWith("</SpectrumIdentificationResult")) continue;
            if (!hasSII) {
                isValid = false;
                System.out.println("SIR doesn't have SII: " + sir);
            }
            sir = null;
        }
        in.close();
        return isValid;
    }

    public static void main(String[] argv) throws Exception {
        File mzidFile = new File("C:\\cygwin\\home\\kims336\\Data\\Debug\\Scaffold\\test.mzid");
        MzIDTest test = new MzIDTest(mzidFile);
        boolean isValid = test.isValid();
        System.out.println("IsValid? " + isValid);
    }
}

