/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.mzid.UnimodComposition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class Unimod {
    private Map<String, String> recordIDMap;
    private Map<String, String> idToDeltaCompositionMap;
    private static Unimod unimod = new Unimod();

    public static Unimod getUnimod() {
        return unimod;
    }

    public String getRecordID(String name) {
        return this.recordIDMap.get(name);
    }

    public String getDeltaComposition(String id) {
        return this.idToDeltaCompositionMap.get(id);
    }

    private Unimod() {
        this.readUnimodOBOFile();
    }

    private void readUnimodOBOFile() {
        InputStream is = Unimod.class.getClassLoader().getResourceAsStream("unimod.obo");
        if (is == null) {
            System.err.println("Unable to access \"unimod.obo\".");
            System.exit(-1);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        this.recordIDMap = new HashMap<String, String>();
        this.idToDeltaCompositionMap = new HashMap<String, String>();
        String curID = null;
        String deltaMass = null;
        try {
            String s;
            while ((s = in.readLine()) != null) {
                if (s.startsWith("id:")) {
                    String id = s.split("\\s+")[1].trim();
                    String nameLine = in.readLine();
                    assert (nameLine.startsWith("name:"));
                    String name = nameLine.split("\\s+")[1].trim();
                    this.recordIDMap.put(name, id);
                    curID = id;
                }
                if (s.startsWith("xref: delta_composition")) {
                    String deltaComposition = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
                    this.idToDeltaCompositionMap.put(curID, deltaComposition);
                    if (deltaMass != null) {
                        Double mass = UnimodComposition.getMass(deltaComposition);
                        Double mass2 = Double.parseDouble(deltaMass);
                        if (Math.abs(mass - mass2) > 0.001) {
                            System.out.println("Error: " + deltaComposition + " " + mass + " " + mass2);
                        }
                    }
                }
                if (!s.startsWith("xref: delta_mono_mass")) continue;
                deltaMass = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

