/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzid;

import edu.ucsd.msjava.msutil.Atom;
import edu.ucsd.msjava.msutil.Composition;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class UnimodComposition {
    private Map<String, Integer> compMap = new LinkedHashMap<String, Integer>();
    private Double deltaMass = null;

    public UnimodComposition() {
        this.compMap.put("H", 0);
        this.compMap.put("C", 0);
        this.compMap.put("N", 0);
        this.compMap.put("O", 0);
        this.compMap.put("P", 0);
        this.compMap.put("S", 0);
    }

    public void add(Composition comp) {
        this.add("C", comp.getC());
        this.add("H", comp.getH());
        this.add("N", comp.getN());
        this.add("O", comp.getO());
        this.add("S", comp.getS());
    }

    public void add(String deltaComposition) {
        String[] token;
        for (String e : token = deltaComposition.split("\\s+")) {
            if (e.matches("\\d*?[a-zA-Z]+(\\(-?\\d+\\))?")) {
                int num;
                String element;
                if (e.matches("\\d*?[a-zA-Z]+")) {
                    element = e;
                    num = 1;
                } else {
                    element = e.substring(0, e.indexOf(40));
                    num = Integer.parseInt(e.substring(e.indexOf(40) + 1, e.lastIndexOf(41)));
                }
                this.add(element, num);
                continue;
            }
            if (e.matches("\\d+\\.?\\d*")) {
                double mass = Double.parseDouble(e);
                this.add(mass);
                continue;
            }
            System.err.println("Wrong Unimod delta_composition: " + deltaComposition);
            System.exit(-1);
        }
    }

    public void add(String element, int number) {
        Integer num = this.compMap.get(element);
        if (num == null) {
            this.compMap.put(element, number);
        } else {
            this.compMap.put(element, num + number);
        }
    }

    public void add(double deltaMass) {
        this.deltaMass = this.deltaMass == null ? Double.valueOf(deltaMass) : Double.valueOf(this.deltaMass + deltaMass);
    }

    public Double getMass() {
        double mass = 0.0;
        for (Map.Entry<String, Integer> entry : this.compMap.entrySet()) {
            String element = entry.getKey();
            int num = entry.getValue();
            if (num == 0) continue;
            Atom atom = Atom.get(element);
            if (atom == null) {
                System.out.println("Error: Could not parse element/molecule \"" + element + "\"");
                return null;
            }
            mass += atom.getMass() * (double)num;
        }
        if (this.deltaMass != null) {
            mass += this.deltaMass.doubleValue();
        }
        return mass;
    }

    public static Double getMass(String unimodCompositionStr) {
        UnimodComposition comp = new UnimodComposition();
        comp.add(unimodCompositionStr);
        return comp.getMass();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<String, Integer>> itr = this.compMap.entrySet().iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Map.Entry<String, Integer> entry = itr.next();
            String element = entry.getKey();
            int num = entry.getValue();
            if (num == 0) continue;
            if (num == 1) {
                if (!first) {
                    buf.append(" ");
                } else {
                    first = false;
                }
                buf.append(element);
                continue;
            }
            if (!first) {
                buf.append(" ");
            } else {
                first = false;
            }
            buf.append(element + "(" + num + ")");
        }
        if (this.deltaMass != null) {
            buf.append(" " + this.deltaMass);
        }
        return buf.toString();
    }
}

