/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mzml;

import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.mzml.MzMLAdapter;
import edu.ucsd.msjava.mzml.SpectrumConverter;
import java.util.ArrayList;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;

public class MzMLSpectraMap
implements SpectrumAccessorBySpecIndex {
    private final MzMLUnmarshaller unmarshaller;
    private final int minMSLevel;
    private final int maxMSLevel;

    public MzMLSpectraMap(MzMLAdapter mzmlAdapter) {
        this.unmarshaller = mzmlAdapter.getUnmarshaller();
        this.minMSLevel = mzmlAdapter.getMinMSLevel();
        this.maxMSLevel = mzmlAdapter.getMaxMSLevel();
    }

    @Override
    public edu.ucsd.msjava.msutil.Spectrum getSpectrumBySpecIndex(int specIndex) {
        String specId = this.unmarshaller.getSpectrumIDFromSpectrumIndex(specIndex - 1);
        if (specId != null) {
            return this.getSpectrumById(specId);
        }
        return null;
    }

    @Override
    public edu.ucsd.msjava.msutil.Spectrum getSpectrumById(String specId) {
        Spectrum jmzSpec = null;
        try {
            jmzSpec = this.unmarshaller.getSpectrumById(specId);
        }
        catch (MzMLUnmarshallerException e) {
            e.printStackTrace();
        }
        if (jmzSpec != null) {
            edu.ucsd.msjava.msutil.Spectrum spec = SpectrumConverter.getSpectrumFromJMzMLSpec(jmzSpec);
            if (spec.getMSLevel() < this.minMSLevel || spec.getMSLevel() > this.maxMSLevel) {
                return null;
            }
            return spec;
        }
        return null;
    }

    @Override
    public ArrayList<Integer> getSpecIndexList() {
        return new ArrayList<Integer>(this.unmarshaller.getSpectrumIndexes());
    }

    @Override
    public String getID(int specIndex) {
        return this.unmarshaller.getSpectrumIDFromSpectrumIndex(specIndex - 1);
    }

    @Override
    public Float getPrecursorMz(int specIndex) {
        String specID = this.unmarshaller.getSpectrumIDFromSpectrumIndex(specIndex - 1);
        if (specID != null) {
            Spectrum jmzSpec = null;
            try {
                jmzSpec = this.unmarshaller.getSpectrumById(specID);
            }
            catch (MzMLUnmarshallerException e) {
                e.printStackTrace();
            }
            if (jmzSpec != null) {
                float precursorMz = SpectrumConverter.getPrecursorMzFromJMzMLSpec(jmzSpec).floatValue();
                return Float.valueOf(precursorMz);
            }
        }
        return null;
    }

    @Override
    public String getTitle(int specIndex) {
        return null;
    }
}

