/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.RangeParameter;

public class FloatRangeParameter
extends RangeParameter<Float> {
    public FloatRangeParameter(String key, String name, String description) {
        super(key, name, description);
        this.minValue = Float.valueOf(Float.MIN_VALUE);
        this.maxValue = Float.valueOf(Float.MAX_VALUE);
        this.isMinInclusive = true;
        this.isMaxInclusive = false;
    }

    @Override
    public String parse(String value) {
        String[] token = value.split(",");
        try {
            if (token.length != 2) {
                return "illegar syntax";
            }
            this.min = Float.valueOf(Float.parseFloat(token[0]));
            this.max = Float.valueOf(Float.parseFloat(token[1]));
        }
        catch (NumberFormatException e) {
            return "not a valid float or float range";
        }
        if (((Float)this.min).floatValue() >= ((Float)this.max).floatValue() || !this.isValueValid((Float)this.min) || !this.isValueValid((Float)this.max)) {
            return "not a valid range";
        }
        return null;
    }
}

