/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.CaseInsensitiveMap;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.IOException;

public class ParamParser {
    public static Parameters parseFromFile(String fileName) {
        String s;
        Parameters params = new Parameters();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while ((s = in.readLine()) != null) {
            String[] token;
            if (s.startsWith("#") || s.length() == 0 || (token = s.split("=")).length != 2) continue;
            params.put(token[0].trim(), token[1].trim());
        }
        return params;
    }

    public static Parameters parseFromString(String paramString) {
        String errMsg = "Number of parameters must be even. If a file path has a space, surround it with double quotes.";
        Parameters params = new Parameters();
        String[] token = paramString.split("\\s+");
        if (token.length % 2 != 0) {
            System.err.println(errMsg);
            System.exit(-1);
        }
        for (int i = 0; i < token.length; i += 2) {
            if (!token[i].startsWith("-") || i + 1 >= token.length) {
                System.err.println(errMsg);
            }
            params.put(token[i].trim(), token[i + 1].trim());
        }
        return params;
    }

    public static class Parameters
    extends CaseInsensitiveMap {
        private static final long serialVersionUID = 1L;

        public String getParameter(String name) {
            return this.get(name);
        }

        public Integer getIntParameter(String name) {
            String param = this.get(name);
            if (param == null) {
                return null;
            }
            return Integer.parseInt(param);
        }

        public Float getFloatParameter(String name) {
            String param = this.get(name);
            if (param == null) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(param));
        }
    }
}

