/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.parser.LineReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FullyBufferedLineReader
implements LineReader {
    private int pointer;
    private byte[] buffer;
    private final byte CR = (byte)13;
    private final byte NL = (byte)10;
    int startIndex;

    public FullyBufferedLineReader(String fileName) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        FileChannel in = fin.getChannel();
        ByteBuffer tempBuffer = null;
        try {
            tempBuffer = ByteBuffer.allocate((int)in.size());
            in.read(tempBuffer);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.buffer = tempBuffer.array();
        this.pointer = 0;
        this.startIndex = 0;
    }

    @Override
    public String readLine() {
        if (this.pointer >= this.buffer.length) {
            return null;
        }
        while (this.pointer < this.buffer.length) {
            if (this.buffer[this.pointer] != 10) {
                ++this.pointer;
                continue;
            }
            String str = this.pointer > 0 && this.buffer[this.pointer - 1] == 13 ? new String(this.buffer, this.startIndex, this.pointer - this.startIndex - 1) : new String(this.buffer, this.startIndex, this.pointer - this.startIndex);
            ++this.pointer;
            this.startIndex = this.pointer;
            return str;
        }
        String str = new String(this.buffer, this.startIndex, this.pointer - this.startIndex);
        this.startIndex = this.pointer;
        return str;
    }

    public int getPosition() {
        return this.pointer;
    }

    public void seek(int position) {
        this.startIndex = this.pointer = position;
    }

    public void reset() {
        this.pointer = 0;
        this.startIndex = 0;
    }

    public int size() {
        return this.buffer.length;
    }
}

