/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PSMList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;

public class MSGFDBParser {
    public static PSMList<PSM> parse(String fileName) {
        String s;
        PSMList<PSM> psmList = new PSMList<PSM>();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while ((s = in.readLine()) != null) {
            String[] token;
            if (s.startsWith("#") || s.length() == 0 || !Character.isDigit(s.charAt(0)) || (token = s.split("\t")).length != 10) continue;
            String specFileName = token[0];
            int scanNum = Integer.parseInt(token[1]);
            float precursorMz = Float.parseFloat(token[3]);
            int charge = Integer.parseInt(token[4]);
            String peptideStr = token[5];
            String protein = token[6];
            int peptideScore = Integer.parseInt(token[8]);
            float specProb = Float.parseFloat(token[9]);
            PSM psm = new PSM();
            psm.specFileName(specFileName).scanNum(scanNum).precursorMz(precursorMz).charge(charge).peptide(new Peptide(peptideStr)).protein(protein).rawScore(peptideScore).probScore(specProb);
            psmList.add(psm);
        }
        return psmList;
    }

    public static PSMList<PSM> getMergedResults(String dirName, String suffix) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            return null;
        }
        PSMList<PSM> psmList = new PSMList<PSM>();
        class SuffixFileFilter
        implements FileFilter {
            final /* synthetic */ String val$suffix;

            SuffixFileFilter(String string) {
                this.val$suffix = string;
            }

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(this.val$suffix);
            }
        }
        for (File f : dir.listFiles(new SuffixFileFilter(suffix))) {
            psmList.addAll(MSGFDBParser.parse(f.getPath()));
        }
        Collections.sort(psmList, new PSM.PSMSpecNumComparator());
        return psmList;
    }
}

