/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MSGappedDictionaryPSM;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PSMList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;

public class MSGappedDictionaryParser {
    public static PSMList<MSGappedDictionaryPSM> parse(String fileName) {
        return MSGappedDictionaryParser.parse(fileName, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys());
    }

    public static PSMList<MSGappedDictionaryPSM> parse(String fileName, AminoAcidSet aaSet) {
        String s;
        PSMList<MSGappedDictionaryPSM> psmList = new PSMList<MSGappedDictionaryPSM>();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while ((s = in.readLine()) != null) {
            String[] token;
            if (s.startsWith("#") || s.length() == 0 || (token = s.split("\t")).length < 13) continue;
            String specFileName = token[0];
            int scanNum = Integer.parseInt(token[1]);
            float precursorMz = Float.parseFloat(token[3]);
            int charge = Integer.parseInt(token[4]);
            String peptideStr = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46));
            String protein = token[6];
            int peptideScore = Integer.parseInt(token[7]);
            float specProb = Float.parseFloat(token[8]);
            float massDiff = Float.parseFloat(token[12]);
            MSGappedDictionaryPSM psm = new MSGappedDictionaryPSM();
            psm.aaSet(aaSet).peptide(peptideStr).specFileName(specFileName).scanNum(scanNum).precursorMz(precursorMz).charge(charge).protein(protein).rawScore(peptideScore).probScore(specProb);
            psmList.add(psm);
            psm.setParentMassError(massDiff);
        }
        return psmList;
    }

    public static PSMList<MSGappedDictionaryPSM> getMergedResults(String dirName, String suffix) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            return null;
        }
        PSMList<MSGappedDictionaryPSM> psmList = new PSMList<MSGappedDictionaryPSM>();
        class SuffixFileFilter
        implements FileFilter {
            final /* synthetic */ String val$suffix;

            SuffixFileFilter(String string) {
                this.val$suffix = string;
            }

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(this.val$suffix);
            }
        }
        for (File f : dir.listFiles(new SuffixFileFilter(suffix))) {
            psmList.addAll(MSGappedDictionaryParser.parse(f.getPath()));
        }
        Collections.sort(psmList, new PSM.PSMSpecNumComparator());
        return psmList;
    }
}

