/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PSMList;
import java.io.IOException;
import java.util.ArrayList;

public class OMSSAParser {
    public static PSMList<PSM> parse(String fileName) {
        String s;
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PSMList<PSM> matches = new PSMList<PSM>();
        in.readLine();
        while ((s = in.readLine()) != null) {
            String[] token = OMSSAParser.splitCSVLine(s);
            if (token.length != 15) continue;
            int specNum = Integer.parseInt(token[0]);
            String title = token[1];
            Peptide peptide = new Peptide(token[2]);
            float eValue = Float.parseFloat(token[3]);
            String protein = token[9];
            String mod = token[10];
            int charge = Integer.parseInt(token[11]);
            matches.add(new PSM().scanNum(specNum).title(title).peptide(peptide).probScore(eValue).protein(protein).ptm(mod).charge(charge));
        }
        return matches;
    }

    private static String[] splitCSVLine(String s) {
        ArrayList<String> token = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        boolean ignoreComma = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!ignoreComma && c == ',') {
                token.add(buf.toString().trim());
                buf = new StringBuffer();
                continue;
            }
            if (c == '\"') {
                ignoreComma = !ignoreComma;
                continue;
            }
            buf.append(c);
        }
        token.add(buf.toString().trim());
        return token.toArray(new String[0]);
    }

    public static void main(String[] argv) {
        OMSSAParser.test();
    }

    public static void test() {
        String[] targetResult = new String[]{System.getProperty("user.home") + "/Research/Data/Heck/omssa_ETD_090309_sm4067_01_sprot.csv", System.getProperty("user.home") + "/Research/Data/Heck/omssa_ETD_090309_sm4067_03_sprot.csv"};
        String[] decoyResult = new String[]{System.getProperty("user.home") + "/Research/Data/Heck/omssa_ETD_090309_sm4067_01_revsprot.csv", System.getProperty("user.home") + "/Research/Data/Heck/omssa_ETD_090309_sm4067_03_revsprot.csv"};
        PSMList<PSM> targetPSM = OMSSAParser.parse(targetResult[1]).getDistinctiveSpectralSet().getDistinctivePeptideSet();
        PSMList<PSM> decoyPSM = OMSSAParser.parse(decoyResult[1]).getDistinctiveSpectralSet().getDistinctivePeptideSet();
        PSMList<PSM> significantPSMList = PSMList.selectUsingFDR(targetPSM, decoyPSM, 0.05f);
        PSMList<PSM> significantPSMPeptideList = significantPSMList.getDistinctivePeptideSet();
        int size = 0;
        for (PSM psm : significantPSMList) {
            System.out.println(psm);
            ++size;
        }
        System.out.println("Size: " + size);
    }
}

