/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Peptide;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeMap;

public class PSM {
    private String specFileName = null;
    private int specIndex = -1;
    private int scanNum = -1;
    private String title = null;
    private float precursorMz = 0.0f;
    private int charge = 0;
    private String protein = null;
    private char precedingResidue = (char)42;
    private char succeedingResidue = (char)42;
    private String ptm = null;
    private Peptide peptide;
    private float probScore;
    private float rawScore;
    private TreeMap<String, Float> optionalScores = null;

    public String getSpecFileName() {
        return this.specFileName;
    }

    public PSM specFileName(String fileName) {
        this.specFileName = fileName;
        return this;
    }

    public int getSpecIndex() {
        return this.specIndex;
    }

    public int getScanNum() {
        return this.scanNum;
    }

    public PSM scanNum(int scanNum) {
        this.scanNum = scanNum;
        return this;
    }

    public PSM specIndex(int specIndex) {
        this.specIndex = specIndex;
        return this;
    }

    public float getPrecursorMz() {
        return this.precursorMz;
    }

    public PSM precursorMz(float precursorMz) {
        this.precursorMz = precursorMz;
        return this;
    }

    public int getCharge() {
        return this.charge;
    }

    public PSM charge(int charge) {
        this.charge = charge;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PSM title(String title) {
        this.title = title;
        return this;
    }

    public Peptide getPeptide() {
        return this.peptide;
    }

    public String getPeptideStr() {
        return this.peptide.toString();
    }

    public PSM peptide(Peptide peptide) {
        this.peptide = peptide;
        return this;
    }

    public String getPTM() {
        return this.ptm;
    }

    public PSM precedingResidue(char precedingResidue) {
        this.precedingResidue = precedingResidue;
        return this;
    }

    public char getPrecedingResidue() {
        return this.precedingResidue;
    }

    public PSM succeedingResidue(char succeedingResidue) {
        this.succeedingResidue = succeedingResidue;
        return this;
    }

    public char getSucceedingResidue() {
        return this.succeedingResidue;
    }

    public PSM ptm(String ptm) {
        this.ptm = ptm;
        return this;
    }

    public String getProtein() {
        return this.protein;
    }

    public PSM protein(String protein) {
        this.protein = protein;
        return this;
    }

    public float getProbScore() {
        return this.probScore;
    }

    public PSM probScore(float probScore) {
        this.probScore = probScore;
        return this;
    }

    public float getRawScore() {
        return this.rawScore;
    }

    public PSM rawScore(float rawScore) {
        this.rawScore = rawScore;
        return this;
    }

    public float getScore(String scoreName) {
        Float score = this.optionalScores.get(scoreName);
        if (score == null) {
            return Float.NaN;
        }
        return score.floatValue();
    }

    public ArrayList<String> getScoreNames() {
        return new ArrayList<String>(this.optionalScores.keySet());
    }

    public PSM score(String name, float score) {
        if (this.optionalScores == null) {
            this.optionalScores = new TreeMap();
        }
        this.optionalScores.put(name, Float.valueOf(score));
        return this;
    }

    public String toString() {
        return this.specIndex + "\t" + this.scanNum + "\t" + this.peptide + "\t" + this.charge + "\t" + this.probScore;
    }

    public String toStringAllFields() {
        return (this.specIndex > 0 ? Integer.valueOf(this.specIndex) : "") + "\t" + (this.scanNum > 0 ? Integer.valueOf(this.scanNum) : "") + "\t" + (this.title != null ? this.title : "") + "\t" + (this.charge > 0 ? Integer.valueOf(this.charge) : "") + "\t" + (this.peptide != null ? this.peptide : "") + "\t" + (this.protein != null ? this.protein : "") + "\t" + (this.ptm != null ? this.ptm : "") + "\t" + this.probScore + "\t" + this.rawScore;
    }

    static class PSMProbScoreComparator
    implements Comparator<PSM> {
        PSMProbScoreComparator() {
        }

        @Override
        public int compare(PSM o1, PSM o2) {
            if (o1.probScore > o2.probScore) {
                return 1;
            }
            if (o1.probScore == o2.probScore) {
                return 0;
            }
            return -1;
        }
    }

    static class PSMScanNumComparator
    implements Comparator<PSM> {
        PSMScanNumComparator() {
        }

        @Override
        public int compare(PSM o1, PSM o2) {
            if (o1.scanNum > o2.scanNum) {
                return 1;
            }
            if (o1.scanNum == o2.scanNum) {
                return 0;
            }
            return -1;
        }
    }

    static class PSMSpecNumComparator
    implements Comparator<PSM> {
        PSMSpecNumComparator() {
        }

        @Override
        public int compare(PSM o1, PSM o2) {
            if (o1.specIndex > o2.specIndex) {
                return 1;
            }
            if (o1.specIndex == o2.specIndex) {
                return 0;
            }
            return -1;
        }
    }

    public static class PSMSpecFileAndScanNumComparator
    implements Comparator<PSM> {
        @Override
        public int compare(PSM o1, PSM o2) {
            int fileNameComparison = o1.specFileName.compareTo(o2.specFileName);
            if (fileNameComparison != 0) {
                return fileNameComparison;
            }
            if (o1.scanNum > o2.scanNum) {
                return 1;
            }
            if (o1.scanNum == o2.scanNum) {
                return 0;
            }
            return -1;
        }
    }
}

