/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.sequences;

import edu.ucsd.msjava.sequences.Sequence;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

public class FastaSequence
implements Sequence {
    private String baseFilepath;
    private final String seqExtension;
    private TreeMap<Integer, String> annotations;
    private TreeMap<String, Integer> header2ends;
    private ByteBuffer sequence;
    private ByteBuffer original;
    private int size;
    private HashMap<Character, Byte> alpha2byte;
    private HashMap<Byte, Character> byte2alpha;
    private String alphabetString;
    private int id;

    private void initializeAlphabet(String s) {
        String[] tokens = s.split(":");
        this.alpha2byte = new HashMap();
        this.byte2alpha = new HashMap();
        this.byte2alpha.put((byte)0, Character.valueOf('_'));
        int i = 0;
        byte value = 1;
        while (i < tokens.length) {
            for (int j = 0; j < tokens[i].length(); ++j) {
                this.alpha2byte.put(Character.valueOf(tokens[i].charAt(j)), value);
            }
            this.byte2alpha.put(value, Character.valueOf(tokens[i].charAt(0)));
            i = (byte)(i + 1);
            value = (byte)(value + 1);
        }
    }

    private void createObjectFromRawFile(String filepath) {
        int bufferSize = (int)new File(filepath).length();
        ByteBuffer sequence = ByteBuffer.allocate(bufferSize);
        StringBuffer original = new StringBuffer();
        HashMap<Integer, String> annotations = new HashMap<Integer, String>();
        HashMap<Character, Byte> alpha2byte = new HashMap<Character, Byte>();
        String alphabet = "";
        byte alphabetSize = 1;
        int size = 0;
        int id = UUID.randomUUID().hashCode();
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            Integer offset = 0;
            String annotation = null;
            while ((s = in.readLine()) != null) {
                if (!s.startsWith(">")) {
                    for (int index = 0; index < s.length(); ++index) {
                        Byte encoded = (Byte)alpha2byte.get(Character.valueOf(s.charAt(index)));
                        if (encoded != null) {
                            sequence.put(encoded);
                        } else {
                            sequence.put(alphabetSize);
                            byte by = alphabetSize;
                            alphabetSize = (byte)(alphabetSize + 1);
                            alpha2byte.put(Character.valueOf(s.charAt(index)), by);
                            alphabet = alphabet + ":" + s.charAt(index);
                        }
                        original.append(s.charAt(index));
                    }
                    offset = offset + s.length();
                    continue;
                }
                sequence.put((byte)0);
                original.append('_');
                if (annotation != null) {
                    annotations.put(offset, annotation);
                }
                Integer n = offset;
                offset = offset + 1;
                annotation = s.substring(1);
            }
            sequence.put((byte)0);
            original.append('_');
            Integer n = offset;
            offset = offset + 1;
            annotations.put(offset, annotation);
            size = offset;
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.writeMetaInfo(annotations, alphabet.substring(1), size, id);
        this.writeSequence(original, sequence, size, id);
    }

    private void createObjectFromRawFile(String filepath, String alphabet) {
        int bufferSize = (int)new File(filepath).length();
        ByteBuffer sequence = ByteBuffer.allocate(bufferSize);
        StringBuffer original = new StringBuffer();
        HashMap<Integer, String> annotations = new HashMap<Integer, String>();
        int size = 0;
        int id = UUID.randomUUID().hashCode();
        this.initializeAlphabet(alphabet);
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            Integer offset = 0;
            String annotation = null;
            while ((s = in.readLine()) != null) {
                if (!s.startsWith(">")) {
                    for (int index = 0; index < s.length(); ++index) {
                        Byte encoded = this.alpha2byte.get(Character.valueOf(s.charAt(index)));
                        if (encoded != null) {
                            sequence.put(encoded);
                        } else {
                            sequence.put((byte)0);
                        }
                        original.append(s.charAt(index));
                    }
                    offset = offset + s.length();
                    continue;
                }
                sequence.put((byte)0);
                original.append('_');
                if (annotation != null) {
                    annotations.put(offset, annotation);
                }
                Integer n = offset;
                offset = offset + 1;
                annotation = s.substring(1);
            }
            sequence.put((byte)0);
            original.append('_');
            Integer n = offset;
            offset = offset + 1;
            annotations.put(offset, annotation);
            size = offset;
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeMetaInfo(annotations, alphabet, size, id);
        this.writeSequence(original, sequence, size, id);
    }

    private void writeMetaInfo(HashMap<Integer, String> annotations, String alphabet, int size, int id) {
        String filepath = this.baseFilepath + this.seqExtension + "anno";
        try {
            PrintWriter out = new PrintWriter(filepath);
            out.println(size);
            out.println(id);
            out.println(alphabet);
            Set<Integer> keys = annotations.keySet();
            for (Integer key : keys) {
                out.println(key + ":" + annotations.get(key));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private int readMetaInfo() {
        String filepath = this.baseFilepath + this.seqExtension + "anno";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            this.size = Integer.parseInt(in.readLine());
            int id = Integer.parseInt(in.readLine());
            this.alphabetString = in.readLine().trim();
            this.annotations = new TreeMap();
            String line = in.readLine();
            while (line != null) {
                String[] tokens = line.split(":", 2);
                this.annotations.put(Integer.parseInt(tokens[0]), tokens[1]);
                line = in.readLine();
            }
            in.close();
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return 0;
        }
    }

    private void writeSequence(StringBuffer original, ByteBuffer sequence, int size, int id) {
        String filepath = this.baseFilepath + this.seqExtension;
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filepath)));
            out.writeInt(size);
            out.writeInt(id);
            for (int i = 0; i < size; ++i) {
                out.writeByte(sequence.get(i));
            }
            out.write(original.toString().getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private int readSequence() {
        String filepath = this.baseFilepath + this.seqExtension;
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(filepath)));
            int size = in.readInt();
            int id = in.readInt();
            byte[] sequenceArr = new byte[size];
            in.read(sequenceArr);
            this.sequence = ByteBuffer.wrap(sequenceArr).asReadOnlyBuffer();
            byte[] originalArr = new byte[size];
            in.read(originalArr);
            this.original = ByteBuffer.wrap(originalArr).asReadOnlyBuffer();
            in.close();
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return 0;
        }
    }

    public FastaSequence(String filepath) {
        this(filepath, null);
    }

    public FastaSequence(String filepath, String alphabet) {
        this(filepath, alphabet, ".seq");
    }

    public FastaSequence(String filepath, String alphabet, String seqExtension) {
        int seqId;
        int metaId;
        String basepath;
        this.seqExtension = seqExtension;
        String[] tokens = filepath.split("\\.");
        String extension = tokens[tokens.length - 1];
        this.baseFilepath = basepath = filepath.substring(0, filepath.length() - extension.length() - 1);
        if (!extension.equalsIgnoreCase("fasta") && !extension.equalsIgnoreCase("fa")) {
            System.err.println("Input error: not a fasta file");
            System.exit(-1);
        }
        String metaFile = basepath + this.seqExtension + "anno";
        String sequenceFile = basepath + seqExtension;
        if (!new File(metaFile).exists() || !new File(sequenceFile).exists()) {
            if (alphabet != null) {
                this.createObjectFromRawFile(filepath, alphabet);
            } else {
                this.createObjectFromRawFile(filepath);
            }
        }
        if ((metaId = this.readMetaInfo()) == (seqId = this.readSequence())) {
            this.initializeAlphabet(this.alphabetString);
            this.id = metaId;
        } else {
            System.err.println("The files " + metaFile + " and " + sequenceFile + " have different ids.");
            System.err.println("The problem can be solved by recreating the files");
            System.exit(-1);
        }
        this.header2ends = new TreeMap();
        for (int position : this.annotations.keySet()) {
            this.header2ends.put(this.annotations.get(position), position);
        }
    }

    @Override
    public Set<Byte> getAlphabetAsBytes() {
        return this.byte2alpha.keySet();
    }

    @Override
    public Collection<Character> getAlphabet() {
        ArrayList<Character> results = new ArrayList<Character>();
        for (char c : this.byte2alpha.values()) {
            if (c == '_') continue;
            results.add(Character.valueOf(c));
        }
        return results;
    }

    @Override
    public boolean isTerminator(long position) {
        return this.getByteAt(position) == 0;
    }

    @Override
    public char toChar(byte b) {
        if (this.byte2alpha.containsKey(b)) {
            return this.byte2alpha.get(b).charValue();
        }
        return '?';
    }

    @Override
    public int getAlphabetSize() {
        return this.byte2alpha.size();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte getByteAt(long position) {
        if (position >= (long)this.size) {
            return 0;
        }
        return this.sequence.get((int)position);
    }

    @Override
    public String getSubsequence(long start, long end) {
        if (start >= end || end > (long)this.size) {
            return null;
        }
        char[] seq = new char[(int)(end - start)];
        for (long i = start; i < end; ++i) {
            seq[(int)(i - start)] = (char)this.original.get((int)i);
        }
        return new String(seq);
    }

    @Override
    public char getCharAt(long position) {
        return (char)this.original.get((int)position);
    }

    @Override
    public String toString(byte[] sequence) {
        String retVal = "";
        for (byte item : sequence) {
            Character c = this.byte2alpha.get(item);
            retVal = c != null ? retVal + c : retVal + '?';
        }
        return retVal;
    }

    @Override
    public byte toByte(char c) {
        return this.alpha2byte.get(Character.valueOf(c));
    }

    @Override
    public byte[] getBytes(int start, int end) {
        byte[] result = new byte[end - start];
        for (int i = start; i < end; ++i) {
            result[i - start] = this.getByteAt(i);
        }
        return result;
    }

    @Override
    public boolean isInAlphabet(char c) {
        return this.alpha2byte.containsKey(Character.valueOf(c));
    }

    @Override
    public boolean isValid(long position) {
        if (this.isTerminator(position)) {
            return false;
        }
        return this.isInAlphabet(this.getCharAt(position));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAnnotation(long position) {
        Map.Entry<Integer, String> entry = this.annotations.higherEntry((int)position);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public long getStartPosition(long position) {
        Integer startPos = this.annotations.floorKey((int)position);
        if (startPos == null) {
            return 0L;
        }
        return startPos.intValue();
    }

    @Override
    public String getMatchingEntry(long position) {
        Integer start = this.annotations.floorKey((int)position);
        Integer end = this.annotations.higherKey((int)position);
        if (start == null) {
            start = 0;
        }
        if (end == null) {
            end = (int)this.getSize();
        }
        while (!this.isValid(end - 1)) {
            Integer n = end;
            end = end - 1;
        }
        return this.getSubsequence(start + 1, end.intValue());
    }

    @Override
    public String getMatchingEntry(String name) {
        String key = this.header2ends.ceilingKey(name);
        if (key == null || !key.startsWith(name)) {
            return null;
        }
        int position = this.header2ends.get(key) - 1;
        Integer start = this.annotations.floorKey(position);
        Integer end = this.annotations.higherKey(position);
        if (start == null) {
            start = 0;
        }
        if (end == null) {
            end = (int)this.getSize();
        }
        while (!this.isValid(end - 1)) {
            Integer n = end;
            end = end - 1;
        }
        return this.getSubsequence(start + 1, end.intValue());
    }

    public void setBaseFilepath(String baseFilepath) {
        this.baseFilepath = baseFilepath;
    }

    public String getBaseFilepath() {
        return this.baseFilepath;
    }

    public void set(long start, char c) {
        this.sequence.put((int)start, this.alpha2byte.get(Character.valueOf(c)));
        this.original.put((int)start, (byte)c);
    }

    public void makeModifiable() {
        ByteBuffer sequenceCopy = ByteBuffer.allocateDirect(this.size);
        ByteBuffer originalCopy = ByteBuffer.allocateDirect(this.size);
        sequenceCopy.put(this.sequence);
        originalCopy.put(this.original);
        this.sequence = sequenceCopy;
        this.original = originalCopy;
    }

    public List<String> getAnnotations() {
        return new ArrayList<String>(this.annotations.values());
    }

    public static void main(String[] args) {
        String userHome = System.getProperty("user.home");
        String filename = userHome + "/Data/Databases/uniprot_sprot.fasta";
        FastaSequence fs = new FastaSequence(filename);
        System.out.println("Total number of bases: " + fs.getSize());
    }
}

