/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.sequences;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.sequences.Constants;
import edu.ucsd.msjava.sequences.FastaSequence;
import edu.ucsd.msjava.sequences.MassSequence;
import java.util.HashSet;

public class ProteinFastaSequence
extends FastaSequence
implements MassSequence {
    private AminoAcidSet alpha = Constants.AA;
    private byte[] masses;
    private HashSet<Long> invalids;

    private void initialize() {
        this.invalids = new HashSet();
        this.masses = new byte[(int)this.getSize()];
        for (long position = 0L; position < this.getSize(); ++position) {
            if (this.isTerminator(position) || !this.alpha.contains(this.getCharAt(position))) {
                this.invalids.add(position);
                this.masses[(int)position] = 0;
                continue;
            }
            this.masses[(int)position] = (byte)(this.alpha.getAminoAcid(this.getCharAt(position)).getNominalMass() - 100);
        }
    }

    public ProteinFastaSequence(String filepath) {
        super(filepath, "A:C:D:E:F:G:H:I:K:L:M:N:P:Q:R:S:T:V:W:Y", ".pseq");
        this.initialize();
    }

    public ProteinFastaSequence(String filepath, String alphabet) {
        super(filepath, alphabet, ".pseq");
        this.initialize();
    }

    public ProteinFastaSequence(String filepath, String alphabet, AminoAcidSet aaSet) {
        super(filepath, alphabet, ".pseq");
        this.alpha = aaSet;
        this.initialize();
    }

    @Override
    public int getIntegerMass(long index) {
        return this.masses[(int)index] + 100;
    }

    @Override
    public int getIntegerMass(long start, long end) {
        int cumMass = 0;
        for (long i = start; i < end; ++i) {
            cumMass += this.getIntegerMass(i);
        }
        return cumMass;
    }

    @Override
    public boolean hasMass(long position) {
        return !this.invalids.contains(position) && position < this.getSize() && position >= 0L;
    }

    public static void main(String[] args) {
        ProteinFastaSequence s = new ProteinFastaSequence(System.getProperty("user.home") + "/Data/Databases/ShewDB/SOne_uniprot_plus_contaminants.fasta");
        System.out.println("Size of database: " + s.getSize());
    }
}

