/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.suffixarray;

import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.suffixarray.ByteSequence;
import edu.ucsd.msjava.suffixarray.MatchSet;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import edu.ucsd.msjava.suffixarray.SuffixFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SuffixArray {
    protected static final String SUFFIX_EXTENSION = ".sarray";
    protected static final int BUCKET_SIZE = 5;
    protected static final int INT_BYTE_SIZE = 4;
    protected IntBuffer indices;
    protected SuffixArraySequence sequence;
    protected SuffixFactory factory;
    protected ByteBuffer leftMiddleLcps;
    protected ByteBuffer middleRightLcps;
    protected ByteBuffer neighboringLcps;
    protected int size;

    private static void queryAllSubstrings(SuffixArray sa, SuffixArraySequence sequence, int iterations) {
        int tp = 0;
        int fn = 0;
        int tn = 0;
        int fp = 0;
        Random r = new Random();
        for (int i = 0; i < iterations; ++i) {
            int pos;
            int length = r.nextInt(50) + 5;
            int position = r.nextInt((int)(sequence.getSize() - (long)length));
            String query = sequence.getSubsequence(position, position + length);
            if (sequence.isEncodable(query)) {
                String match;
                pos = sa.search(sequence.toBytes(query));
                if (pos >= 0) {
                    match = sequence.getSubsequence(sa.getPosition(pos), sa.getPosition(pos) + length);
                    if (match.equals(query)) {
                        ++tp;
                        continue;
                    }
                    ++fn;
                    System.out.println(query + '\t' + match);
                    continue;
                }
                ++fn;
                match = sequence.getSubsequence(sa.getPosition(-pos - 1), sa.getPosition(-pos - 1) + length);
                System.out.println(query + "\t" + match);
                continue;
            }
            pos = sa.search(sequence.toBytes(query));
            if (pos >= 0) {
                System.out.println("We found incorrectly " + query + " at " + pos);
                System.out.println(sequence.getSubsequence(sa.getPosition(pos), sa.getPosition(pos) + length));
                System.exit(-1);
                ++fp;
                continue;
            }
            ++tn;
        }
        System.out.println();
        System.out.println("********** Test statistics **********");
        System.out.println("**** iterations: " + iterations);
        System.out.println("**** true positives: " + tp);
        System.out.println("**** false negative: " + fn);
        System.out.println("**** true negatives: " + tn);
        System.out.println("**** false positive: " + fp);
        System.out.println("**** sensitivity: " + (double)tp * 100.0 / (double)(tp + fn));
        System.out.println("**** specificity: " + (double)tn * 100.0 / (double)(tn + fp));
        System.out.println("*************************************");
        System.out.println();
    }

    private static void debug() {
        String userHome = System.getProperty("user.home");
        int iterations = 1000000;
        String fastaFile = userHome + "/Data/Databases/tiny.fasta";
        fastaFile = userHome + "/Data/Databases/yeast_nr050706.fasta";
        long time = System.currentTimeMillis();
        SuffixArraySequence sequence = new SuffixArraySequence(fastaFile);
        System.out.println("-- Loading fasta file time: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
        time = System.currentTimeMillis();
        SuffixArray sa = new SuffixArray(sequence);
        System.out.println("-- Loading SuffixArray file time: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
        time = System.currentTimeMillis();
        SuffixArray.queryAllSubstrings(sa, sequence, iterations);
        System.out.println("-- Searching time: " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s");
    }

    private static void printUsageAndExit() {
        System.out.println("usage: java SuffixArray [dbFile [queryFile]]");
        System.out.println("\tdbFile - the path to the database file with extension \".fasta\".");
        System.out.println("\tqueryFile - the path to the query file. One query per line. Use \"-\" for command line input.");
        System.out.println("\tArguments must be provided in order. Invocation with no arguments will run the tool through a series of test cases.");
        System.exit(-1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            SuffixArray.debug();
            return;
        }
        if (args.length <= 2) {
            SuffixArraySequence sequence = new SuffixArraySequence(args[0]);
            SuffixArray sa = new SuffixArray(sequence);
            BufferedReader input = null;
            if (args.length == 2) {
                try {
                    input = new BufferedReader(new FileReader(args[1]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                input = new BufferedReader(new InputStreamReader(System.in));
            }
            sa.searchWithFile(input);
        } else {
            SuffixArray.printUsageAndExit();
        }
    }

    public SuffixArray(SuffixArraySequence sequence, String suffixFile) {
        int id;
        this.sequence = sequence;
        this.factory = new SuffixFactory(sequence);
        if (!new File(suffixFile).exists()) {
            this.createSuffixArrayFile(sequence, suffixFile);
        }
        if ((id = this.readSuffixArrayFile(suffixFile)) != sequence.getId()) {
            System.err.println(suffixFile + " was not created from the sequence " + sequence.getBaseFilepath());
            System.err.println("Please recreate the suffix array file by deleting the .canno, .cseq, and .csarr files.");
            System.exit(-1);
        }
    }

    public SuffixArray(SuffixArraySequence sequence) {
        this(sequence, sequence.getBaseFilepath() + SUFFIX_EXTENSION);
    }

    public SuffixArray(CompactSuffixArray sa) {
    }

    public int getSize() {
        return this.size;
    }

    private static byte initializeLcps(byte[] nLcps, byte[] lLcps, byte[] rLcps, int start, int end) {
        byte rLcp;
        byte lLcp;
        if (end - start == 1) {
            return nLcps[end];
        }
        int middleIndex = (start + end) / 2;
        lLcps[middleIndex] = lLcp = SuffixArray.initializeLcps(nLcps, lLcps, rLcps, start, middleIndex);
        rLcps[middleIndex] = rLcp = SuffixArray.initializeLcps(nLcps, lLcps, rLcps, middleIndex, end);
        return lLcp < rLcp ? lLcp : rLcp;
    }

    protected void createSuffixArrayFile(SuffixArraySequence sequence, String suffixFile) {
        System.out.println("Creating the suffix array indexed file... Size: " + sequence.getSize());
        int hashBase = sequence.getAlphabetSize();
        if (hashBase > 30) {
            System.err.println("Suffix array construction failure: alphabet size is too large: " + sequence.getAlphabetSize());
            System.exit(-1);
        }
        int denominator = 1;
        for (int i = 0; i < 4; ++i) {
            denominator *= hashBase;
        }
        int numBuckets = denominator * hashBase;
        int currentHash = 0;
        for (int i = 0; i < 4; ++i) {
            currentHash = currentHash * hashBase + sequence.getByteAt(i);
        }
        class Bucket {
            private static final int INCREMENT_SIZE = 10;
            private int[] items = new int[10];
            private int size = 0;

            public void add(int item) {
                if (this.size >= this.items.length) {
                    int[] tempArray = new int[this.size + 10];
                    for (int i = 0; i < this.size; ++i) {
                        tempArray[i] = this.items[i];
                    }
                    this.items = tempArray;
                }
                this.items[this.size++] = item;
            }

            public SuffixFactory.Suffix[] getSortedSuffixes() {
                Object[] sa = new SuffixFactory.Suffix[this.size];
                for (int i = 0; i < this.size; ++i) {
                    sa[i] = SuffixArray.this.factory.makeSuffix(this.items[i]);
                }
                Arrays.sort(sa);
                return sa;
            }
        }
        Bucket[] bucketSuffixes = new Bucket[numBuckets];
        int i = 4;
        int limit = (int)sequence.getSize();
        for (int j = 0; j < limit; ++j) {
            if (j % 1000001 == 0) {
                System.out.printf("Suffix creation: %.2f%% complete.\n", (double)j * 100.0 / (double)sequence.getSize());
            }
            byte b = 0;
            if ((long)i < sequence.getSize()) {
                b = sequence.getByteAt(i);
            }
            if (bucketSuffixes[currentHash = currentHash % denominator * hashBase + b] == null) {
                bucketSuffixes[currentHash] = new Bucket();
            }
            bucketSuffixes[currentHash].add(j);
            ++i;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(suffixFile)));
            out.writeInt((int)sequence.getSize());
            out.writeInt(sequence.getId());
            SuffixFactory.Suffix prevBucketSuffix = null;
            byte[] neighboringLcps = new byte[(int)sequence.getSize()];
            int order = 0;
            for (int i2 = 0; i2 < bucketSuffixes.length; ++i2) {
                if (i2 % 100000 == 99999) {
                    System.out.printf("Sorting %.2f%% complete.\n", (double)i2 * 100.0 / (double)bucketSuffixes.length);
                }
                if (bucketSuffixes[i2] == null) continue;
                SuffixFactory.Suffix[] sortedSuffixes = bucketSuffixes[i2].getSortedSuffixes();
                SuffixFactory.Suffix first = sortedSuffixes[0];
                byte lcp = 0;
                if (prevBucketSuffix != null) {
                    lcp = first.getLCP(prevBucketSuffix);
                }
                out.writeInt(first.getIndex());
                neighboringLcps[order++] = lcp;
                SuffixFactory.Suffix prevSuffix = first;
                for (int j = 1; j < sortedSuffixes.length; ++j) {
                    SuffixFactory.Suffix thisSuffix = sortedSuffixes[j];
                    out.writeInt(thisSuffix.getIndex());
                    neighboringLcps[order++] = thisSuffix.getLCP(prevSuffix, 5);
                    prevSuffix = thisSuffix;
                }
                prevBucketSuffix = sortedSuffixes[0];
            }
            byte[] rLcps = new byte[(int)sequence.getSize()];
            byte[] lLcps = new byte[(int)sequence.getSize()];
            System.out.println("Computing the parameterized lcp arrays..");
            SuffixArray.initializeLcps(neighboringLcps, lLcps, rLcps, 0, (int)(sequence.getSize() - 1L));
            out.write(lLcps);
            out.write(rLcps);
            out.write(neighboringLcps);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected int readSuffixArrayFile(String suffixFile) {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(suffixFile)));
            this.size = in.readInt();
            int id = in.readInt();
            in.close();
            FileChannel fc = new FileInputStream(suffixFile).getChannel();
            long startPos = 8L;
            long sizeOfIndices = (long)this.size * 4L;
            int MAX_READ_SIZE = 0x7FFFFFFC;
            IntBuffer[] dsts = new IntBuffer[(int)(sizeOfIndices / 0x7FFFFFFCL) + 1];
            for (int i = 0; i < dsts.length; ++i) {
                if (i < dsts.length - 1) {
                    dsts[i] = fc.map(FileChannel.MapMode.READ_ONLY, startPos, 0x7FFFFFFCL).asIntBuffer();
                    startPos += 0x7FFFFFFCL;
                    continue;
                }
                dsts[i] = fc.map(FileChannel.MapMode.READ_ONLY, startPos, sizeOfIndices - (long)(0x7FFFFFFC * (dsts.length - 1))).asIntBuffer();
                startPos += sizeOfIndices - (long)(0x7FFFFFFC * (dsts.length - 1));
            }
            if (dsts.length == 1) {
                this.indices = dsts[0];
            } else {
                long totalCapacity = 0L;
                for (IntBuffer buf : dsts) {
                    totalCapacity += (long)buf.capacity();
                }
                assert (totalCapacity <= Integer.MAX_VALUE);
                this.indices = IntBuffer.allocate((int)totalCapacity);
                for (int i = 0; i < dsts.length; ++i) {
                    for (int j = 0; j < dsts[i].capacity(); ++j) {
                        this.indices.put(dsts[i].get());
                    }
                }
                this.indices.rewind();
            }
            int sizeOfLcps = this.size;
            this.leftMiddleLcps = fc.map(FileChannel.MapMode.READ_ONLY, startPos, sizeOfLcps).asReadOnlyBuffer();
            this.middleRightLcps = fc.map(FileChannel.MapMode.READ_ONLY, startPos += (long)sizeOfLcps, sizeOfLcps).asReadOnlyBuffer();
            this.neighboringLcps = fc.map(FileChannel.MapMode.READ_ONLY, startPos += (long)sizeOfLcps, sizeOfLcps).asReadOnlyBuffer();
            fc.close();
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return 0;
        }
    }

    public String toString() {
        String retVal = "Size of the suffix array: " + this.size + "\n";
        int rank = 0;
        while (this.indices.hasRemaining()) {
            int index = this.indices.get();
            byte lcp = this.neighboringLcps.get(rank);
            retVal = retVal + rank + "\t" + index + "\t" + lcp + "\t" + this.sequence.toString(this.factory.makeSuffix(index).getSequence()) + "\n";
            ++rank;
        }
        this.indices.rewind();
        this.neighboringLcps.rewind();
        return retVal;
    }

    public int getPosition(int index) {
        if (index >= 0 && index < this.size) {
            return this.indices.get(index);
        }
        return index;
    }

    public MatchSet findAll(ByteSequence pattern) {
        int matchIndex = this.search(pattern);
        MatchSet ms = new MatchSet();
        if (matchIndex >= 0) {
            int start;
            int numMatches;
            for (int i = matchIndex; i < this.size && (numMatches = this.sequence.getLCP(pattern, start = this.getPosition(i))) == pattern.getSize(); ++i) {
                ms.add(start, start + pattern.getSize());
            }
        }
        return ms;
    }

    public ArrayList<String> getAllMatchedStrings(String pattern) {
        MatchSet matchSet = this.findAll(pattern);
        ArrayList<String> matches = new ArrayList<String>();
        for (int i = 0; i < matchSet.getSize(); ++i) {
            int start = matchSet.getStart(i);
            int end = matchSet.getEnd(i);
            matches.add(this.sequence.toChar(this.sequence.getByteAt(start - 1)) + "." + this.sequence.getSubsequence(start, end) + "." + this.sequence.toChar(this.sequence.getByteAt(end)));
        }
        return matches;
    }

    public ArrayList<String> getAllMatchedStrings(String pattern, int lengthFlankingStr) {
        MatchSet matchSet = this.findAll(pattern);
        ArrayList<String> matches = new ArrayList<String>();
        for (int i = 0; i < matchSet.getSize(); ++i) {
            int start = matchSet.getStart(i);
            int end = matchSet.getEnd(i);
            String leftStr = this.sequence.getSubsequence(Math.max(0, start - lengthFlankingStr), start);
            String rightStr = this.sequence.getSubsequence(end + 1, Math.min((long)(end + 1 + lengthFlankingStr), this.sequence.getSize()));
            matches.add(leftStr + "." + this.sequence.getSubsequence(start, end) + "." + rightStr);
        }
        return matches;
    }

    public ArrayList<String> getAllMatchingAnnotations(String pattern) {
        ArrayList<String> annotationSet = new ArrayList<String>();
        MatchSet matchSet = this.findAll(pattern);
        for (int i = 0; i < matchSet.getSize(); ++i) {
            annotationSet.add(this.sequence.getAnnotation(matchSet.getStart(i)));
        }
        return annotationSet;
    }

    public String getAnnotation(int index) {
        return this.sequence.getAnnotation(index);
    }

    public ArrayList<String> getAllMatchingEntries(String pattern) {
        ArrayList<String> chunkSet = new ArrayList<String>();
        MatchSet matchSet = this.findAll(pattern);
        for (int i = 0; i < matchSet.getSize(); ++i) {
            chunkSet.add(this.sequence.getMatchingEntry(matchSet.getStart(i)));
        }
        return chunkSet;
    }

    public MatchSet findAll(String pattern) {
        return this.findAll(this.sequence.toBytes(pattern));
    }

    public int search(String pattern) {
        return this.search(this.sequence.toBytes(pattern));
    }

    public int search(ByteSequence pattern) {
        int leftResult = pattern.compareTo(this.factory.makeSuffix(this.indices.get(0)));
        if (Math.abs(leftResult) - 1 == pattern.getSize()) {
            return 0;
        }
        if (leftResult < 0) {
            return -1;
        }
        int rightResult = this.factory.makeSuffix(this.indices.get(this.size - 1)).compareTo(pattern);
        if (rightResult < 0) {
            return -this.size;
        }
        int queryLeftLcp = pattern.getLCP(this.factory.makeSuffix(this.indices.get(0)));
        int queryRightLcp = pattern.getLCP(this.factory.makeSuffix(this.indices.get(this.size - 1)));
        int leftIndex = 0;
        int rightIndex = (int)this.sequence.getSize() - 1;
        while (rightIndex - leftIndex > 1) {
            int middleResult;
            int middleIndex = (leftIndex + rightIndex) / 2;
            if (queryLeftLcp >= queryRightLcp) {
                int leftMiddleLcp = this.leftMiddleLcps.get(middleIndex);
                if (leftMiddleLcp > queryLeftLcp) {
                    leftIndex = middleIndex;
                    continue;
                }
                if (queryLeftLcp > leftMiddleLcp) {
                    queryRightLcp = leftMiddleLcp;
                    rightIndex = middleIndex;
                    continue;
                }
                middleResult = Math.min(pattern.compareTo(this.factory.makeSuffix(this.indices.get(middleIndex)), queryLeftLcp), 127);
                if (middleResult <= 0) {
                    queryRightLcp = middleResult == 0 ? pattern.getSize() : -middleResult - 1;
                    rightIndex = middleIndex;
                    continue;
                }
                queryLeftLcp = middleResult - 1;
                leftIndex = middleIndex;
                continue;
            }
            int middleRightLcp = this.middleRightLcps.get(middleIndex);
            if (middleRightLcp > queryRightLcp) {
                rightIndex = middleIndex;
                continue;
            }
            if (queryRightLcp > middleRightLcp) {
                queryLeftLcp = middleRightLcp;
                leftIndex = middleIndex;
                continue;
            }
            middleResult = Math.min(pattern.compareTo(this.factory.makeSuffix(this.indices.get(middleIndex)), queryRightLcp), 127);
            if (middleResult <= 0) {
                queryRightLcp = middleResult == 0 ? pattern.getSize() : -middleResult - 1;
                rightIndex = middleIndex;
                continue;
            }
            queryLeftLcp = middleResult - 1;
            leftIndex = middleIndex;
        }
        if (queryRightLcp == pattern.getSize()) {
            return rightIndex;
        }
        return -rightIndex - 1;
    }

    public void searchWithFile(BufferedReader in) {
    }

    public void printAllPeptides(AminoAcidSet aaSet, int minLength, int maxLength) {
        double[] aaMass = new double[128];
        for (int i = 0; i < aaMass.length; ++i) {
            aaMass[i] = -1.0;
        }
        for (AminoAcid aa : aaSet) {
            aaMass[aa.getResidue()] = aa.getAccurateMass();
        }
        double[] prm = new double[maxLength];
        int rank = 0;
        int i = Integer.MAX_VALUE;
        while (this.indices.hasRemaining()) {
            char residue;
            double m;
            int index = this.indices.get();
            int lcp = this.neighboringLcps.get(rank);
            ++rank;
            if (lcp > i) continue;
            for (i = lcp; i < maxLength && !((m = aaMass[residue = this.sequence.getCharAt(index + i)]) <= 0.0); ++i) {
                prm[i] = i != 0 ? prm[i - 1] + m : m;
                if (i + 1 < minLength || i + 1 > maxLength) continue;
                System.out.println(index + "\t" + (float)prm[i] + "\t" + this.sequence.getSubsequence(index, index + i + 1));
            }
        }
        this.indices.rewind();
        this.neighboringLcps.rewind();
    }

    public int getNumCandidatePeptides(AminoAcidSet aaSet, float peptideMass, Tolerance tolerance) {
        double[] aaMass = new double[128];
        for (int i = 0; i < aaMass.length; ++i) {
            aaMass[i] = -1.0;
        }
        for (AminoAcid aa : aaSet) {
            aaMass[aa.getResidue()] = aa.getAccurateMass();
        }
        int maxLength = 50;
        float tolDa = tolerance.getToleranceAsDa(peptideMass);
        double[] prm = new double[maxLength];
        int numCandidatePeptides = 0;
        int rank = 0;
        int matchLength = Integer.MAX_VALUE;
        block2: while (this.indices.hasRemaining()) {
            int index = this.indices.get();
            int lcp = this.neighboringLcps.get(rank);
            ++rank;
            if (lcp >= matchLength) {
                ++numCandidatePeptides;
                continue;
            }
            for (int i = lcp; i < maxLength; ++i) {
                char residue = this.sequence.getCharAt(index + i);
                double m = aaMass[residue];
                if (m <= 0.0) {
                    matchLength = Integer.MAX_VALUE;
                    continue block2;
                }
                prm[i] = i != 0 ? prm[i - 1] + m : m;
                if (prm[i] <= (double)(peptideMass - tolDa)) continue;
                if (prm[i] < (double)(peptideMass + tolDa)) {
                    matchLength = i;
                    ++numCandidatePeptides;
                    continue block2;
                }
                matchLength = Integer.MAX_VALUE;
                continue block2;
            }
        }
        this.indices.rewind();
        this.neighboringLcps.rewind();
        return numCandidatePeptides;
    }
}

