/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ui;

import edu.ucsd.msjava.msdictionary.MSDicLauncher;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.params.ParamParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.PklSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

@Deprecated
public class MSDictionary {
    public static void main(String[] argv) {
        if (argv.length != 2 && argv.length != 4) {
            MSDictionary.printUsageAndExit();
            System.exit(-1);
        }
        String paramFileName = null;
        String outputFileName = null;
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                MSDictionary.printUsageAndExit();
            }
            if (argv[i].equalsIgnoreCase("-i")) {
                paramFileName = argv[i + 1];
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-o")) continue;
            outputFileName = argv[i + 1];
        }
        if (paramFileName == null) {
            System.out.println("Error: parameter file is missing.");
            MSDictionary.printUsageAndExit();
        }
        MSDictionary.runMSDictionary(paramFileName, outputFileName);
    }

    public static void printUsageAndExit() {
        System.out.println("MS-Dictionary (v.20100201)\nusage: java -jar MSDictionary.jar -i paramFile [-o outputFile]\n(example: java -Xmx3000M -jar MSDictionary.jar -i sampleInput.txt -o test.txt)");
        System.exit(-1);
    }

    @Deprecated
    public static void runMSDictionary(String paramFile, String outputFileName) {
        String scoringParamFile;
        ParamParser.Parameters params = ParamParser.parseFromFile(paramFile);
        String specFileName = params.getParameter("Spectrum");
        if (!new File(specFileName).exists()) {
            MSDictionary.printParsingErrorAndExit(specFileName + " doesn't exist.");
        }
        Iterator<Spectrum> specIterator = null;
        String ext = specFileName.substring(specFileName.lastIndexOf(46) + 1);
        if (ext.equalsIgnoreCase("mzxml")) {
            specIterator = new MzXMLSpectraIterator(specFileName);
        } else {
            SpectrumParser parser = null;
            if (ext.equalsIgnoreCase("mgf")) {
                parser = new MgfSpectrumParser();
            } else if (ext.equalsIgnoreCase("pkl")) {
                parser = new PklSpectrumParser();
            } else {
                MSDictionary.printParsingErrorAndExit(ext + " format is not supported");
            }
            try {
                specIterator = new SpectraIterator(specFileName, parser);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String dbFileName = params.getParameter("Database");
        SuffixArray sa = null;
        if (dbFileName != null) {
            if (!new File(dbFileName).exists()) {
                MSDictionary.printParsingErrorAndExit(dbFileName + " doesn't exist.");
            }
            sa = new SuffixArray(new SuffixArraySequence(dbFileName, "A:C:D:E:F:G:H:IL:K:M:N:P:Q:R:S:T:V:W:Y"));
        }
        NewRankScorer scorer = (scoringParamFile = params.getParameter("ScoringParams")) == null ? NewScorerFactory.get(ActivationMethod.CID, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.TRYPSIN, Protocol.AUTOMATIC) : new NewRankScorer(scoringParamFile);
        MSDicLauncher msDicLauncher = new MSDicLauncher(specIterator, scorer, sa);
        Tolerance pmTolerance = null;
        String pmTolStr = params.getParameter("PMTolerance");
        if (pmTolStr != null) {
            pmTolerance = Tolerance.parseToleranceStr(pmTolStr);
        }
        if (pmTolerance == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid parent mass tolerance.");
        } else {
            msDicLauncher.pmTolerance(pmTolerance);
        }
        Float specProb = null;
        String specProbStr = params.getParameter("SpecProb");
        if (specProbStr != null) {
            specProb = Float.valueOf(Float.parseFloat(specProbStr));
        }
        if (specProb == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid spectral probability.");
        } else {
            msDicLauncher.specProb(specProb.floatValue());
        }
        Float numRecs = null;
        String numRecsStr = params.getParameter("NumRecs");
        if (numRecsStr != null) {
            numRecs = Float.valueOf(Float.parseFloat(numRecsStr));
        }
        if (numRecs == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid spectral probability.");
        } else {
            msDicLauncher.numRecs(numRecs.floatValue());
        }
        Integer isNumInclusive = params.getIntParameter("IsNumInclusive");
        if (isNumInclusive == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid IsNumInclusive field.");
        } else if (isNumInclusive == 1) {
            msDicLauncher.setNumInclusive();
        }
        Integer isTrypticOnly = params.getIntParameter("IsTrypticOnly");
        if (isTrypticOnly == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid IsTrypticOnly field.");
        } else if (isTrypticOnly == 0) {
            msDicLauncher.allowNonTryptic();
        }
        Integer msgfThreshold = params.getIntParameter("MSGFThreshold");
        if (msgfThreshold == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid MSGFThreshold field.");
        } else {
            msDicLauncher.msgfScoreThreshold(msgfThreshold);
        }
        Float minParentMass = params.getFloatParameter("MinParentMass");
        if (minParentMass == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid minimum parent mass.");
        } else {
            msDicLauncher.minParentMass(minParentMass.floatValue());
        }
        Float maxParentMass = params.getFloatParameter("MaxParentMass");
        if (maxParentMass == null) {
            MSDictionary.printParsingErrorAndExit("Input file parsing error: invalid maximum parent mass.");
        } else {
            msDicLauncher.maxParentMass(maxParentMass.floatValue());
        }
        if (outputFileName != null) {
            msDicLauncher.outputFileName(outputFileName);
        }
        msDicLauncher.runMSDictionary();
    }

    public static void printParsingErrorAndExit(String message) {
        System.err.println(message);
        System.exit(-1);
    }
}

