/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ui;

import edu.ucsd.msjava.msgf.AminoAcidGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.NominalMassFactory;
import edu.ucsd.msjava.msgf.Profile;
import edu.ucsd.msjava.msgf.ProfileGF;
import edu.ucsd.msjava.msgf.ProfilePeak;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msgf.ScoredSpectrumSum;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.Sequence;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class MSProfile {
    public static float MIN_PROF_PROB_REPORT_THRESHOLD = 0.01f;

    public static void main(String[] argv) {
        if (argv.length < 2 || argv.length % 2 != 0) {
            MSProfile.printUsageAndExit("Invalid parameters");
        }
        File specFile = null;
        SpecFileFormat specFileFormat = null;
        File paramFile = null;
        boolean isPaired = false;
        boolean pairSpecified = false;
        String fragMethod = null;
        boolean methodSpecified = false;
        File outputFile = null;
        File profFile = null;
        File prmFile = null;
        float specProbThreshold = 1.0E-9f;
        float delta = 0.03f;
        float profProbThreshold = 0.3f;
        Enzyme enzyme = Enzyme.TRYPSIN;
        boolean isFixedModSpecified = false;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                MSProfile.printUsageAndExit("Invalid parameter: " + argv[i]);
            }
            if (argv[i].equalsIgnoreCase("-i")) {
                String specFileName;
                String ext;
                specFile = new File(argv[i + 1]);
                if (!specFile.exists()) {
                    MSProfile.printUsageAndExit(specFile + " doesn't exist.");
                }
                if ((ext = (specFileName = specFile.getName()).substring(specFileName.lastIndexOf(46) + 1)).equalsIgnoreCase("mzxml")) {
                    specFileFormat = SpecFileFormat.MZXML;
                } else if (ext.equalsIgnoreCase("mgf")) {
                    specFileFormat = SpecFileFormat.MGF;
                }
                if (specFileFormat != null) continue;
                MSProfile.printUsageAndExit("Invalid file format: " + specFileName);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-param")) {
                paramFile = new File(argv[i + 1]);
                if (paramFile.exists()) continue;
                MSProfile.printUsageAndExit(paramFile + " doesn't exist.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pair")) {
                if (methodSpecified) {
                    MSProfile.printUsageAndExit("Invalid parameter: at most one of -m and -pair can be specified!");
                }
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    isPaired = false;
                } else if (argv[i + 1].equalsIgnoreCase("1")) {
                    isPaired = true;
                } else {
                    MSProfile.printUsageAndExit("Invalid parameter: -pair " + argv[i + 1]);
                }
                pairSpecified = true;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-m")) {
                if (pairSpecified) {
                    MSProfile.printUsageAndExit("Invalid parameter: at most one of -m and -pair can be specified!");
                }
                fragMethod = argv[i + 1];
                methodSpecified = true;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-gp")) {
                outputFile = new File(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-prof")) {
                profFile = new File(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-prm")) {
                prmFile = new File(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-p")) {
                try {
                    specProbThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    MSProfile.printUsageAndExit("Invalid specProbThreshold: " + argv[i + 1]);
                }
                continue;
            }
            if (argv[i].equalsIgnoreCase("-delta")) {
                try {
                    delta = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    MSProfile.printUsageAndExit("Invalid deltaScoreForGPTemplate: " + argv[i + 1]);
                }
                continue;
            }
            if (argv[i].equalsIgnoreCase("-prob")) {
                try {
                    profProbThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    MSProfile.printUsageAndExit("Invalid profProbThreshold: " + argv[i + 1]);
                }
                continue;
            }
            if (argv[i].equalsIgnoreCase("-e")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    enzyme = null;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    enzyme = Enzyme.TRYPSIN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    enzyme = Enzyme.CHYMOTRYPSIN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("3")) {
                    enzyme = Enzyme.LysC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("4")) {
                    enzyme = Enzyme.LysN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("5")) {
                    enzyme = Enzyme.GluC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("6")) {
                    enzyme = Enzyme.ArgC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("7")) {
                    enzyme = Enzyme.AspN;
                    continue;
                }
                MSProfile.printUsageAndExit("Invalid enzyme: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-fixMod")) {
                isFixedModSpecified = true;
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSet();
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarboxymethylatedCys();
                    continue;
                }
                MSProfile.printUsageAndExit("Invalid -fixMod parameter: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-aaSet") && !isFixedModSpecified) {
                File aaSetFile = new File(argv[i + 1]);
                if (!aaSetFile.exists()) {
                    MSProfile.printUsageAndExit(aaSetFile + " doesn't exist.");
                }
                aaSet = AminoAcidSet.getAminoAcidSet(aaSetFile.getPath());
                continue;
            }
            MSProfile.printUsageAndExit("Invalid parameter!");
        }
        if (specFile == null) {
            MSProfile.printUsageAndExit("specFileName is not specified!");
        }
        MSProfile.runMSProfile(specFile, specFileFormat, outputFile, profFile, prmFile, enzyme, fragMethod, isPaired, aaSet, specProbThreshold, delta, profProbThreshold, paramFile);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.out.println("MSProfile 07/08/2011");
        System.out.println("usage: java -Xmx2000M -jar MSProfile.jar \n\t-i SpecFileName (*.mzXML)\n\t[-gp GappedPeptideOutputFileName] (Default: stdout)\n\t[-prof ProfileOutputFileName] (Default: no output)\n\t[-prm PrmScoreOutputFileName] (Default: no output)\n\t[-m FragMethod] (if specified, FragMethod will be exclusively considered, e.g. -m CID)\n\t[-pair 0/1 ] (0: not paired (default), 1: paired)\n\t[-e Enzyme 0/1/2/3/4/5/6/7] (0: No enzyme, 1: Trypsin (default), 2: Chymotrypsin, 3: LysC, 4: LysN, 5: GluC, 6: ArgC, 7: AspN)\n\t[-fixMod 0/1/2] (0: NoCysteineProtection, 1: CarbamidomethyC (default), 2: CarboxymethylC)\n\t[-aaSet AASetFileName (default: standard amino acids)]\n\t[-p SpecProbThreshold] (Default: 1e-9)\n\t[-delta DeltaScoreForGPTemplate] (Default: 0.03)\n\t[-prob ProfProbThreshold] (Default: 0.3)\n\t[-param ScoringParamFile]\n");
        System.exit(-1);
    }

    public static void runMSProfile(File specFile, SpecFileFormat format, File gpOutFile, File profOutFile, File prmOutFile, Enzyme enzyme, String fragMethod, boolean isPaired, AminoAcidSet aaSet, float specProbThreshold, float delta, float profProbThreshold, File paramFile) {
        Iterator<Spectrum> iterator = null;
        try {
            if (format == SpecFileFormat.MZXML) {
                iterator = new MzXMLSpectraIterator(specFile.getPath());
            } else if (format == SpecFileFormat.MGF) {
                iterator = new SpectraIterator(specFile.getPath(), (SpectrumParser)new MgfSpectrumParser());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintStream out = null;
        if (gpOutFile != null) {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(gpOutFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        PrintStream profOut = null;
        if (profOutFile != null) {
            try {
                profOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(profOutFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        PrintStream prmOut = null;
        if (prmOutFile != null) {
            try {
                prmOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(prmOutFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        NewRankScorer customScorer = null;
        if (paramFile != null) {
            customScorer = new NewRankScorer(paramFile.getPath());
        }
        int prevScanNum = 0;
        float prevPrecursorMz = 0.0f;
        int prevCharge = 0;
        ActivationMethod prevMethod = null;
        NewScoredSpectrum<NominalMass> cachedScoredSpec = null;
        NominalMassFactory nominalMassFactory = new NominalMassFactory(aaSet, enzyme, 50);
        out.println("SpecFileName\tScanNum\tFragmentation\tPrecursorMz\tCharge\tMSGFScore\tGappedPeptide");
        while (iterator.hasNext()) {
            int mass;
            boolean paired;
            Spectrum spec = iterator.next();
            if (spec.getActivationMethod() == null) {
                spec.setActivationMethod(ActivationMethod.CID);
            }
            if (spec.getScanNum() <= 0) {
                System.err.println("No scan number info in the spectrum!");
                System.exit(-1);
            }
            if (fragMethod != null && !spec.getActivationMethod().getName().equalsIgnoreCase(fragMethod)) continue;
            int nominalPepMass = Math.round((spec.getPrecursorMass() - 18.010565f) * 0.999497f);
            int scanNum = spec.getScanNum();
            float precursorMz = spec.getPrecursorPeak().getMz();
            if (isPaired && scanNum == prevScanNum + 1 && precursorMz == prevPrecursorMz && spec.getCharge() == prevCharge && spec.getActivationMethod() != prevMethod) {
                paired = true;
            } else {
                paired = false;
                prevScanNum = scanNum;
                prevMethod = spec.getActivationMethod();
                prevPrecursorMz = precursorMz;
                prevCharge = spec.getCharge();
            }
            NewRankScorer scorer = customScorer != null ? customScorer : NewScorerFactory.get(spec.getActivationMethod(), InstrumentType.LOW_RESOLUTION_LTQ, enzyme, Protocol.AUTOMATIC);
            NewScoredSpectrum<NominalMass> curScoredSpec = scorer.getScoredSpectrum(spec);
            ScoredSpectrum<NominalMass> scoredSpec = null;
            String scanNumStr = null;
            String methodStr = null;
            if (!isPaired) {
                scoredSpec = curScoredSpec;
                scanNumStr = String.valueOf(spec.getScanNum());
                methodStr = spec.getActivationMethod().getName();
            } else if (paired) {
                scanNumStr = "" + (spec.getScanNum() - 1) + "-" + spec.getScanNum();
                ArrayList scoredSpecList = new ArrayList();
                scoredSpecList.add(cachedScoredSpec);
                scoredSpecList.add(curScoredSpec);
                scoredSpec = new ScoredSpectrumSum(scoredSpecList);
                methodStr = prevMethod.getName() + "/" + spec.getActivationMethod().getName();
            } else {
                cachedScoredSpec = curScoredSpec;
                continue;
            }
            AminoAcidGraph graph = new AminoAcidGraph(nominalMassFactory, spec.getPrecursorMass(), scoredSpec);
            GeneratingFunction<NominalMass> gf = new GeneratingFunction<NominalMass>(graph).enzyme(enzyme);
            gf.computeGeneratingFunction();
            ProfileGF<NominalMass> profGf = new ProfileGF<NominalMass>(gf);
            profGf.computeProfile(specProbThreshold);
            Profile<NominalMass> profile = profGf.getSpectralProfile();
            Sequence<NominalMass> gappedPeptide = profGf.getGappedPeptideWithNominalMasses(1.0f - delta, profProbThreshold);
            out.print(specFile.getName() + "\t" + scanNumStr + "\t" + methodStr + "\t" + spec.getPrecursorPeak().getMz() + "\t" + spec.getCharge() + "\t");
            out.print("\t" + (gf.getMaxScore() - 1));
            if (gappedPeptide.size() > 1) {
                out.print("\t");
                for (int i = gappedPeptide.size() - 2; i >= 0; --i) {
                    out.print(nominalPepMass - ((NominalMass)gappedPeptide.get(i)).getNominalMass() + ",");
                }
                out.print(nominalPepMass);
            }
            out.println();
            if (profOut != null) {
                profOut.println("BEGIN IONS");
                profOut.println("TITLE=Profile_" + scanNumStr);
                profOut.println("PEPMASS=" + spec.getPrecursorPeak().getMz());
                profOut.println("SCANS=" + scanNumStr);
                profOut.println("CHARGE=" + spec.getCharge() + "+");
                Profile<NominalMass> suffixProfile = profile.toNominalMasses();
                for (int i = suffixProfile.size() - 2; i >= 1; --i) {
                    ProfilePeak p = (ProfilePeak)suffixProfile.get(i);
                    if (!(p.getProbability() >= MIN_PROF_PROB_REPORT_THRESHOLD)) continue;
                    mass = nominalPepMass - ((NominalMass)p.getNode()).getNominalMass();
                    profOut.println(mass + "\t" + p.getProbability());
                }
                profOut.println(nominalPepMass + "\t" + 1);
                profOut.println("END IONS");
                profOut.println();
            }
            if (prmOut == null) continue;
            prmOut.println("BEGIN IONS");
            prmOut.println("TITLE=PRM_" + scanNumStr);
            prmOut.println("PEPMASS=" + spec.getPrecursorPeak().getMz());
            prmOut.println("SCANS=" + scanNumStr);
            prmOut.println("CHARGE=" + spec.getCharge() + "+");
            ArrayList<NominalMass> srmMassList = gf.getGraph().getIntermediateNodeList();
            Collections.sort(srmMassList, Collections.reverseOrder());
            for (NominalMass m : srmMassList) {
                mass = nominalPepMass - m.getNominalMass();
                int score = gf.getGraph().getNodeScore(m);
                if (score > 100000) {
                    score = -10;
                }
                prmOut.println(mass + "\t" + score);
            }
            prmOut.println("END IONS");
            prmOut.println();
        }
        if (out != null) {
            out.close();
        }
        if (profOut != null) {
            profOut.close();
        }
        if (prmOut != null) {
            prmOut.close();
        }
    }
}

