/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.stax;

import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.stax.ByteBufferIterator;
import org.systemsbiology.jrap.stax.LineIterator;
import org.systemsbiology.jrap.stax.StringBuilderReader;

public class EndPatternStringIterator
implements Iterator {
    private static XMLInputFactory inputfactory = XMLInputFactory.newInstance();
    private LineIterator li;
    Pattern leftPat = null;
    Pattern rightPat = null;
    private String leftPatStr;
    private String rightPatStr;
    private long filePos = 0L;
    private int firstLineNo = 0;
    StringBuilder curBuf = new StringBuilder();
    StringBuilder curLine = null;
    boolean noMore = false;

    public LineIterator getLi() {
        return this.li;
    }

    public void setLi(LineIterator li) {
        this.li = li;
    }

    public String getLeftPatStr() {
        return this.leftPatStr;
    }

    public void setLeftPatStr(String leftPatStr) {
        this.leftPatStr = leftPatStr;
        this.leftPat = Pattern.compile(leftPatStr);
    }

    public String getRightPatStr() {
        return this.rightPatStr;
    }

    public void setRightPatStr(String rightPatStr) {
        this.rightPatStr = rightPatStr;
        this.rightPat = Pattern.compile(rightPatStr);
    }

    public long getFilePos() {
        return this.filePos;
    }

    public int getFirstLineNo() {
        return this.firstLineNo;
    }

    public EndPatternStringIterator(String leftPat, String rightPat, LineIterator li) {
        this.setLi(li);
        this.setLeftPatStr(leftPat);
        this.setRightPatStr(rightPat);
    }

    public EndPatternStringIterator(String leftPat, String rightPat, String path) throws IOException {
        this.setLi(new LineIterator(new ByteBufferIterator(path)));
        this.setLeftPatStr(leftPat);
        this.setRightPatStr(rightPat);
    }

    @Override
    public boolean hasNext() {
        return !this.noMore;
    }

    public StringBuilder next() {
        Matcher rightMatch;
        Matcher leftMatch;
        this.curBuf.setLength(0);
        while (true) {
            if (this.curLine == null || this.curLine.length() == 0) {
                if (this.li.hasNext()) {
                    this.curLine = this.li.next();
                } else {
                    this.noMore = true;
                    return this.curBuf;
                }
            }
            if ((leftMatch = this.leftPat.matcher(this.curLine)).find()) break;
            this.curLine.setLength(0);
        }
        int leftStartIndex = leftMatch.start();
        int leftEndIndex = leftMatch.end();
        this.filePos = this.li.getFilePos() + (long)leftStartIndex;
        this.firstLineNo = this.li.getLineNum();
        this.curBuf.append(this.curLine.subSequence(leftStartIndex, leftEndIndex));
        this.curLine.delete(0, leftEndIndex);
        while (true) {
            if (this.curLine.length() == 0) {
                this.curBuf.append(' ');
                if (this.li.hasNext()) {
                    this.curLine = this.li.next();
                } else {
                    this.noMore = true;
                    return this.curBuf;
                }
            }
            if ((rightMatch = this.rightPat.matcher(this.curLine)).find()) break;
            this.curBuf.append((CharSequence)this.curLine);
            this.curLine.setLength(0);
        }
        int rightEndIndex = rightMatch.end();
        this.curBuf.append(this.curLine.subSequence(0, rightEndIndex));
        this.curLine.delete(0, rightEndIndex);
        return this.curBuf;
    }

    public XMLStreamReader xmlsrNext() throws IOException {
        StringBuilder cursb = this.next();
        XMLStreamReader retVal = null;
        try {
            retVal = inputfactory.createXMLStreamReader(new StringBuilderReader(cursb));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return retVal;
    }

    public XMLStreamReader xmlsrCur() throws Exception {
        return inputfactory.createXMLStreamReader(new StringBuilderReader(this.curBuf));
    }

    @Override
    public void remove() {
    }

    public static void main(String[] argv) {
        try {
            EndPatternStringIterator epsi = new EndPatternStringIterator(argv[0], argv[1], new LineIterator(new ByteBufferIterator(argv[2])));
            while (epsi.hasNext()) {
                StringBuilder sb = epsi.next();
                int lineno = epsi.getFirstLineNo();
                long filePos = epsi.getFilePos();
                System.out.println("Line: " + lineno + " filePos: " + filePos + " " + sb);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

