/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import uk.ac.ebi.jmzidml.MzIdentMLElement;

public enum MzIdentMLVersion {
    Version_1_1("http://psidev.info/psi/pi/mzIdentML/1.1", "1.1.0", "http://www.psidev.info/files/mzIdentML1.1.0.xsd"),
    Version_1_2("http://psidev.info/psi/pi/mzIdentML/1.2", "1.2.0", "http://www.psidev.info/files/mzIdentML1.2.0.xsd");

    private final String MZIDML_NS;
    private final String MZIDML_VERSION;
    private final String MZIDML_SCHEMA;
    private Map<Class, QName> modelQNames = new HashMap<Class, QName>();

    private MzIdentMLVersion(String ns, String ver, String schema) {
        this.MZIDML_NS = ns;
        this.MZIDML_VERSION = ver;
        this.MZIDML_SCHEMA = schema;
        for (MzIdentMLElement element : MzIdentMLElement.values()) {
            if (element.getTagName() == null) continue;
            this.modelQNames.put(element.getClazz(), new QName(this.MZIDML_NS, element.getTagName()));
        }
        this.modelQNames = Collections.unmodifiableMap(this.modelQNames);
    }

    public String getNameSpace() {
        return this.MZIDML_NS;
    }

    public String getVersionString() {
        return this.MZIDML_VERSION;
    }

    public String getSchema() {
        return this.MZIDML_SCHEMA;
    }

    public boolean isRegisteredClass(Class cls) {
        return this.modelQNames.containsKey(cls);
    }

    public QName getQNameForClass(Class cls) {
        if (this.isRegisteredClass(cls)) {
            return this.modelQNames.get(cls);
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public String getElementNameForClass(Class cls) {
        if (this.isRegisteredClass(cls)) {
            return this.modelQNames.get(cls).getLocalPart();
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public Class getClassForElementName(String name) {
        for (Map.Entry<Class, QName> entry : this.modelQNames.entrySet()) {
            if (!entry.getValue().getLocalPart().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static MzIdentMLVersion getVersion(String ver) {
        if (ver.equals("1.1")) {
            return Version_1_1;
        }
        if (ver.equals("1.2")) {
            return Version_1_2;
        }
        return null;
    }
}

