/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.ebi.jmzidml.model.utils.ModelConstants;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectCache;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.filters.MzIdentMLNamespaceFilter;
import uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.listeners.RawXMLListener;
import uk.ac.ebi.jmzidml.xml.xxindex.MzIdentMLIndexer;

public class UnmarshallerFactory {
    private static final Logger logger = LoggerFactory.getLogger(UnmarshallerFactory.class);
    private static UnmarshallerFactory instance = new UnmarshallerFactory();
    private static JAXBContext jc = null;

    public static UnmarshallerFactory getInstance() {
        return instance;
    }

    private UnmarshallerFactory() {
    }

    public Unmarshaller initializeUnmarshaller(MzIdentMLIndexer index, MzIdentMLObjectCache cache, MzIdentMLNamespaceFilter xmlFilter) {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance(ModelConstants.PACKAGE);
            }
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setListener(new RawXMLListener(index, cache, xmlFilter.getMzIdentMLVersion()));
            UnmarshallerHandler uh = unmarshaller.getUnmarshallerHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlFilter.setParent(xmlReader);
            xmlFilter.setContentHandler(uh);
            logger.debug("Unmarshaller Initialized");
            return unmarshaller;
        }
        catch (JAXBException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
        catch (SAXException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
        catch (ParserConfigurationException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
    }
}

