/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.model.mzml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.Chromatogram;
import uk.ac.ebi.jmzml.model.mzml.Component;
import uk.ac.ebi.jmzml.model.mzml.InstrumentConfiguration;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.model.mzml.ProcessingMethod;
import uk.ac.ebi.jmzml.model.mzml.ReferenceableParamGroupRef;
import uk.ac.ebi.jmzml.model.mzml.Run;
import uk.ac.ebi.jmzml.model.mzml.Sample;
import uk.ac.ebi.jmzml.model.mzml.Scan;
import uk.ac.ebi.jmzml.model.mzml.ScanList;
import uk.ac.ebi.jmzml.model.mzml.ScanSettings;
import uk.ac.ebi.jmzml.model.mzml.Software;
import uk.ac.ebi.jmzml.model.mzml.SourceFile;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.model.mzml.UserParam;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ParamGroupType", propOrder={"referenceableParamGroupRef", "cvParam", "userParam"})
@XmlSeeAlso(value={Scan.class, ProcessingMethod.class, Run.class, Software.class, SourceFile.class, InstrumentConfiguration.class, BinaryDataArray.class, Sample.class, Spectrum.class, Component.class, ScanSettings.class, Chromatogram.class, ScanList.class})
public class ParamGroup
extends MzMLObject
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ParamGroup.class);
    private static final long serialVersionUID = 100L;
    protected List<ReferenceableParamGroupRef> referenceableParamGroupRef;
    protected List<CVParam> cvParam;
    protected List<UserParam> userParam;
    @XmlTransient
    private List<CVParam> cvParamsSkippedDuringMarshalling = new ArrayList<CVParam>();
    @XmlTransient
    private List<UserParam> userParamsSkippedDuringMarshalling = new ArrayList<UserParam>();

    public List<ReferenceableParamGroupRef> getReferenceableParamGroupRef() {
        if (this.referenceableParamGroupRef == null) {
            this.referenceableParamGroupRef = new ArrayList<ReferenceableParamGroupRef>();
        }
        return this.referenceableParamGroupRef;
    }

    public List<CVParam> getCvParam() {
        if (this.cvParam == null) {
            this.cvParam = new ArrayList<CVParam>();
        }
        return this.cvParam;
    }

    public List<UserParam> getUserParam() {
        if (this.userParam == null) {
            this.userParam = new ArrayList<UserParam>();
        }
        return this.userParam;
    }

    public boolean beforeMarshalOperation() {
        List<CVParam> cvParams = this.getCvParam();
        ArrayList<CVParam> tempCV = new ArrayList<CVParam>();
        for (CVParam cvParam : cvParams) {
            if (cvParam.isInferredFromReferenceableParamGroupRef()) {
                this.cvParamsSkippedDuringMarshalling.add(cvParam);
                logger.debug("Skipping cvParam " + cvParam);
                continue;
            }
            tempCV.add(cvParam);
        }
        this.cvParam = tempCV;
        List<UserParam> userParams = this.getUserParam();
        ArrayList<UserParam> tempUser = new ArrayList<UserParam>();
        for (UserParam userParam : userParams) {
            if (userParam.isInferredFromReferenceableParamGroupRef()) {
                this.userParamsSkippedDuringMarshalling.add(userParam);
                logger.debug("Skipping cvParam " + userParam);
                continue;
            }
            tempUser.add(userParam);
        }
        this.userParam = tempUser;
        return true;
    }

    public void afterMarshalOperation() {
        this.cvParam.addAll(this.cvParamsSkippedDuringMarshalling);
        logger.debug("Re-inserting " + this.cvParamsSkippedDuringMarshalling.size() + " referenceable CV params into the main cv param list after marshalling.");
        this.userParam.addAll(this.userParamsSkippedDuringMarshalling);
        logger.debug("Re-inserting " + this.userParamsSkippedDuringMarshalling.size() + " referenceable user params into the main user param list after marshalling.");
        this.cvParamsSkippedDuringMarshalling.clear();
        this.userParamsSkippedDuringMarshalling.clear();
    }
}

