/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.model.mzml.utilities;

import java.util.Arrays;
import uk.ac.ebi.jmzml.model.mzml.utilities.IntDecoder;

public class MSNumpress {
    public static final String ACC_NUMPRESS_LINEAR = "MS:1002312";
    public static final String ACC_NUMPRESS_PIC = "MS:1002313";
    public static final String ACC_NUMPRESS_SLOF = "MS:1002314";

    public static byte[] encode(double[] data, String cvAccession) {
        switch (cvAccession) {
            case "MS:1002312": {
                byte[] buffer = new byte[8 + data.length * 5];
                int encodedBytes = MSNumpress.encodeLinear(data, data.length, buffer, MSNumpress.optimalLinearFixedPoint(data, data.length));
                return Arrays.copyOf(buffer, encodedBytes);
            }
            case "MS:1002314": {
                byte[] buffer = new byte[8 + data.length * 2];
                int encodedBytes = MSNumpress.encodeSlof(data, data.length, buffer, MSNumpress.optimalSlofFixedPoint(data, data.length));
                return Arrays.copyOf(buffer, encodedBytes);
            }
            case "MS:1002313": {
                byte[] buffer = new byte[data.length * 5];
                int encodedBytes = MSNumpress.encodePic(data, data.length, buffer);
                return Arrays.copyOf(buffer, encodedBytes);
            }
        }
        throw new IllegalArgumentException("'" + cvAccession + "' is not a numpress compression term");
    }

    public static Double[] decode(String cvAccession, byte[] data) {
        switch (cvAccession) {
            case "MS:1002312": {
                Double[] buffer = new Double[data.length * 2];
                int nbrOfDoubles = MSNumpress.decodeLinear(data, data.length, buffer);
                Double[] result = new Double[nbrOfDoubles];
                System.arraycopy(buffer, 0, result, 0, nbrOfDoubles);
                return result;
            }
            case "MS:1002314": {
                Double[] buffer = new Double[data.length / 2];
                int nbrOfDoubles = MSNumpress.decodeSlof(data, data.length, buffer);
                Double[] result = new Double[nbrOfDoubles];
                System.arraycopy(buffer, 0, result, 0, nbrOfDoubles);
                return result;
            }
            case "MS:1002313": {
                Double[] buffer = new Double[data.length * 2];
                int nbrOfDoubles = MSNumpress.decodePic(data, data.length, buffer);
                Double[] result = new Double[nbrOfDoubles];
                System.arraycopy(buffer, 0, result, 0, nbrOfDoubles);
                return result;
            }
        }
        throw new IllegalArgumentException("'" + cvAccession + "' is not a numpress compression term");
    }

    public static int encodeInt(long x, byte[] res, int resOffset) {
        long mask = -268435456L;
        long init = x & mask;
        if (init == 0L) {
            int i;
            int l = 8;
            for (i = 0; i < 8; i = (int)((byte)(i + 1))) {
                long m = mask >> 4 * i;
                if ((x & m) == 0L) continue;
                l = i;
                break;
            }
            res[resOffset] = l;
            for (i = l; i < 8; i = (int)((byte)(i + 1))) {
                res[resOffset + 1 + i - l] = (byte)(0xFL & x >> 4 * (i - l));
            }
            return 9 - l;
        }
        if (init == mask) {
            int i;
            int l = 7;
            for (i = 0; i < 8; i = (int)((byte)(i + 1))) {
                long m = mask >> 4 * i;
                if ((x & m) == m) continue;
                l = i;
                break;
            }
            res[resOffset] = (byte)(l | 8);
            for (i = l; i < 8; i = (int)((byte)(i + 1))) {
                res[resOffset + 1 + i - l] = (byte)(0xFL & x >> 4 * (i - l));
            }
            return 9 - l;
        }
        res[resOffset] = 0;
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            res[resOffset + 1 + i] = (byte)(0xFL & x >> 4 * i);
        }
        return 9;
    }

    public static void encodeFixedPoint(double fixedPoint, byte[] result) {
        long fp = Double.doubleToLongBits(fixedPoint);
        for (int i = 0; i < 8; ++i) {
            result[7 - i] = (byte)(fp >> 8 * i & 0xFFL);
        }
    }

    public static double decodeFixedPoint(byte[] data) {
        long fp = 0L;
        for (int i = 0; i < 8; ++i) {
            fp |= (0xFFL & (long)data[7 - i]) << 8 * i;
        }
        return Double.longBitsToDouble(fp);
    }

    public static double optimalLinearFixedPoint(double[] data, int dataSize) {
        if (dataSize == 0) {
            return 0.0;
        }
        if (dataSize == 1) {
            return Math.floor(4.294967295E9 / data[0]);
        }
        double maxDouble = Math.max(data[0], data[1]);
        for (int i = 2; i < dataSize; ++i) {
            double extrapol = data[i - 1] + (data[i - 1] - data[i - 2]);
            double diff = data[i] - extrapol;
            maxDouble = Math.max(maxDouble, Math.ceil(Math.abs(diff) + 1.0));
        }
        return Math.floor(2.147483647E9 / maxDouble);
    }

    public static int encodeLinear(double[] data, int dataSize, byte[] result, double fixedPoint) {
        int i;
        long[] ints = new long[3];
        int ri = 16;
        byte[] halfBytes = new byte[10];
        int halfByteCount = 0;
        MSNumpress.encodeFixedPoint(fixedPoint, result);
        if (dataSize == 0) {
            return 8;
        }
        ints[1] = (long)(data[0] * fixedPoint + 0.5);
        for (i = 0; i < 4; ++i) {
            result[8 + i] = (byte)(ints[1] >> i * 8 & 0xFFL);
        }
        if (dataSize == 1) {
            return 12;
        }
        ints[2] = (long)(data[1] * fixedPoint + 0.5);
        for (i = 0; i < 4; ++i) {
            result[12 + i] = (byte)(ints[2] >> i * 8 & 0xFFL);
        }
        halfByteCount = 0;
        ri = 16;
        for (i = 2; i < dataSize; ++i) {
            ints[0] = ints[1];
            ints[1] = ints[2];
            ints[2] = (long)(data[i] * fixedPoint + 0.5);
            long extrapol = ints[1] + (ints[1] - ints[0]);
            long diff = ints[2] - extrapol;
            halfByteCount += MSNumpress.encodeInt(diff, halfBytes, halfByteCount);
            for (int hbi = 1; hbi < halfByteCount; hbi += 2) {
                result[ri++] = (byte)(halfBytes[hbi - 1] << 4 | halfBytes[hbi] & 0xF);
            }
            if (halfByteCount % 2 != 0) {
                halfBytes[0] = halfBytes[halfByteCount - 1];
                halfByteCount = 1;
                continue;
            }
            halfByteCount = 0;
        }
        if (halfByteCount == 1) {
            result[ri++] = (byte)(halfBytes[0] << 4);
        }
        return ri;
    }

    public static int decodeLinear(byte[] data, int dataSize, Double[] result) {
        int i;
        int ri = 2;
        long[] ints = new long[3];
        IntDecoder dec = new IntDecoder(data, 16);
        if (dataSize < 8) {
            return -1;
        }
        double fixedPoint = MSNumpress.decodeFixedPoint(data);
        if (dataSize < 12) {
            return -1;
        }
        ints[1] = 0L;
        for (i = 0; i < 4; ++i) {
            ints[1] = ints[1] | (0xFFL & (long)data[8 + i]) << i * 8;
        }
        result[0] = (double)ints[1] / fixedPoint;
        if (dataSize == 12) {
            return 1;
        }
        if (dataSize < 16) {
            return -1;
        }
        ints[2] = 0L;
        for (i = 0; i < 4; ++i) {
            ints[2] = ints[2] | (0xFFL & (long)data[12 + i]) << i * 8;
        }
        result[1] = (double)ints[2] / fixedPoint;
        while (!(dec.pos >= dataSize || dec.pos == dataSize - 1 && dec.half && (data[dec.pos] & 0xF) != 8)) {
            ints[0] = ints[1];
            ints[1] = ints[2];
            ints[2] = dec.next();
            long extrapol = ints[1] + (ints[1] - ints[0]);
            long y = extrapol + ints[2];
            result[ri++] = (double)y / fixedPoint;
            ints[2] = y;
        }
        return ri;
    }

    public static int encodePic(double[] data, int dataSize, byte[] result) {
        int ri = 0;
        int hbi = 0;
        byte[] halfBytes = new byte[10];
        int halfByteCount = 0;
        for (int i = 0; i < dataSize; ++i) {
            long count = (long)(data[i] + 0.5);
            halfByteCount += MSNumpress.encodeInt(count, halfBytes, halfByteCount);
            for (hbi = 1; hbi < halfByteCount; hbi += 2) {
                result[ri++] = (byte)(halfBytes[hbi - 1] << 4 | halfBytes[hbi] & 0xF);
            }
            if (halfByteCount % 2 != 0) {
                halfBytes[0] = halfBytes[halfByteCount - 1];
                halfByteCount = 1;
                continue;
            }
            halfByteCount = 0;
        }
        if (halfByteCount == 1) {
            result[ri++] = (byte)(halfBytes[0] << 4);
        }
        return ri;
    }

    public static int decodePic(byte[] data, int dataSize, Double[] result) {
        int ri = 0;
        IntDecoder dec = new IntDecoder(data, 0);
        while (!(dec.pos >= dataSize || dec.pos == dataSize - 1 && dec.half && (data[dec.pos] & 0xF) != 8)) {
            long count = dec.next();
            result[ri++] = count;
        }
        return ri;
    }

    public static double optimalSlofFixedPoint(double[] data, int dataSize) {
        if (dataSize == 0) {
            return 0.0;
        }
        double maxDouble = 1.0;
        for (int i = 0; i < dataSize; ++i) {
            double x = Math.log(data[i] + 1.0);
            maxDouble = Math.max(maxDouble, x);
        }
        double fp = Math.floor(65535.0 / maxDouble);
        return fp;
    }

    public static int encodeSlof(double[] data, int dataSize, byte[] result, double fixedPoint) {
        int ri = 8;
        MSNumpress.encodeFixedPoint(fixedPoint, result);
        for (int i = 0; i < dataSize; ++i) {
            int x = (int)(Math.log(data[i] + 1.0) * fixedPoint + 0.5);
            result[ri++] = (byte)(0xFF & x);
            result[ri++] = (byte)(x >> 8);
        }
        return ri;
    }

    public static int decodeSlof(byte[] data, int dataSize, Double[] result) {
        int ri = 0;
        if (dataSize < 8) {
            return -1;
        }
        double fixedPoint = MSNumpress.decodeFixedPoint(data);
        for (int i = 8; i < dataSize; i += 2) {
            int x = 0xFF & data[i] | (0xFF & data[i + 1]) << 8;
            result[ri++] = Math.exp((double)(0xFFFF & x) / fixedPoint) - 1.0;
        }
        return ri;
    }
}

