/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.io;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzml.model.mzml.MzML;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.model.mzml.utilities.ModelConstants;
import uk.ac.ebi.jmzml.xml.jaxb.marshaller.MarshallerFactory;
import uk.ac.ebi.jmzml.xml.util.EscapingXMLStreamWriter;

public class MzMLMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(MzMLMarshaller.class);

    public <T extends MzMLObject> String marshall(T object) {
        StringWriter sw = new StringWriter();
        this.marshall(object, sw);
        return sw.toString();
    }

    public <T extends MzMLObject> void marshall(T object, OutputStream os) {
        this.marshall(object, new OutputStreamWriter(os));
    }

    public <T extends MzMLObject> void marshall(T object, Writer out) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot marshall a NULL object");
        }
        try {
            Marshaller marshaller = MarshallerFactory.getInstance().initializeMarshaller();
            if (!(object instanceof MzML)) {
                marshaller.setProperty("jaxb.fragment", true);
                if (logger.isDebugEnabled()) {
                    logger.debug("Object '" + object.getClass().getName() + "' will be treated as root element.");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Object '" + object.getClass().getName() + "' will be treated as fragment.");
            }
            QName aQName = ModelConstants.getQNameForClass(object.getClass());
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter xmlStreamWriter = factory.createXMLStreamWriter(out);
            IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter(new EscapingXMLStreamWriter(xmlStreamWriter));
            marshaller.marshal(new JAXBElement(aQName, object.getClass(), object), writer);
        }
        catch (JAXBException | XMLStreamException e) {
            logger.error("MzMLMarshaller.marshall", e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
    }
}

