/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.apl_parser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.tools.apl_parser.AplFile;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;

public class PeakList
implements Spectrum {
    private static Pattern peakPattern = Pattern.compile("\\s*([0-9.]+)\\t([0-9.]+)\\s*");
    private static Pattern headerPattern = Pattern.compile("\\s*RawFile: (.*) Index: ([0-9]+)\\s*");
    private Map<Double, Double> peakList;
    private String header;
    private Double mz;
    private String fragmentation;
    private String chargeState;
    private Integer index;

    public PeakList(String mgfQuery, int index) throws JMzReaderException {
        this.index = index;
        String[] lines = mgfQuery.trim().split("\n");
        boolean inAttributeSection = true;
        for (int nLineNumber = 0; nLineNumber < lines.length; ++nLineNumber) {
            String line = lines[nLineNumber].trim();
            if (line.length() < 1) continue;
            if (nLineNumber == 0 && !"peaklist start".equals(line)) {
                throw new JMzReaderException("MS2 query must start with 'peaklist start'");
            }
            if (nLineNumber == 0) continue;
            if (nLineNumber == lines.length - 1 && !"peaklist end".equals(line)) {
                throw new JMzReaderException("MS2 query must end with 'peaklist end'");
            }
            if (nLineNumber == lines.length - 1) continue;
            Matcher attributeMatcher = AplFile.attributePattern.matcher(line);
            if (inAttributeSection && attributeMatcher.find()) {
                if (attributeMatcher.groupCount() != 2) {
                    throw new JMzReaderException("Invalid attribute line encountered in MS2 query.");
                }
                String name = attributeMatcher.group(1);
                String value = attributeMatcher.group(2);
                this.saveAttribute(name, value);
                continue;
            }
            Matcher peakMatcher = peakPattern.matcher(line);
            if (!peakMatcher.find() || peakMatcher.groupCount() != 2) {
                throw new JMzReaderException("Invalid line encountered in MS2 query: " + line);
            }
            this.addPeak(Double.parseDouble(peakMatcher.group(1)), Double.parseDouble(peakMatcher.group(2)));
            inAttributeSection = false;
        }
    }

    private void saveAttribute(String name, String value) throws JMzReaderException {
        if ("header".equals(name)) {
            this.header = value;
        } else if ("mz".equals(name)) {
            this.mz = Double.parseDouble(value);
        } else if ("fragmentation".equals(name)) {
            this.fragmentation = value;
        } else if ("charge".equals(name)) {
            this.chargeState = value;
        } else {
            throw new JMzReaderException("Unknown peptide property '" + name + "' encountered");
        }
    }

    public void addPeak(Double mz, Double intensity) {
        if (this.peakList == null) {
            this.peakList = new HashMap<Double, Double>(1);
        }
        this.peakList.put(mz, intensity);
    }

    @Override
    public String getId() {
        if (this.index == null) {
            return null;
        }
        return this.index.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        try {
            if (this.chargeState.contains(",")) {
                return null;
            }
            if (this.chargeState.contains("-")) {
                return Integer.parseInt(this.chargeState);
            }
            return Integer.parseInt(this.chargeState.replace("+", ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Double getPrecursorMZ() {
        return this.mz;
    }

    @Override
    public Double getPrecursorIntensity() {
        return null;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public Integer getMsLevel() {
        return 2;
    }

    @Override
    public ParamGroup getAdditional() {
        return null;
    }

    public String toString() {
        StringBuilder query = new StringBuilder("peaklist start\n");
        if (this.mz != null) {
            query.append("mz=").append(this.mz).append('\n');
        }
        if (this.fragmentation != null) {
            query.append("fragmentation=").append(this.fragmentation).append('\n');
        }
        if (this.chargeState != null) {
            query.append("charge=").append(this.chargeState).append('\n');
        }
        if (this.header != null) {
            query.append("header=").append(this.header).append('\n');
        }
        ArrayList<Double> masses = new ArrayList<Double>(this.peakList.keySet());
        Collections.sort(masses);
        for (Double mz : masses) {
            query.append(mz).append('\t').append(this.peakList.get(mz)).append('\n');
        }
        query.append("peaklist end\n");
        return query.toString();
    }
}

