/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.AbstractCodepageDetector;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.UnknownCharset;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public class UnicodeDetector
extends AbstractCodepageDetector {
    private static ICodepageDetector instance;

    private UnicodeDetector() {
    }

    public static ICodepageDetector getInstance() {
        if (instance == null) {
            instance = new UnicodeDetector();
        }
        return instance;
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        byte[] bom = new byte[4];
        in.read(bom, 0, 4);
        int b = -17;
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[2] == -1) {
            return Charset.forName("UTF-32BE");
        }
        if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[2] == 0) {
            return Charset.forName("UTF-32LE");
        }
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            return Charset.forName("UTF-8");
        }
        if (bom[0] == -1 && bom[1] == -2) {
            return Charset.forName("UTF-16LE");
        }
        if (bom[0] == -2 && bom[1] == -1) {
            return Charset.forName("UTF-16BE");
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            return Charset.forName("UCS-4");
        }
        return UnknownCharset.getInstance();
    }

    public Charset detectCodepage(URL url) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        Charset result = this.detectCodepage(in, Integer.MAX_VALUE);
        in.close();
        return result;
    }
}

